/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.postprocess;

import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.transforms.SmoothedFloat;
import org.lwjgl.opengl.GL11C;

public class CenterDepthSampler {
    private final SmoothedFloat centerDepthSmooth;
    private final GlFramebuffer depthBufferHolder;
    private final RenderTargets renderTargets;
    private boolean hasFirstSample;
    private boolean everRetrieved;

    public CenterDepthSampler(RenderTargets renderTargets, FrameUpdateNotifier updateNotifier) {
        this.centerDepthSmooth = new SmoothedFloat(1.0f, this::sampleCenterDepth, updateNotifier);
        this.depthBufferHolder = renderTargets.createFramebufferWritingToMain(new int[]{0});
        this.renderTargets = renderTargets;
    }

    private float sampleCenterDepth() {
        if (this.hasFirstSample && !this.everRetrieved) {
            return 0.0f;
        }
        this.hasFirstSample = true;
        this.depthBufferHolder.bind();
        float[] depthValue = new float[1];
        GL11C.glReadPixels((int)(this.renderTargets.getCurrentWidth() / 2), (int)(this.renderTargets.getCurrentHeight() / 2), (int)1, (int)1, (int)6402, (int)5126, (float[])depthValue);
        return depthValue[0];
    }

    public float getCenterDepthSmoothSample() {
        this.everRetrieved = true;
        return this.centerDepthSmooth.getAsFloat();
    }
}

