/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.batchedentityrendering.impl.BatchingDebugMessageHelper;
import net.coderbot.batchedentityrendering.impl.DrawCallTrackingRenderBuffers;
import net.coderbot.batchedentityrendering.impl.RenderBuffersExt;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gui.option.IrisVideoSettings;
import net.coderbot.iris.layer.GbufferProgram;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shadow.ShadowMatrices;
import net.coderbot.iris.shadows.CullingDataCache;
import net.coderbot.iris.shadows.Matrix4fAccess;
import net.coderbot.iris.shadows.ShadowMapRenderer;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.shadows.frustum.BoxCuller;
import net.coderbot.iris.shadows.frustum.CullEverythingFrustum;
import net.coderbot.iris.shadows.frustum.advanced.AdvancedShadowCullingFrustum;
import net.coderbot.iris.shadows.frustum.fallback.BoxCullingFrustum;
import net.coderbot.iris.shadows.frustum.fallback.NonCullingFrustum;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.minecraft.class_1044;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_898;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;

public class ShadowRenderer
implements ShadowMapRenderer {
    private final float halfPlaneLength;
    private final float renderDistanceMultiplier;
    private final int resolution;
    private final float intervalSize;
    public static class_1159 MODELVIEW;
    public static class_1159 ORTHO;
    private final WorldRenderingPipeline pipeline;
    private final ShadowRenderTargets targets;
    private final boolean packHasVoxelization;
    private final boolean packHasIndirectSunBounceGi;
    private final float sunPathRotation;
    private final class_4599 buffers;
    private final RenderBuffersExt RenderBuffersExt;
    private final RenderTargets gbufferRenderTargets;
    private final class_1044 normals;
    private final class_1044 specular;
    private final IntSupplier noise;
    private final List<MipmapPass> mipmapPasses = new ArrayList<MipmapPass>();
    private final Object2ObjectMap<String, IntSupplier> customTextureIds;
    public static boolean ACTIVE;
    public static List<class_2586> visibleBlockEntities;
    private final String debugStringOverall;
    private String debugStringShadowDistance = "(unavailable)";
    private String debugStringShadowCulling = "(unavailable)";
    private String debugStringTerrain = "(unavailable)";
    private int renderedShadowEntities = 0;
    private int renderedShadowBlockEntities = 0;

    public ShadowRenderer(WorldRenderingPipeline pipeline, ProgramSource shadow, PackDirectives directives, Supplier<ImmutableSet<Integer>> flipped, RenderTargets gbufferRenderTargets, class_1044 normals, class_1044 specular, IntSupplier noise, ProgramSet programSet, Object2ObjectMap<String, IntSupplier> customTextureIds) {
        String fsh;
        this.pipeline = pipeline;
        PackShadowDirectives shadowDirectives = directives.getShadowDirectives();
        this.halfPlaneLength = shadowDirectives.getDistance();
        this.renderDistanceMultiplier = shadowDirectives.getDistanceRenderMul();
        this.resolution = shadowDirectives.getResolution();
        this.intervalSize = shadowDirectives.getIntervalSize();
        this.debugStringOverall = "half plane = " + this.halfPlaneLength + " meters @ " + this.resolution + "x" + this.resolution;
        if (shadowDirectives.getFov() != null) {
            Iris.logger.warn("The shaderpack specifies a shadow FOV of " + shadowDirectives.getFov() + ", but Iris does not currently support perspective projections in the shadow pass.");
        }
        this.targets = new ShadowRenderTargets(this.resolution, new InternalTextureFormat[]{InternalTextureFormat.RGBA, InternalTextureFormat.RGBA});
        this.gbufferRenderTargets = gbufferRenderTargets;
        this.normals = normals;
        this.specular = specular;
        this.noise = noise;
        this.customTextureIds = customTextureIds;
        this.packHasVoxelization = shadow != null ? shadow.getGeometrySource().isPresent() : false;
        ProgramSource[] composite = programSet.getComposite();
        this.packHasIndirectSunBounceGi = composite.length > 0 ? (fsh = composite[0].getFragmentSource().orElse("")).contains("GI_QUALITY") && fsh.contains("GI_RENDER_RESOLUTION") && fsh.contains("GI_RADIUS") && fsh.contains("#define GI\t// Indirect lighting from sunlight.") && !fsh.contains("//#define GI\t// Indirect lighting from sunlight.") && !fsh.contains("// #define GI\t// Indirect lighting from sunlight.") : false;
        this.sunPathRotation = directives.getSunPathRotation();
        this.buffers = new class_4599();
        this.RenderBuffersExt = this.buffers instanceof RenderBuffersExt ? (RenderBuffersExt)this.buffers : null;
        this.configureSamplingSettings(shadowDirectives);
    }

    private void configureSamplingSettings(PackShadowDirectives shadowDirectives) {
        ImmutableList<PackShadowDirectives.DepthSamplingSettings> depthSamplingSettings = shadowDirectives.getDepthSamplingSettings();
        ImmutableList<PackShadowDirectives.SamplingSettings> colorSamplingSettings = shadowDirectives.getColorSamplingSettings();
        RenderSystem.activeTexture((int)33988);
        RenderSystem.bindTexture((int)this.getDepthTextureId());
        this.configureDepthSampler(this.getDepthTextureId(), (PackShadowDirectives.DepthSamplingSettings)depthSamplingSettings.get(0));
        RenderSystem.bindTexture((int)this.getDepthTextureNoTranslucentsId());
        this.configureDepthSampler(this.getDepthTextureNoTranslucentsId(), (PackShadowDirectives.DepthSamplingSettings)depthSamplingSettings.get(1));
        for (int i = 0; i < colorSamplingSettings.size(); ++i) {
            int glTextureId = this.targets.getColorTextureId(i);
            RenderSystem.bindTexture((int)glTextureId);
            this.configureSampler(glTextureId, (PackShadowDirectives.SamplingSettings)colorSamplingSettings.get(i));
        }
        RenderSystem.bindTexture((int)0);
        RenderSystem.activeTexture((int)33984);
    }

    private void configureDepthSampler(int glTextureId, PackShadowDirectives.DepthSamplingSettings settings) {
        if (settings.getHardwareFiltering()) {
            GL20C.glTexParameteri((int)3553, (int)34892, (int)34894);
        }
        this.configureSampler(glTextureId, settings);
    }

    private void configureSampler(int glTextureId, PackShadowDirectives.SamplingSettings settings) {
        if (settings.getMipmap()) {
            int filteringMode = settings.getNearest() ? 9984 : 9987;
            this.mipmapPasses.add(new MipmapPass(glTextureId, filteringMode));
        }
        if (!settings.getNearest()) {
            GL20C.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL20C.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL20C.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL20C.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
    }

    private void generateMipmaps() {
        RenderSystem.activeTexture((int)33988);
        for (MipmapPass mipmapPass : this.mipmapPasses) {
            RenderSystem.bindTexture((int)mipmapPass.getTexture());
            this.setupMipmappingForBoundTexture(mipmapPass.getTargetFilteringMode());
        }
        RenderSystem.bindTexture((int)0);
        RenderSystem.activeTexture((int)33984);
    }

    private void setupMipmappingForBoundTexture(int filteringMode) {
        GL30C.glGenerateMipmap((int)3553);
        GL30C.glTexParameteri((int)3553, (int)10241, (int)filteringMode);
    }

    private Program createProgram(ProgramSource source, PackDirectives directives, Supplier<ImmutableSet<Integer>> flipped) {
        ProgramBuilder builder;
        Objects.requireNonNull(source.getVertexSource());
        Objects.requireNonNull(source.getFragmentSource());
        try {
            builder = ProgramBuilder.begin(source.getName(), source.getVertexSource().orElse(null), source.getGeometrySource().orElse(null), source.getFragmentSource().orElse(null), IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Shader compilation failed!", e);
        }
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureIds);
        CommonUniforms.addCommonUniforms(builder, source.getParent().getPack().getIdMap(), directives, this.pipeline.getFrameUpdateNotifier(), FogMode.LINEAR);
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.gbufferRenderTargets, false);
        IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this.normals, this.specular);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noise);
        IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this);
        return builder.build();
    }

    private static void setupAttributes(Program program) {
        ShadowRenderer.setupAttribute(program, "mc_Entity", 10, -1.0f, -1.0f, -1.0f, -1.0f);
        ShadowRenderer.setupAttribute(program, "mc_midTexCoord", 11, 0.0f, 0.0f, 0.0f, 0.0f);
        ShadowRenderer.setupAttribute(program, "at_tangent", 12, 1.0f, 0.0f, 0.0f, 1.0f);
    }

    private static void setupAttribute(Program program, String name, int expectedLocation, float v0, float v1, float v2, float v3) {
        int location = GL20.glGetAttribLocation((int)program.getProgramId(), (CharSequence)name);
        if (location != -1) {
            if (location != expectedLocation) {
                throw new IllegalStateException();
            }
            GL20.glVertexAttrib4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
        }
    }

    public static class_4587 createShadowModelView(float sunPathRotation, float intervalSize) {
        class_243 cameraPos = CameraUniforms.getCameraPosition();
        double cameraX = cameraPos.method_10216();
        double cameraY = cameraPos.method_10214();
        double cameraZ = cameraPos.method_10215();
        class_4587 modelView = new class_4587();
        ShadowMatrices.createModelViewMatrix(modelView.method_23760().method_23761(), ShadowRenderer.getShadowAngle(), intervalSize, sunPathRotation, cameraX, cameraY, cameraZ);
        return modelView;
    }

    private class_4604 createShadowFrustum() {
        BoxCuller boxCuller;
        if (this.packHasVoxelization || this.packHasIndirectSunBounceGi) {
            double distance = this.halfPlaneLength * this.renderDistanceMultiplier;
            String reason = this.packHasVoxelization ? "(voxelization detected)" : "(indirect sunlight GI detected)";
            if (distance <= 0.0 || distance > (double)(class_310.method_1551().field_1690.field_1870 * 16)) {
                this.debugStringShadowDistance = "render distance = " + class_310.method_1551().field_1690.field_1870 * 16 + " blocks (capped by normal render distance)";
                this.debugStringShadowCulling = "disabled " + reason;
                return new NonCullingFrustum();
            }
            this.debugStringShadowDistance = "render distance = " + distance + " blocks (set by shader pack)";
            this.debugStringShadowCulling = "distance only " + reason;
            BoxCuller boxCuller2 = new BoxCuller(distance);
            return new BoxCullingFrustum(boxCuller2);
        }
        double distance = this.halfPlaneLength * this.renderDistanceMultiplier;
        String setter = "(set by shader pack)";
        if (this.renderDistanceMultiplier < 0.0f) {
            distance = IrisVideoSettings.shadowDistance * 16;
            setter = "(set by user)";
        }
        if (distance >= (double)(class_310.method_1551().field_1690.field_1870 * 16)) {
            this.debugStringShadowDistance = "render distance = " + class_310.method_1551().field_1690.field_1870 * 16 + " blocks (capped by normal render distance)";
            boxCuller = null;
        } else {
            this.debugStringShadowDistance = "render distance = " + distance + " blocks " + setter;
            if (distance == 0.0) {
                this.debugStringShadowCulling = "no shadows rendered";
                return new CullEverythingFrustum();
            }
            boxCuller = new BoxCuller(distance);
        }
        this.debugStringShadowCulling = "Advanced Frustum Culling enabled";
        class_1162 shadowLightPosition = new CelestialUniforms(this.sunPathRotation).getShadowLightPositionInWorldSpace();
        class_1160 shadowLightVectorFromOrigin = new class_1160(shadowLightPosition.method_4953(), shadowLightPosition.method_4956(), shadowLightPosition.method_4957());
        shadowLightVectorFromOrigin.method_4952();
        return new AdvancedShadowCullingFrustum(CapturedRenderingState.INSTANCE.getGbufferModelView(), CapturedRenderingState.INSTANCE.getGbufferProjection(), shadowLightVectorFromOrigin, boxCuller);
    }

    @Override
    public void renderShadows(LevelRendererAccessor worldRenderer, class_4184 playerCamera) {
        class_310 client = class_310.method_1551();
        worldRenderer.getLevel().method_16107().method_15405("shadows");
        ACTIVE = true;
        visibleBlockEntities = new ArrayList<class_2586>();
        class_4587 modelView = ShadowRenderer.createShadowModelView(this.sunPathRotation, this.intervalSize);
        MODELVIEW = modelView.method_23760().method_23761().method_22673();
        float[] orthoMatrix = ShadowMatrices.createOrthoMatrix(this.halfPlaneLength);
        ORTHO = new class_1159();
        ((Matrix4fAccess)ORTHO).copyFromArray(orthoMatrix);
        worldRenderer.getLevel().method_16107().method_15396("terrain_setup");
        if (worldRenderer instanceof CullingDataCache) {
            ((CullingDataCache)((Object)worldRenderer)).saveState();
        }
        worldRenderer.getLevel().method_16107().method_15396("initialize frustum");
        class_4604 frustum = this.createShadowFrustum();
        class_243 cameraPos = CameraUniforms.getCameraPosition();
        double cameraX = cameraPos.method_10216();
        double cameraY = cameraPos.method_10214();
        double cameraZ = cameraPos.method_10215();
        frustum.method_23088(cameraX, cameraY, cameraZ);
        worldRenderer.getLevel().method_16107().method_15407();
        boolean wasChunkCullingEnabled = client.field_1730;
        client.field_1730 = false;
        ((class_761)worldRenderer).method_3292();
        worldRenderer.invokeSetupRender(playerCamera, frustum, false, false);
        client.field_1730 = wasChunkCullingEnabled;
        worldRenderer.getLevel().method_16107().method_15405("terrain");
        this.pipeline.pushProgram(GbufferProgram.NONE);
        this.pipeline.beginShadowRender();
        this.setupShadowProgram();
        this.targets.getFramebuffer().bind();
        RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.clearDepth((double)1.0);
        RenderSystem.clear((int)16640, (boolean)false);
        RenderSystem.viewport((int)0, (int)0, (int)this.resolution, (int)this.resolution);
        FloatBuffer projMatBuf = FloatBuffer.allocate(16);
        projMatBuf.put(orthoMatrix);
        projMatBuf.flip();
        class_1159 projectionMatrix = new class_1159();
        projectionMatrix.method_35435(projMatBuf);
        class_1159 previousProjectionMatrix = RenderSystem.getProjectionMatrix();
        RenderSystem.setProjectionMatrix((class_1159)projectionMatrix);
        RenderSystem.disableCull();
        worldRenderer.invokeRenderChunkLayer(class_1921.method_23577(), modelView, cameraX, cameraY, cameraZ, projectionMatrix);
        worldRenderer.invokeRenderChunkLayer(class_1921.method_23581(), modelView, cameraX, cameraY, cameraZ, projectionMatrix);
        worldRenderer.invokeRenderChunkLayer(class_1921.method_23579(), modelView, cameraX, cameraY, cameraZ, projectionMatrix);
        this.setupShadowProgram();
        worldRenderer.getLevel().method_16107().method_15405("entities");
        float tickDelta = CapturedRenderingState.INSTANCE.getTickDelta();
        class_4604 entityShadowFrustum = frustum;
        if (this.RenderBuffersExt != null) {
            this.RenderBuffersExt.beginLevelRendering();
        }
        if (this.buffers instanceof DrawCallTrackingRenderBuffers) {
            ((DrawCallTrackingRenderBuffers)this.buffers).resetDrawCounts();
        }
        class_4597.class_4598 bufferSource = this.buffers.method_23000();
        class_898 dispatcher = worldRenderer.getEntityRenderDispatcher();
        int shadowEntities = 0;
        worldRenderer.getLevel().method_16107().method_15396("cull");
        ArrayList<class_1297> renderedEntities = new ArrayList<class_1297>(32);
        for (class_1297 entity2 : ShadowRenderer.getLevel().method_18112()) {
            if (!dispatcher.method_3950(entity2, entityShadowFrustum, cameraX, cameraY, cameraZ) || entity2.method_7325()) continue;
            renderedEntities.add(entity2);
        }
        worldRenderer.getLevel().method_16107().method_15405("sort");
        renderedEntities.sort(Comparator.comparingInt(entity -> entity.method_5864().hashCode()));
        worldRenderer.getLevel().method_16107().method_15405("build geometry");
        for (class_1297 entity2 : renderedEntities) {
            worldRenderer.invokeRenderEntity(entity2, cameraX, cameraY, cameraZ, tickDelta, modelView, (class_4597)bufferSource);
            ++shadowEntities;
        }
        worldRenderer.getLevel().method_16107().method_15407();
        worldRenderer.getLevel().method_16107().method_15405("build blockentities");
        int shadowBlockEntities = 0;
        for (class_2586 entity3 : visibleBlockEntities) {
            modelView.method_22903();
            class_2338 pos = entity3.method_11016();
            modelView.method_22904((double)pos.method_10263() - cameraX, (double)pos.method_10264() - cameraY, (double)pos.method_10260() - cameraZ);
            class_310.method_1551().method_31975().method_3555(entity3, tickDelta, modelView, (class_4597)bufferSource);
            modelView.method_22909();
            ++shadowBlockEntities;
        }
        this.renderedShadowEntities = shadowEntities;
        this.renderedShadowBlockEntities = shadowBlockEntities;
        worldRenderer.getLevel().method_16107().method_15405("draw entities");
        bufferSource.method_22993();
        worldRenderer.getLevel().method_16107().method_15405("translucent depth copy");
        this.targets.getFramebuffer().bindAsReadBuffer();
        RenderSystem.activeTexture((int)33984);
        RenderSystem.bindTexture((int)this.targets.getDepthTextureNoTranslucents().getTextureId());
        GL20C.glCopyTexImage2D((int)3553, (int)0, (int)6402, (int)0, (int)0, (int)this.resolution, (int)this.resolution, (int)0);
        RenderSystem.bindTexture((int)0);
        worldRenderer.getLevel().method_16107().method_15405("translucent terrain");
        worldRenderer.invokeRenderChunkLayer(class_1921.method_23583(), modelView, cameraX, cameraY, cameraZ, projectionMatrix);
        if (this.RenderBuffersExt != null) {
            this.RenderBuffersExt.endLevelRendering();
        }
        RenderSystem.setProjectionMatrix((class_1159)previousProjectionMatrix);
        this.debugStringTerrain = ((class_761)worldRenderer).method_3289();
        worldRenderer.getLevel().method_16107().method_15405("generate mipmaps");
        this.generateMipmaps();
        worldRenderer.getLevel().method_16107().method_15407();
        RenderSystem.enableCull();
        this.pipeline.endShadowRender();
        this.pipeline.popProgram(GbufferProgram.NONE);
        class_310.method_1551().method_1522().method_1235(false);
        RenderSystem.viewport((int)0, (int)0, (int)client.method_22683().method_4489(), (int)client.method_22683().method_4506());
        if (worldRenderer instanceof CullingDataCache) {
            ((CullingDataCache)((Object)worldRenderer)).restoreState();
        }
        visibleBlockEntities = null;
        ACTIVE = false;
        worldRenderer.getLevel().method_16107().method_15405("updatechunks");
    }

    @Override
    public void addDebugText(List<String> messages) {
        messages.add("[Iris] Shadow Maps: " + this.debugStringOverall);
        messages.add("[Iris] Shadow Distance: " + this.debugStringShadowDistance);
        messages.add("[Iris] Shadow Culling: " + this.debugStringShadowCulling);
        messages.add("[Iris] Shadow Terrain: " + this.debugStringTerrain);
        messages.add("[Iris] Shadow Entities: " + this.getEntitiesDebugString());
        messages.add("[Iris] Shadow Block Entities: " + this.getBlockEntitiesDebugString());
        if (this.buffers instanceof DrawCallTrackingRenderBuffers) {
            DrawCallTrackingRenderBuffers drawCallTracker = (DrawCallTrackingRenderBuffers)this.buffers;
            messages.add("[Iris] Shadow Entity Batching: " + BatchingDebugMessageHelper.getDebugMessage(drawCallTracker));
        }
    }

    private void setupShadowProgram() {
        RenderSystem.viewport((int)0, (int)0, (int)this.resolution, (int)this.resolution);
    }

    private String getEntitiesDebugString() {
        return this.renderedShadowEntities + "/" + class_310.method_1551().field_1687.method_18120();
    }

    private String getBlockEntitiesDebugString() {
        return this.renderedShadowBlockEntities + "";
    }

    private static class_638 getLevel() {
        return Objects.requireNonNull(class_310.method_1551().field_1687);
    }

    private static float getSkyAngle() {
        return ShadowRenderer.getLevel().method_30274(CapturedRenderingState.INSTANCE.getTickDelta());
    }

    private static float getSunAngle() {
        float skyAngle = ShadowRenderer.getSkyAngle();
        if (skyAngle < 0.75f) {
            return skyAngle + 0.25f;
        }
        return skyAngle - 0.75f;
    }

    private static float getShadowAngle() {
        float shadowAngle = ShadowRenderer.getSunAngle();
        if (!CelestialUniforms.isDay()) {
            shadowAngle -= 0.5f;
        }
        return shadowAngle;
    }

    @Override
    public int getDepthTextureId() {
        return this.targets.getDepthTexture().getTextureId();
    }

    @Override
    public int getDepthTextureNoTranslucentsId() {
        return this.targets.getDepthTextureNoTranslucents().getTextureId();
    }

    @Override
    public int getColorTexture0Id() {
        return this.targets.getColorTextureId(0);
    }

    @Override
    public int getColorTexture1Id() {
        return this.targets.getColorTextureId(1);
    }

    @Override
    public void destroy() {
        this.targets.destroy();
    }

    public GlFramebuffer getFramebuffer() {
        return this.targets.getFramebuffer();
    }

    static {
        ACTIVE = false;
    }

    private static class MipmapPass {
        private final int texture;
        private final int targetFilteringMode;

        public MipmapPass(int texture, int targetFilteringMode) {
            this.texture = texture;
            this.targetFilteringMode = targetFilteringMode;
        }

        public int getTexture() {
            return this.texture;
        }

        public int getTargetFilteringMode() {
            return this.targetFilteringMode;
        }
    }
}

