/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import net.coderbot.iris.gl.GlResource;
import org.lwjgl.opengl.GL30C;

public class GlFramebuffer
extends GlResource {
    private final Int2IntMap attachments = new Int2IntArrayMap();

    public GlFramebuffer() {
        super(GlStateManager.glGenFramebuffers());
        this.bind();
    }

    public void addDepthAttachment(int texture) {
        this.bind();
        GL30C.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)texture, (int)0);
    }

    public void addColorAttachment(int index, int texture) {
        this.bind();
        GL30C.glFramebufferTexture2D((int)36160, (int)(36064 + index), (int)3553, (int)texture, (int)0);
        this.attachments.put(index, texture);
    }

    public void drawBuffers(int[] buffers) {
        this.bind();
        int[] glBuffers = new int[buffers.length];
        int index = 0;
        if (buffers.length > 8) {
            throw new IllegalArgumentException("Cannot write to more than 8 draw buffers");
        }
        for (int buffer : buffers) {
            if (buffer >= 8) {
                throw new IllegalArgumentException("Only 8 color attachments are supported, but an attempt was made to write to a color attachment with index " + buffer);
            }
            glBuffers[index++] = 36064 + buffer;
        }
        GL30C.glDrawBuffers((int[])glBuffers);
    }

    public void readBuffer(int buffer) {
        this.bind();
        GL30C.glReadBuffer((int)(36064 + buffer));
    }

    public int getColorAttachment(int index) {
        return this.attachments.get(index);
    }

    public void bind() {
        GlStateManager._glBindFramebuffer((int)36160, (int)this.getGlId());
    }

    public void bindAsReadBuffer() {
        GlStateManager._glBindFramebuffer((int)36008, (int)this.getGlId());
    }

    public void bindAsDrawBuffer() {
        GlStateManager._glBindFramebuffer((int)36009, (int)this.getGlId());
    }

    @Override
    protected void destroyInternal() {
        GlStateManager._glDeleteFramebuffers((int)this.getGlId());
    }

    public boolean isComplete() {
        this.bind();
        int status = GlStateManager.glCheckFramebufferStatus((int)36160);
        return status == 36053;
    }
}

