/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.zip.ZipException;
import net.coderbot.iris.config.IrisConfig;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.pipeline.FixedFunctionWorldRenderingPipeline;
import net.coderbot.iris.pipeline.PipelineManager;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.shaderpack.DimensionId;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class Iris
implements ClientModInitializer {
    public static final String MODID = "iris";
    public static final Logger logger = LogManager.getLogger((String)"iris");
    private static final String SODIUM_VERSION = "0.4.0-alpha5";
    public static final String SODIUM_DOWNLOAD_LINK = "https://www.curseforge.com/minecraft/mc-mods/sodium/files/3542074";
    private static Path shaderpacksDirectory;
    private static ShaderPack currentPack;
    private static String currentPackName;
    private static boolean internal;
    private static boolean sodiumInvalid;
    private static boolean sodiumInstalled;
    private static boolean physicsModInstalled;
    private static PipelineManager pipelineManager;
    private static IrisConfig irisConfig;
    private static FileSystem zipFileSystem;
    private static class_304 reloadKeybind;
    private static class_304 toggleShadersKeybind;
    private static class_304 shaderpackScreenKeybind;
    private static String IRIS_VERSION;
    public static DimensionId lastDimension;

    public void onInitializeClient() {
        FabricLoader.getInstance().getModContainer("sodium").ifPresent(modContainer -> {
            sodiumInstalled = true;
            String versionString = modContainer.getMetadata().getVersion().getFriendlyString();
            if (!versionString.startsWith(SODIUM_VERSION)) {
                sodiumInvalid = true;
            }
        });
        ModContainer iris = (ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow(() -> new IllegalStateException("Couldn't find the mod container for Iris"));
        IRIS_VERSION = iris.getMetadata().getVersion().getFriendlyString();
        physicsModInstalled = FabricLoader.getInstance().isModLoaded("physicsmod");
        try {
            Files.createDirectories(Iris.getShaderpacksDirectory(), new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.warn("Failed to create the shaderpacks directory!");
            logger.catching(Level.WARN, (Throwable)e);
        }
        irisConfig = new IrisConfig(FabricLoader.getInstance().getConfigDir().resolve("iris.properties"));
        try {
            irisConfig.initialize();
        }
        catch (IOException e) {
            logger.error("Failed to initialize Iris configuration, default values will be used instead");
            logger.catching(Level.ERROR, (Throwable)e);
        }
        reloadKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("iris.keybind.reload", class_3675.class_307.field_1668, 82, "iris.keybinds"));
        toggleShadersKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("iris.keybind.toggleShaders", class_3675.class_307.field_1668, 75, "iris.keybinds"));
        shaderpackScreenKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("iris.keybind.shaderPackSelection", class_3675.class_307.field_1668, 79, "iris.keybinds"));
        pipelineManager = new PipelineManager(Iris::createPipeline);
    }

    public static void onRenderSystemInit() {
        Iris.loadShaderpack();
    }

    public static void handleKeybinds(class_310 minecraft) {
        block12: {
            if (reloadKeybind.method_1436()) {
                try {
                    Iris.reload();
                    if (minecraft.field_1724 != null) {
                        minecraft.field_1724.method_7353((class_2561)new class_2588("iris.shaders.reloaded"), false);
                    }
                    break block12;
                }
                catch (Exception e) {
                    logger.error("Error while reloading Shaders for Iris!", (Throwable)e);
                    if (minecraft.field_1724 != null) {
                        minecraft.field_1724.method_7353((class_2561)new class_2588("iris.shaders.reloaded.failure", new Object[]{Throwables.getRootCause((Throwable)e).getMessage()}).method_27692(class_124.field_1061), false);
                    }
                    break block12;
                }
            }
            if (toggleShadersKeybind.method_1436()) {
                IrisConfig config = Iris.getIrisConfig();
                try {
                    config.setShadersEnabled(!config.areShadersEnabled());
                    config.save();
                    Iris.reload();
                    if (minecraft.field_1724 != null) {
                        minecraft.field_1724.method_7353((class_2561)new class_2588("iris.shaders.toggled", new Object[]{config.areShadersEnabled() ? currentPackName : "off"}), false);
                    }
                }
                catch (Exception e) {
                    logger.error("Error while toggling shaders!", (Throwable)e);
                    if (minecraft.field_1724 != null) {
                        minecraft.field_1724.method_7353((class_2561)new class_2588("iris.shaders.toggled.failure", new Object[]{Throwables.getRootCause((Throwable)e).getMessage()}).method_27692(class_124.field_1061), false);
                    }
                    Iris.setShadersDisabled();
                    currentPackName = "(off) [fallback, check your logs for errors]";
                }
            } else if (shaderpackScreenKeybind.method_1436()) {
                minecraft.method_1507((class_437)new ShaderPackScreen(null));
            }
        }
    }

    public static void loadShaderpack() {
        if (!irisConfig.areShadersEnabled()) {
            logger.info("Shaders are disabled because enableShaders is set to false in iris.properties");
            Iris.setShadersDisabled();
            return;
        }
        if (!irisConfig.isInternal()) {
            Optional<String> externalName = irisConfig.getShaderPackName();
            if (!externalName.isPresent()) {
                logger.info("Shaders are disabled because no valid shaderpack is selected");
                Iris.setShadersDisabled();
                return;
            }
            if (!Iris.loadExternalShaderpack(externalName.get())) {
                logger.warn("Falling back to normal rendering without shaders because the external shaderpack could not be loaded");
                Iris.setShadersDisabled();
                currentPackName = "(off) [fallback, check your logs for errors]";
            }
        } else {
            try {
                Iris.loadInternalShaderpack();
            }
            catch (Exception e) {
                logger.error("Something went terribly wrong, Iris was unable to load the internal shaderpack!");
                logger.catching(Level.ERROR, (Throwable)e);
                logger.warn("Falling back to normal rendering without shaders because the internal shaderpack could not be loaded");
                Iris.setShadersDisabled();
                currentPackName = "(off) [fallback, check your logs for errors]";
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadExternalShaderpack(String name) {
        Path shaderPackPath;
        Path shaderPackRoot;
        try {
            shaderPackRoot = Iris.getShaderpacksDirectory().resolve(name);
        }
        catch (InvalidPathException e) {
            logger.error("Failed to load the shaderpack \"{}\" because it contains invalid characters in its path", (Object)name);
            return false;
        }
        if (shaderPackRoot.toString().endsWith(".zip")) {
            Optional<Path> optionalPath;
            try {
                optionalPath = Iris.loadExternalZipShaderpack(shaderPackRoot);
            }
            catch (FileSystemNotFoundException | NoSuchFileException e) {
                logger.error("Failed to load the shaderpack \"{}\" because it does not exist in your shaderpacks folder!", (Object)name);
                return false;
            }
            catch (ZipException e) {
                logger.error("The shaderpack \"{}\" appears to be corrupted, please try downloading it again!", (Object)name);
                return false;
            }
            catch (IOException e) {
                logger.error("Failed to load the shaderpack \"{}\"!", (Object)name);
                logger.catching(Level.ERROR, (Throwable)e);
                return false;
            }
            if (!optionalPath.isPresent()) {
                logger.error("Could not load the shaderpack \"{}\" because it appears to lack a \"shaders\" directory", (Object)name);
                return false;
            }
            shaderPackPath = optionalPath.get();
        } else {
            if (!Files.exists(shaderPackRoot, new LinkOption[0])) {
                logger.error("Failed to load the shaderpack \"{}\" because it does not exist!", (Object)name);
                return false;
            }
            shaderPackPath = shaderPackRoot.resolve("shaders");
        }
        if (!Files.exists(shaderPackPath, new LinkOption[0])) {
            logger.error("Could not load the shaderpack \"{}\" because it appears to lack a \"shaders\" directory", (Object)name);
            return false;
        }
        try {
            currentPack = new ShaderPack(shaderPackPath);
        }
        catch (Exception e) {
            logger.error("Failed to load the shaderpack \"{}\"!", (Object)name);
            logger.catching((Throwable)e);
            return false;
        }
        currentPackName = name;
        internal = false;
        logger.info("Using shaderpack: " + name);
        return true;
    }

    private static Optional<Path> loadExternalZipShaderpack(Path shaderpackPath) throws IOException {
        FileSystem zipSystem;
        zipFileSystem = zipSystem = FileSystems.newFileSystem(shaderpackPath, Iris.class.getClassLoader());
        Path root = zipSystem.getRootDirectories().iterator().next();
        Path potentialShaderDir = zipSystem.getPath("shaders", new String[0]);
        if (Files.exists(potentialShaderDir, new LinkOption[0])) {
            return Optional.of(potentialShaderDir);
        }
        return Files.walk(root, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> path.endsWith("shaders")).findFirst();
    }

    private static void loadInternalShaderpack() {
        Path root = ((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow(() -> new RuntimeException("Failed to get the mod container for Iris!"))).getRootPath();
        try {
            currentPack = new ShaderPack(root.resolve("shaders"));
        }
        catch (IOException e) {
            logger.error("Failed to load internal shaderpack!");
            throw new RuntimeException("Failed to load internal shaderpack!", e);
        }
        logger.info("Using internal shaders");
        currentPackName = "(internal)";
        internal = true;
    }

    private static void setShadersDisabled() {
        currentPack = null;
        currentPackName = "(off)";
        internal = false;
        logger.info("Shaders are disabled");
    }

    public static boolean isValidShaderpack(Path pack) {
        if (Files.isDirectory(pack, new LinkOption[0])) {
            if (pack.equals(Iris.getShaderpacksDirectory())) {
                return false;
            }
            try {
                return Files.walk(pack, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> !path.equals(pack)).anyMatch(path -> path.endsWith("shaders"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (pack.toString().endsWith(".zip")) {
            try {
                FileSystem zipSystem = FileSystems.newFileSystem(pack, Iris.class.getClassLoader());
                Path root = zipSystem.getRootDirectories().iterator().next();
                return Files.walk(root, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).anyMatch(path -> path.endsWith("shaders"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void reload() throws IOException {
        irisConfig.initialize();
        Iris.destroyEverything();
        Iris.loadShaderpack();
    }

    private static void destroyEverything() {
        currentPack = null;
        pipelineManager.destroyPipeline();
        if (zipFileSystem != null) {
            try {
                zipFileSystem.close();
            }
            catch (NoSuchFileException e) {
                logger.warn("Failed to close the shaderpack zip when reloading because it was deleted, proceeding anyways.");
            }
            catch (IOException e) {
                logger.error("Failed to close zip file system?", (Throwable)e);
            }
        }
    }

    public static DimensionId getCurrentDimension() {
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            class_5321 worldRegistryKey = level.method_27983();
            if (worldRegistryKey.equals(class_1937.field_25181)) {
                return DimensionId.END;
            }
            if (worldRegistryKey.equals(class_1937.field_25180)) {
                return DimensionId.NETHER;
            }
            return DimensionId.OVERWORLD;
        }
        return lastDimension;
    }

    private static WorldRenderingPipeline createPipeline(DimensionId dimensionId) {
        if (currentPack == null) {
            return new FixedFunctionWorldRenderingPipeline();
        }
        ProgramSet programs = currentPack.getProgramSet(dimensionId);
        try {
            return new NewWorldRenderingPipeline(programs);
        }
        catch (Throwable e) {
            logger.error("Couldn't load NewWorldRenderingPipeline, falling back to vanilla shaders.", e);
            return new FixedFunctionWorldRenderingPipeline();
        }
    }

    public static PipelineManager getPipelineManager() {
        return pipelineManager;
    }

    public static Optional<ShaderPack> getCurrentPack() {
        return Optional.ofNullable(currentPack);
    }

    public static String getCurrentPackName() {
        return currentPackName;
    }

    public static IrisConfig getIrisConfig() {
        return irisConfig;
    }

    public static String getVersion() {
        if (IRIS_VERSION == null || IRIS_VERSION.contains("${version}")) {
            return "Version info unknown!";
        }
        return IRIS_VERSION;
    }

    public static String getFormattedVersion() {
        String version = Iris.getVersion();
        class_124 color = version.endsWith("-dirty") || version.contains("unknown") ? class_124.field_1061 : (version.contains("+rev.") ? class_124.field_1076 : class_124.field_1060);
        return color + version;
    }

    public static boolean isSodiumInvalid() {
        return sodiumInvalid;
    }

    public static boolean isSodiumInstalled() {
        return sodiumInstalled;
    }

    public static boolean isPhysicsModInstalled() {
        return physicsModInstalled;
    }

    public static Path getShaderpacksDirectory() {
        if (shaderpacksDirectory == null) {
            shaderpacksDirectory = FabricLoader.getInstance().getGameDir().resolve("shaderpacks");
        }
        return shaderpacksDirectory;
    }

    static {
        lastDimension = DimensionId.OVERWORLD;
    }
}

