/*
 * Decompiled with CFR 0.152.
 */
package io.github.fourmisain.taxfreelevels;

import io.github.fourmisain.taxfreelevels.TaxFreeLevels;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfig
implements IMixinConfigPlugin {
    private final Set<String> disabledMixins = new HashSet<String>();

    public void onLoad(String mixinPackage) {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModMetadata metadata = container.getMetadata();
            if (!metadata.containsCustomValue(TaxFreeLevels.CUSTOM_OPTIONS_FIELD)) continue;
            for (Map.Entry entry : metadata.getCustomValue(TaxFreeLevels.CUSTOM_OPTIONS_FIELD).getAsObject()) {
                String key = (String)entry.getKey();
                CustomValue value = (CustomValue)entry.getValue();
                if (!key.startsWith("mixin.")) continue;
                String mixinName = key.substring("mixin.".length());
                if (value.getAsBoolean()) continue;
                TaxFreeLevels.LOGGER.debug("{} disabled {}", (Object)metadata.getId(), (Object)mixinName);
                this.disabledMixins.add(mixinName);
            }
        }
        if (!FabricLoader.getInstance().isModLoaded("reroll")) {
            this.disabledMixins.add("RerollMixin");
        }
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String mixinName = mixinClassName.substring(mixinClassName.lastIndexOf(".mixin") + ".mixin".length() + 1);
        return !this.disabledMixins.contains(mixinName);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

