/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.updater;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import ladysnake.illuminations.client.Illuminations;
import ladysnake.illuminations.client.config.Config;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_155;
import net.minecraft.class_310;
import org.apache.logging.log4j.Level;

public class IlluminationsUpdater {
    static final ArrayList<String> UNINSTALLER_PARAMS = new ArrayList();
    private static final String UPDATES_URL = "https://illuminations.uuid.gg/latest?version=";
    private static final String UNINSTALLER = "illuminations-uninstaller.jar";
    public static boolean NEW_UPDATE = false;

    public static void init() {
        if (Files.exists(Paths.get("mods/illuminations-uninstaller.jar", new String[0]), new LinkOption[0])) {
            try {
                Files.delete(Paths.get("mods/illuminations-uninstaller.jar", new String[0]));
            }
            catch (IOException e) {
                Illuminations.logger.log(Level.WARN, "Could not remove uninstaller because of I/O Error: " + e.getMessage());
            }
        }
        if (Config.isAutoUpdate()) {
            Pattern pattern = Pattern.compile("^illuminations.+\\.future$");
            try {
                Files.list(Path.of("mods", new String[0])).filter(mod -> pattern.matcher(mod.getFileName().toString()).find()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        Illuminations.logger.error("Failed to delete old mod file {}", path, (Object)e);
                    }
                });
            }
            catch (IOException e) {
                Illuminations.logger.error("Failed to delete old mod files", (Throwable)e);
            }
            if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
                Illuminations.logger.info("Looking for updates for Illuminations");
                String minecraftVersion = class_155.method_16673().getName();
                String modVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("illuminations").orElseThrow()).getMetadata().getVersion().getFriendlyString();
                CompletableFuture.supplyAsync(() -> {
                    block8: {
                        JsonObject jsonObject;
                        InputStreamReader reader = new InputStreamReader(new URL(UPDATES_URL + minecraftVersion).openStream());
                        try {
                            JsonParser jp = new JsonParser();
                            JsonElement jsonElement = jp.parse((Reader)reader);
                            jsonObject = jsonElement.getAsJsonObject();
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (MalformedURLException e) {
                                Illuminations.logger.error("Could not get update information because of malformed URL", (Throwable)e);
                                break block8;
                            }
                            catch (IOException e) {
                                Illuminations.logger.error("Could not get update information because of I/O Error", (Throwable)e);
                            }
                        }
                        ((Reader)reader).close();
                        return jsonObject;
                    }
                    return null;
                }).thenAcceptAsync(latestVersionJson -> {
                    block9: {
                        if (latestVersionJson != null) {
                            String latestVersion = latestVersionJson.get("version").getAsString();
                            String latestFileName = latestVersionJson.get("filename").getAsString() + ".future";
                            try {
                                if (SemanticVersion.parse((String)latestVersion).compareTo(SemanticVersion.parse((String)modVersion)) <= 0) break block9;
                                Illuminations.logger.log(Level.INFO, "Currently present version of Illuminations is " + modVersion + " while the latest version is " + latestVersion + "; downloading update");
                                try {
                                    URI uri;
                                    URL website = new URL(latestVersionJson.get("download").getAsString());
                                    ReadableByteChannel rbc = Channels.newChannel(website.openStream());
                                    FileOutputStream fos = new FileOutputStream("mods/" + latestFileName);
                                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                                    Illuminations.logger.log(Level.INFO, latestFileName + " downloaded");
                                    ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer("illuminations").orElseThrow();
                                    URL rootUrl = mod.getRootPath().toUri().toURL();
                                    URLConnection connection = rootUrl.openConnection();
                                    if (connection instanceof JarURLConnection && (uri = ((JarURLConnection)connection).getJarFileURL().toURI()).getScheme().equals("file")) {
                                        String oldFilePath = Paths.get(uri).toString();
                                        String oldFile = Paths.get(oldFilePath, new String[0]).getFileName().toString();
                                        UNINSTALLER_PARAMS.add(oldFile);
                                        UNINSTALLER_PARAMS.add(latestFileName);
                                        NEW_UPDATE = true;
                                    }
                                }
                                catch (MalformedURLException e) {
                                    Illuminations.logger.log(Level.ERROR, "Could not download update because of malformed URL: " + e.getMessage());
                                }
                                catch (IOException e) {
                                    Illuminations.logger.log(Level.ERROR, "Could not download update because of I/O Error: " + e.getMessage());
                                }
                                catch (URISyntaxException e) {
                                    Illuminations.logger.log(Level.ERROR, "Could not download update because of URI Syntax Error: " + e.getMessage());
                                }
                            }
                            catch (VersionParsingException e) {
                                e.printStackTrace();
                            }
                        } else {
                            Illuminations.logger.log(Level.WARN, "Update information could not be retrieved, auto-update will not be available");
                        }
                    }
                }, (Executor)class_310.method_1551());
            }
            Illuminations.logger.log(Level.INFO, "Adding shutdown hook for uninstaller to update Illuminations");
            InputStream in = Illuminations.class.getResourceAsStream("/illuminations-uninstaller.jar");
            try {
                Files.copy(in, Paths.get("mods/illuminations-uninstaller.jar", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    Illuminations.logger.log(Level.INFO, "Minecraft instance shutting down, starting the Illuminations uninstaller");
                    StringBuilder commandParams = new StringBuilder();
                    for (String uninstallerParam : UNINSTALLER_PARAMS) {
                        commandParams.append(" ").append(uninstallerParam);
                    }
                    Runtime.getRuntime().exec("java -jar mods/illuminations-uninstaller.jar" + commandParams);
                }
                catch (IOException e) {
                    Illuminations.logger.log(Level.ERROR, "Could not run uninstaller");
                    e.printStackTrace();
                }
            }));
        }
    }
}

