/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.Month;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiPredicate;
import ladysnake.illuminations.client.Rainbowlluminations;
import ladysnake.illuminations.client.config.Config;
import ladysnake.illuminations.client.config.DefaultConfig;
import ladysnake.illuminations.client.data.AuraData;
import ladysnake.illuminations.client.data.IlluminationData;
import ladysnake.illuminations.client.data.OverheadData;
import ladysnake.illuminations.client.data.PlayerCosmeticData;
import ladysnake.illuminations.client.enums.BiomeCategory;
import ladysnake.illuminations.client.enums.HalloweenFeatures;
import ladysnake.illuminations.client.particle.ChorusPetalParticle;
import ladysnake.illuminations.client.particle.EyesParticle;
import ladysnake.illuminations.client.particle.FireflyParticle;
import ladysnake.illuminations.client.particle.GlowwormParticle;
import ladysnake.illuminations.client.particle.PlanktonParticle;
import ladysnake.illuminations.client.particle.PoltergeistParticle;
import ladysnake.illuminations.client.particle.PrismarineCrystalParticle;
import ladysnake.illuminations.client.particle.PumpkinSpiritParticle;
import ladysnake.illuminations.client.particle.WillOWispParticle;
import ladysnake.illuminations.client.particle.WispTrailParticle;
import ladysnake.illuminations.client.particle.WispTrailParticleEffect;
import ladysnake.illuminations.client.particle.aura.AutumnLeavesParticle;
import ladysnake.illuminations.client.particle.aura.ChorusAuraParticle;
import ladysnake.illuminations.client.particle.aura.ConfettiParticle;
import ladysnake.illuminations.client.particle.aura.GhostlyAuraParticle;
import ladysnake.illuminations.client.particle.aura.GoldenrodAuraParticle;
import ladysnake.illuminations.client.particle.aura.PrismarineAuraParticle;
import ladysnake.illuminations.client.particle.aura.PrismaticConfettiParticle;
import ladysnake.illuminations.client.particle.aura.SculkTendrilParticle;
import ladysnake.illuminations.client.particle.aura.ShadowbringerParticle;
import ladysnake.illuminations.client.particle.aura.TwilightFireflyParticle;
import ladysnake.illuminations.client.particle.pet.JackoParticle;
import ladysnake.illuminations.client.particle.pet.PetParticle;
import ladysnake.illuminations.client.particle.pet.PlayerLanternParticle;
import ladysnake.illuminations.client.particle.pet.PlayerWispParticle;
import ladysnake.illuminations.client.particle.pet.PrideHeartParticle;
import ladysnake.illuminations.client.render.entity.feature.OverheadFeatureRenderer;
import ladysnake.illuminations.client.render.entity.model.hat.CrownModel;
import ladysnake.illuminations.client.render.entity.model.hat.HaloModel;
import ladysnake.illuminations.client.render.entity.model.hat.HornsModel;
import ladysnake.illuminations.client.render.entity.model.hat.TiaraModel;
import ladysnake.illuminations.client.render.entity.model.hat.VoidheartTiaraModel;
import ladysnake.illuminations.client.render.entity.model.hat.WreathModel;
import ladysnake.illuminations.client.render.entity.model.pet.LanternModel;
import ladysnake.illuminations.client.render.entity.model.pet.PrideHeartModel;
import ladysnake.illuminations.client.render.entity.model.pet.WillOWispModel;
import ladysnake.illuminations.updater.IlluminationsUpdater;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendereregistry.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4002;
import net.minecraft.class_5601;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_922;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class Illuminations
implements ClientModInitializer {
    public static final String MODID = "illuminations";
    public static final Logger logger = LogManager.getLogger((String)"Illuminations");
    public static final int EYES_VANISHING_DISTANCE = 5;
    public static final Gson COSMETICS_GSON = new GsonBuilder().registerTypeAdapter(PlayerCosmeticData.class, (Object)new PlayerCosmeticDataParser()).create();
    public static final BiPredicate<class_1937, class_2338> FIREFLY_LOCATION_PREDICATE = (world, blockPos) -> {
        class_2248 block = world.method_8320(blockPos).method_26204();
        return world.method_8597().method_29960() ? block == class_2246.field_10124 || block == class_2246.field_10243 : !(block != class_2246.field_10124 || !Config.doesFireflySpawnAlways() && !Illuminations.isNightTime(world) || !Config.doesFireflySpawnUnderground() && !world.method_8311(blockPos));
    };
    public static final BiPredicate<class_1937, class_2338> GLOWWORM_LOCATION_PREDICATE = (world, blockPos) -> world.method_8320(blockPos).method_26204() == class_2246.field_10543;
    public static final BiPredicate<class_1937, class_2338> PLANKTON_LOCATION_PREDICATE = (world, blockPos) -> world.method_8320(blockPos).method_26227().method_15767((class_3494)class_3486.field_15517) && world.method_22339(blockPos) < 2;
    public static final BiPredicate<class_1937, class_2338> EYES_LOCATION_PREDICATE = (world, blockPos) -> (Config.getHalloweenFeatures() == HalloweenFeatures.ENABLE && LocalDate.now().getMonth() == Month.OCTOBER || Config.getHalloweenFeatures() == HalloweenFeatures.ALWAYS) && (world.method_8320(blockPos).method_26204() == class_2246.field_10124 || world.method_8320(blockPos).method_26204() == class_2246.field_10543) && world.method_22339(blockPos) <= 0 && world.method_18459((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), 5.0, false) == null && world.method_27983().equals(class_1937.field_25179);
    public static final BiPredicate<class_1937, class_2338> WISP_LOCATION_PREDICATE = (world, blockPos) -> world.method_8320(blockPos).method_26164((class_3494)class_3481.field_23119);
    public static final class_5601 CROWN = new class_5601(new class_2960("illuminations", "crown"), "main");
    static final Type COSMETIC_SELECT_TYPE = new TypeToken<Map<UUID, PlayerCosmeticData>>(){}.getType();
    private static final String COSMETICS_URL = "https://illuminations.uuid.gg/data";
    public static ImmutableMap<String, AuraData> AURAS_DATA;
    public static ImmutableMap<String, class_2400> PETS_DATA;
    public static ImmutableMap<String, OverheadData> OVERHEADS_DATA;
    public static class_2400 FIREFLY;
    public static class_2400 GLOWWORM;
    public static class_2400 PLANKTON;
    public static class_2400 EYES;
    public static class_2400 CHORUS_PETAL;
    public static class_2400 WILL_O_WISP;
    public static class_2396<WispTrailParticleEffect> WISP_TRAIL;
    public static class_2400 PUMPKIN_SPIRIT;
    public static class_2400 POLTERGEIST;
    public static class_2400 PRISMARINE_CRYSTAL;
    public static class_2400 TWILIGHT_AURA;
    public static class_2400 GHOSTLY_AURA;
    public static class_2400 CHORUS_AURA;
    public static class_2400 AUTUMN_LEAVES_AURA;
    public static class_2400 SCULK_TENDRIL_AURA;
    public static class_2400 SHADOWBRINGER_AURA;
    public static class_2400 GOLDENROD_AURA;
    public static class_2400 CONFETTI_AURA;
    public static class_2400 PRISMATIC_CONFETTI_AURA;
    public static class_2400 PRISMARINE_AURA;
    public static class_2400 PRIDE_PET;
    public static class_2400 GAY_PRIDE_PET;
    public static class_2400 TRANS_PRIDE_PET;
    public static class_2400 JACKO_PET;
    public static class_2400 LESBIAN_PRIDE_PET;
    public static class_2400 BI_PRIDE_PET;
    public static class_2400 ACE_PRIDE_PET;
    public static class_2400 NB_PRIDE_PET;
    public static class_2400 INTERSEX_PRIDE_PET;
    public static class_2400 ARO_PRIDE_PET;
    public static class_2400 PAN_PRIDE_PET;
    public static class_2400 AGENDER_PRIDE_PET;
    public static class_2400 WILL_O_WISP_PET;
    public static class_2400 GOLDEN_WILL_PET;
    public static class_2400 FOUNDING_SKULL_PET;
    public static class_2400 DISSOLUTION_WISP_PET;
    public static class_2400 PUMPKIN_SPIRIT_PET;
    public static class_2400 POLTERGEIST_PET;
    public static class_2400 LANTERN_PET;
    public static class_2400 SOUL_LANTERN_PET;
    public static class_2400 CRYING_LANTERN_PET;
    public static class_2400 SOOTHING_LANTERN_PET;
    public static ImmutableMap<BiomeCategory, ImmutableSet<IlluminationData>> ILLUMINATIONS_BIOME_CATEGORIES;
    public static ImmutableMap<class_2960, ImmutableSet<IlluminationData>> ILLUMINATIONS_BIOMES;
    private static Map<UUID, PlayerCosmeticData> PLAYER_COSMETICS;

    @Nullable
    public static PlayerCosmeticData getCosmeticData(class_1657 player) {
        return PLAYER_COSMETICS.get(player.method_5667());
    }

    @Nullable
    public static PlayerCosmeticData getCosmeticData(UUID uuid) {
        return PLAYER_COSMETICS.get(uuid);
    }

    public static void loadPlayerCosmetics() {
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            block10: {
                Map map;
                InputStreamReader reader = new InputStreamReader(new URL(COSMETICS_URL).openStream());
                try {
                    if (Config.isDebugMode()) {
                        logger.log(Level.INFO, "Retrieving Illuminations cosmetics from the dashboard...");
                    }
                    map = (Map)COSMETICS_GSON.fromJson((Reader)reader, COSMETIC_SELECT_TYPE);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (MalformedURLException e) {
                        if (Config.isDebugMode()) {
                            logger.log(Level.ERROR, "Could not get player cosmetics because of malformed URL: " + e.getMessage());
                        }
                        break block10;
                    }
                    catch (IOException e) {
                        if (!Config.isDebugMode()) break block10;
                        logger.log(Level.ERROR, "Could not get player cosmetics because of I/O Error: " + e.getMessage());
                    }
                }
                ((Reader)reader).close();
                return map;
            }
            return null;
        }).exceptionally(throwable -> {
            if (Config.isDebugMode()) {
                logger.log(Level.ERROR, "Could not get player cosmetics because wtf is happening", throwable);
            }
            return null;
        })).thenAcceptAsync(playerData -> {
            if (playerData != null) {
                PLAYER_COSMETICS = playerData;
                if (Config.isDebugMode()) {
                    logger.log(Level.INFO, "Player cosmetics successfully registered");
                }
            } else {
                PLAYER_COSMETICS = Collections.emptyMap();
                if (Config.isDebugMode()) {
                    logger.log(Level.WARN, "Player cosmetics could not registered, cosmetics will be ignored");
                }
            }
        }, (Executor)class_310.method_1551());
    }

    public static boolean isNightTime(class_1937 world) {
        return (double)world.method_30274((float)world.method_8532()) >= 0.25965086 && (double)world.method_30274((float)world.method_8532()) <= 0.7403491;
    }

    public void onInitializeClient() {
        Config.load();
        Illuminations.loadPlayerCosmetics();
        if (!FabricLoader.getInstance().isDevelopmentEnvironment() && Config.isAutoUpdate()) {
            IlluminationsUpdater.init();
        }
        if (FabricLoader.getInstance().isModLoaded("satin")) {
            Rainbowlluminations.init();
        }
        FabricLoader.getInstance().getModContainer(MODID).ifPresent(modContainer -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960(MODID, "lowerres"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960(MODID, "pixelaccurate"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        });
        EntityModelLayerRegistry.registerModelLayer((class_5601)CrownModel.MODEL_LAYER, CrownModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)HornsModel.MODEL_LAYER, HornsModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)HaloModel.MODEL_LAYER, HaloModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)TiaraModel.MODEL_LAYER, TiaraModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)VoidheartTiaraModel.MODEL_LAYER, VoidheartTiaraModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)WreathModel.MODEL_LAYER, WreathModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)WillOWispModel.MODEL_LAYER, WillOWispModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)LanternModel.MODEL_LAYER, LanternModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)PrideHeartModel.MODEL_LAYER, PrideHeartModel::getTexturedModelData);
        FIREFLY = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:firefly", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)FIREFLY, FireflyParticle.DefaultFactory::new);
        GLOWWORM = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:glowworm", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)GLOWWORM, GlowwormParticle.DefaultFactory::new);
        PLANKTON = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:plankton", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)PLANKTON, PlanktonParticle.DefaultFactory::new);
        EYES = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:eyes", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)EYES, EyesParticle.DefaultFactory::new);
        CHORUS_PETAL = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:chorus_petal", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)CHORUS_PETAL, ChorusPetalParticle.DefaultFactory::new);
        WILL_O_WISP = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:will_o_wisp", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)WILL_O_WISP, fabricSpriteProvider -> new WillOWispParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/will_o_wisp.png"), 1.0f, 1.0f, 1.0f, -0.1f, -0.01f, 0.0f));
        WISP_TRAIL = (class_2396)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:wisp_trail", (Object)new class_2396<WispTrailParticleEffect>(true, WispTrailParticleEffect.PARAMETERS_FACTORY){

            public Codec<WispTrailParticleEffect> method_29138() {
                return WispTrailParticleEffect.CODEC;
            }
        });
        ParticleFactoryRegistry.getInstance().register(WISP_TRAIL, WispTrailParticle.Factory::new);
        PUMPKIN_SPIRIT = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:pumpkin_spirit", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)PUMPKIN_SPIRIT, fabricSpriteProvider -> new PumpkinSpiritParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/pumpkin_spirit.png"), 1.0f, 0.95f, 0.0f, 0.0f, -0.03f, 0.0f));
        POLTERGEIST = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:poltergeist", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)POLTERGEIST, fabricSpriteProvider -> new PoltergeistParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/poltergeist.png"), 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
        PRISMARINE_CRYSTAL = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:prismarine_crystal", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)PRISMARINE_CRYSTAL, PrismarineCrystalParticle.DefaultFactory::new);
        TWILIGHT_AURA = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:twilight_aura", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)TWILIGHT_AURA, TwilightFireflyParticle.DefaultFactory::new);
        GHOSTLY_AURA = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:ghostly_aura", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)GHOSTLY_AURA, GhostlyAuraParticle.DefaultFactory::new);
        CHORUS_AURA = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:chorus_aura", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)CHORUS_AURA, ChorusAuraParticle.DefaultFactory::new);
        AUTUMN_LEAVES_AURA = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:autumn_leaves", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)AUTUMN_LEAVES_AURA, AutumnLeavesParticle.DefaultFactory::new);
        SCULK_TENDRIL_AURA = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:sculk_tendril", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)SCULK_TENDRIL_AURA, SculkTendrilParticle.DefaultFactory::new);
        SHADOWBRINGER_AURA = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:shadowbringer_aura", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)SHADOWBRINGER_AURA, ShadowbringerParticle.DefaultFactory::new);
        GOLDENROD_AURA = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:goldenrod_aura", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)GOLDENROD_AURA, GoldenrodAuraParticle.DefaultFactory::new);
        CONFETTI_AURA = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:confetti", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)CONFETTI_AURA, ConfettiParticle.DefaultFactory::new);
        PRISMATIC_CONFETTI_AURA = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:prismatic_confetti", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)PRISMATIC_CONFETTI_AURA, PrismaticConfettiParticle.DefaultFactory::new);
        PRISMARINE_AURA = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:prismarine_aura", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)PRISMARINE_AURA, PrismarineAuraParticle.DefaultFactory::new);
        PRIDE_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:pride_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/pride_heart.png"), 1.0f, 1.0f, 1.0f));
        GAY_PRIDE_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:gay_pride_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)GAY_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/gay_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        TRANS_PRIDE_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:trans_pride_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)TRANS_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/trans_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        LESBIAN_PRIDE_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:lesbian_pride_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)LESBIAN_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/lesbian_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        BI_PRIDE_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:bi_pride_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)BI_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/bi_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        ACE_PRIDE_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:ace_pride_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)ACE_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/ace_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        NB_PRIDE_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:nb_pride_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)NB_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/nb_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        INTERSEX_PRIDE_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:intersex_pride_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)INTERSEX_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/intersex_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        ARO_PRIDE_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:aro_pride_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)ARO_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/aro_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        PAN_PRIDE_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:pan_pride_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)PAN_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/pan_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        AGENDER_PRIDE_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:agender_pride_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)AGENDER_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/agender_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        WILL_O_WISP_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:will_o_wisp_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)WILL_O_WISP_PET, fabricSpriteProvider -> new PlayerWispParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/will_o_wisp.png"), 1.0f, 1.0f, 1.0f, -0.1f, -0.01f, 0.0f));
        GOLDEN_WILL_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:golden_will_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)GOLDEN_WILL_PET, fabricSpriteProvider -> new PlayerWispParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/golden_will.png"), 1.0f, 0.3f, 1.0f, -0.05f, -0.01f, 0.0f));
        FOUNDING_SKULL_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:founding_skull_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)FOUNDING_SKULL_PET, fabricSpriteProvider -> new PlayerWispParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/founding_skull.png"), 1.0f, 0.0f, 0.25f, -0.03f, 0.0f, -0.01f));
        DISSOLUTION_WISP_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:dissolution_wisp_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)DISSOLUTION_WISP_PET, PetParticle.DefaultFactory::new);
        JACKO_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:jacko_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)JACKO_PET, JackoParticle.DefaultFactory::new);
        PUMPKIN_SPIRIT_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:pumpkin_spirit_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)PUMPKIN_SPIRIT_PET, fabricSpriteProvider -> new PlayerWispParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/pumpkin_spirit.png"), 1.0f, 0.95f, 0.0f, 0.0f, -0.03f, 0.0f));
        POLTERGEIST_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:poltergeist_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)POLTERGEIST_PET, fabricSpriteProvider -> new PlayerWispParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/poltergeist.png"), 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
        LANTERN_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:lantern_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)LANTERN_PET, fabricSpriteProvider -> new PlayerLanternParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/lantern.png"), 1.0f, 1.0f, 1.0f));
        SOUL_LANTERN_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:soul_lantern_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)SOUL_LANTERN_PET, fabricSpriteProvider -> new PlayerLanternParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/soul_lantern.png"), 1.0f, 1.0f, 1.0f));
        CRYING_LANTERN_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:crying_lantern_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)CRYING_LANTERN_PET, fabricSpriteProvider -> new PlayerLanternParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/crying_lantern.png"), 1.0f, 1.0f, 1.0f));
        SOOTHING_LANTERN_PET = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"illuminations:soothing_lantern_pet", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)SOOTHING_LANTERN_PET, fabricSpriteProvider -> new PlayerLanternParticle.DefaultFactory((class_4002)fabricSpriteProvider, new class_2960(MODID, "textures/entity/soothing_lantern.png"), 1.0f, 1.0f, 1.0f));
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
            if (entityType == class_1299.field_6097) {
                class_922 playerRenderer = entityRenderer;
                registrationHelper.register((class_3887)new OverheadFeatureRenderer((class_3883<class_742, class_591<class_742>>)playerRenderer, context));
            }
        });
        ImmutableMap.Builder biomeBuilder = ImmutableMap.builder();
        Config.getBiomeSettings().forEach((biome, settings) -> {
            ImmutableSet.Builder illuminationDataBuilder = ImmutableSet.builder();
            illuminationDataBuilder.add((Object)new IlluminationData(FIREFLY, FIREFLY_LOCATION_PREDICATE, () -> Float.valueOf(Config.getBiomeSettings((BiomeCategory)biome).fireflySpawnRate().spawnRate)));
            if (settings.glowwormSpawnRate() != null) {
                illuminationDataBuilder.add((Object)new IlluminationData(GLOWWORM, GLOWWORM_LOCATION_PREDICATE, () -> Float.valueOf(Config.getBiomeSettings((BiomeCategory)biome).glowwormSpawnRate().spawnRate)));
            }
            if (settings.planktonSpawnRate() != null) {
                illuminationDataBuilder.add((Object)new IlluminationData(PLANKTON, PLANKTON_LOCATION_PREDICATE, () -> Float.valueOf(Config.getBiomeSettings((BiomeCategory)biome).planktonSpawnRate().spawnRate)));
            }
            biomeBuilder.put((Object)biome, (Object)illuminationDataBuilder.build());
        });
        ILLUMINATIONS_BIOME_CATEGORIES = biomeBuilder.build();
        ILLUMINATIONS_BIOMES = ImmutableMap.builder().put((Object)new class_2960("minecraft:soul_sand_valley"), (Object)ImmutableSet.of((Object)new IlluminationData(WILL_O_WISP, WISP_LOCATION_PREDICATE, () -> Float.valueOf(Config.getWillOWispsSpawnRate().spawnRate)))).build();
        AURAS_DATA = ImmutableMap.builder().put((Object)"twilight", (Object)new AuraData(TWILIGHT_AURA, () -> DefaultConfig.getAuraSettings("twilight"))).put((Object)"ghostly", (Object)new AuraData(GHOSTLY_AURA, () -> DefaultConfig.getAuraSettings("ghostly"))).put((Object)"chorus", (Object)new AuraData(CHORUS_AURA, () -> DefaultConfig.getAuraSettings("chorus"))).put((Object)"autumn_leaves", (Object)new AuraData(AUTUMN_LEAVES_AURA, () -> DefaultConfig.getAuraSettings("autumn_leaves"))).put((Object)"sculk_tendrils", (Object)new AuraData(SCULK_TENDRIL_AURA, () -> DefaultConfig.getAuraSettings("sculk_tendrils"))).put((Object)"shadowbringer_soul", (Object)new AuraData(SHADOWBRINGER_AURA, () -> DefaultConfig.getAuraSettings("shadowbringer_soul"))).put((Object)"goldenrod", (Object)new AuraData(GOLDENROD_AURA, () -> DefaultConfig.getAuraSettings("goldenrod"))).put((Object)"confetti", (Object)new AuraData(CONFETTI_AURA, () -> DefaultConfig.getAuraSettings("confetti"))).put((Object)"prismatic_confetti", (Object)new AuraData(PRISMATIC_CONFETTI_AURA, () -> DefaultConfig.getAuraSettings("prismatic_confetti"))).put((Object)"prismarine", (Object)new AuraData(PRISMARINE_AURA, () -> DefaultConfig.getAuraSettings("prismarine"))).build();
        OVERHEADS_DATA = ImmutableMap.builder().put((Object)"solar_crown", (Object)new OverheadData(CrownModel::new, "solar_crown")).put((Object)"frost_crown", (Object)new OverheadData(CrownModel::new, "frost_crown")).put((Object)"pyro_crown", (Object)new OverheadData(CrownModel::new, "pyro_crown")).put((Object)"chorus_crown", (Object)new OverheadData(CrownModel::new, "chorus_crown")).put((Object)"bloodfiend_crown", (Object)new OverheadData(CrownModel::new, "bloodfiend_crown")).put((Object)"dreadlich_crown", (Object)new OverheadData(CrownModel::new, "dreadlich_crown")).put((Object)"mooncult_crown", (Object)new OverheadData(CrownModel::new, "mooncult_crown")).put((Object)"deepsculk_horns", (Object)new OverheadData(HornsModel::new, "deepsculk_horns")).put((Object)"springfae_horns", (Object)new OverheadData(HornsModel::new, "springfae_horns")).put((Object)"voidheart_tiara", (Object)new OverheadData(VoidheartTiaraModel::new, "voidheart_tiara")).put((Object)"worldweaver_halo", (Object)new OverheadData(HaloModel::new, "worldweaver_halo")).put((Object)"summerbreeze_wreath", (Object)new OverheadData(WreathModel::new, "summerbreeze_wreath")).put((Object)"glowsquid_cult_crown", (Object)new OverheadData(TiaraModel::new, "glowsquid_cult_crown")).put((Object)"timeaspect_cult_crown", (Object)new OverheadData(TiaraModel::new, "timeaspect_cult_crown")).put((Object)"prismarine_crown", (Object)new OverheadData(CrownModel::new, "prismarine_crown")).build();
        PETS_DATA = ImmutableMap.builder().put((Object)"pride", (Object)PRIDE_PET).put((Object)"gay_pride", (Object)GAY_PRIDE_PET).put((Object)"trans_pride", (Object)TRANS_PRIDE_PET).put((Object)"lesbian_pride", (Object)LESBIAN_PRIDE_PET).put((Object)"bi_pride", (Object)BI_PRIDE_PET).put((Object)"ace_pride", (Object)ACE_PRIDE_PET).put((Object)"nb_pride", (Object)NB_PRIDE_PET).put((Object)"intersex_pride", (Object)INTERSEX_PRIDE_PET).put((Object)"aro_pride", (Object)ARO_PRIDE_PET).put((Object)"pan_pride", (Object)PAN_PRIDE_PET).put((Object)"agender_pride", (Object)AGENDER_PRIDE_PET).put((Object)"jacko", (Object)JACKO_PET).put((Object)"will_o_wisp", (Object)WILL_O_WISP_PET).put((Object)"golden_will", (Object)GOLDEN_WILL_PET).put((Object)"founding_skull", (Object)FOUNDING_SKULL_PET).put((Object)"dissolution_wisp", (Object)DISSOLUTION_WISP_PET).put((Object)"pumpkin_spirit", (Object)PUMPKIN_SPIRIT_PET).put((Object)"poltergeist", (Object)POLTERGEIST_PET).put((Object)"lantern", (Object)LANTERN_PET).put((Object)"soul_lantern", (Object)SOUL_LANTERN_PET).put((Object)"crying_lantern", (Object)CRYING_LANTERN_PET).put((Object)"soothing_lantern", (Object)SOOTHING_LANTERN_PET).build();
    }

    static {
        PLAYER_COSMETICS = Collections.emptyMap();
    }

    private static class PlayerCosmeticDataParser
    implements JsonDeserializer<PlayerCosmeticData> {
        private PlayerCosmeticDataParser() {
        }

        public PlayerCosmeticData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            return new PlayerCosmeticData(jsonObject.get("aura"), jsonObject.get("color"), jsonObject.get("overhead"), jsonObject.get("drip"), jsonObject.get("pet"));
        }
    }
}

