/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.entry.comparison;

import dev.architectury.fluid.FluidStack;
import java.util.Objects;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.impl.Internals;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

@FunctionalInterface
public interface EntryComparator<T> {
    public static <T> EntryComparator<T> noop() {
        return (context, stack) -> 1L;
    }

    public static EntryComparator<class_1799> itemNbt() {
        EntryComparator<class_2520> nbtHasher = EntryComparator.nbt("Count");
        return (context, stack) -> {
            class_2487 tag = stack.method_7969();
            return tag == null ? 0L : nbtHasher.hash(context, (class_2520)tag);
        };
    }

    public static EntryComparator<FluidStack> fluidNbt() {
        EntryComparator<class_2520> nbtHasher = EntryComparator.nbt("Amount");
        return (context, stack) -> {
            class_2487 tag = stack.getTag();
            return tag == null ? 0L : nbtHasher.hash(context, (class_2520)tag);
        };
    }

    public static EntryComparator<class_2520> nbt(String ... ignoredKeys) {
        return Internals.getNbtHasher(ignoredKeys);
    }

    public long hash(ComparisonContext var1, T var2);

    default public EntryComparator<T> onlyExact() {
        EntryComparator self = this;
        return (context, stack) -> context.isExact() ? self.hash(context, stack) : 1L;
    }

    default public EntryComparator<T> then(EntryComparator<T> other) {
        Objects.requireNonNull(other);
        EntryComparator self = this;
        return (context, stack) -> {
            long hash = 1L;
            hash = hash * 31L + self.hash(context, stack);
            hash = hash * 31L + other.hash(context, stack);
            return hash;
        };
    }
}

