/*
 * Decompiled with CFR 0.152.
 */
package com.nebulae.stendhal.screens;

import com.nebulae.stendhal.screens.ImportBookScreen;
import com.nebulae.stendhal.utils.Book;
import com.nebulae.stendhal.utils.StendhalBook;
import com.nebulae.stendhal.utils.StendhalClipboard;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.LightweightGuiDescription;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WListPanel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlainPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import io.github.cottonmc.cotton.gui.widget.icon.ItemIcon;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ImportBookGUI
extends LightweightGuiDescription {
    public ImportBookGUI() {
        class_310 client = class_310.method_1551();
        WPlainPanel root = new WPlainPanel();
        this.setRootPanel((WPanel)root);
        root.setSize(300, 200);
        if (new File(FabricLoader.getInstance().getConfigDir() + "/stendhal/books").mkdirs()) {
            System.out.println("[Stendhal] Books folder created.");
        }
        WLabel labelScreen = new WLabel(class_2561.method_30163((String)("\u00a7l" + new class_2588("stendhal.bookImport").getString())).getString()).setHorizontalAlignment(HorizontalAlignment.CENTER);
        root.add((WWidget)labelScreen, 10, 10, root.getWidth() - 20, 20);
        WLabel labelBookDir = new WLabel(class_2561.method_30163((String)(new class_2588("stendhal.bookDir").getString() + " /.config/stendhal/books/")).getString(), 0x7D7D7D);
        root.add((WWidget)labelBookDir, 10, 40, root.getWidth() - 20, 20);
        WButton buttonCancel = new WButton((class_2561)new class_2585("x"));
        buttonCancel.setOnClick(() -> client.method_1507(StendhalClipboard.previousScreen));
        root.add((WWidget)buttonCancel, root.getWidth() - 30, 5, 20, 20);
        ArrayList<String> data = new ArrayList<String>();
        List<Book> allBooks = StendhalBook.getBooks();
        for (Book book2 : allBooks) {
            data.add(book2.getTitle().getString());
        }
        BiConsumer<String, StendhalListPanel> configurator = (s, book) -> {
            book.buttonLoad.setLabel(class_2561.method_30163((String)s));
            book.buttonLoad.setIcon((Icon)new ItemIcon(new class_1799((class_1935)class_1802.field_8674)));
            book.buttonLoad.setOnClick(() -> {
                for (Book thisBook : allBooks) {
                    if (!thisBook.getTitle().getString().equals(s)) continue;
                    StendhalBook.importBook = thisBook;
                    client.method_1507(StendhalClipboard.previousScreen);
                }
            });
            book.buttonDelete.setLabel((class_2561)new class_2588("stendhal.delete"));
            book.buttonDelete.setOnClick(() -> {
                String bookFile = s.replace(" ", "_").toLowerCase();
                new File(FabricLoader.getInstance().getConfigDir() + "/stendhal/books/" + bookFile + ".stendhal").delete();
                client.method_1507(StendhalClipboard.previousScreen);
                client.method_1507((class_437)new ImportBookScreen((GuiDescription)new ImportBookGUI()));
                System.out.println("Book " + bookFile + ".stendhal deleted");
            });
        };
        WListPanel list = new WListPanel(data, StendhalListPanel::new, configurator);
        list.setListItemHeight(20);
        root.add((WWidget)list, 0, 60, root.getWidth() - 10, 120);
        root.validate((GuiDescription)this);
    }

    public static class StendhalListPanel
    extends WPlainPanel {
        WButton buttonLoad = new WButton();
        WButton buttonDelete;

        public StendhalListPanel() {
            this.add((WWidget)this.buttonLoad, 10, 0, 180, 20);
            this.buttonDelete = new WButton((class_2561)new class_2588("stendhal.delete"));
            this.add((WWidget)this.buttonDelete, 200, 0, 75, 20);
            this.setSize(300, 20);
        }
    }
}

