/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.fabric;

import com.mojang.brigadier.CommandDispatcher;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.command.DumpCommand;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.debug.DumpGenerator;
import mcp.mobius.waila.fabric.FabricLegacyEventListener;
import mcp.mobius.waila.fabric.FabricPacketSender;
import mcp.mobius.waila.fabric.FabricPluginLoader;
import mcp.mobius.waila.impl.Impl;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.CommonUtil;
import mcp.mobius.waila.util.ModInfo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.tag.TagFactory;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2168;
import net.minecraft.class_2378;

public class FabricWaila
extends Waila
implements ModInitializer {
    public void onInitialize() {
        String[] mods;
        clientSide = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
        blockBlacklist = TagFactory.BLOCK.create(CommonUtil.id("blacklist"));
        entityBlacklist = TagFactory.ENTITY_TYPE.create(CommonUtil.id("blacklist"));
        CommonUtil.gameDir = FabricLoader.getInstance().getGameDir();
        CommonUtil.configDir = FabricLoader.getInstance().getConfigDir();
        FabricWaila.init();
        packet = new FabricPacketSender();
        packet.initMain();
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> DumpCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTING.register(server -> PluginConfig.INSTANCE.reload());
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            packet.sendBlacklistConfig((BlacklistConfig)blacklistConfig.get(), handler.field_14140);
            packet.sendPluginConfig(PluginConfig.INSTANCE, handler.field_14140);
        });
        ModInfo.register(new ModInfo("c", "Common"));
        ModInfo.supplier = namespace -> FabricLoader.getInstance().getModContainer(namespace).map(data -> new ModInfo(data.getMetadata().getId(), data.getMetadata().getName()));
        Registrar.INSTANCE.addEventListener(FabricLegacyEventListener.INSTANCE, 900);
        for (String mod : mods = new String[]{"minecraft", "java", "fabricloader", "fabric", "wthit", "roughlyenoughitems"}) {
            FabricLoader.getInstance().getModContainer(mod).map(ModContainer::getMetadata).ifPresent(m -> DumpGenerator.VERSIONS.put(m.getName(), m.getVersion().getFriendlyString()));
        }
        new FabricPluginLoader().loadPlugins();
    }

    static {
        Impl.reg(IModInfo.class, s -> ModInfo.get(s));
        Impl.reg(IModInfo.class, i -> ModInfo.get(class_2378.field_11142.method_10221((Object)i.method_7909()).method_12836()));
    }
}

