/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.mixin.accessor.ScreenHandlerAccessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1723.class})
public abstract class PlayerScreenHandlerMixin
extends class_1703
implements TrinketPlayerScreenHandler {
    @Shadow
    @Final
    private class_1657 field_7828;
    @Unique
    private final Map<SlotGroup, class_3545<Integer, Integer>> groupPos = new HashMap<SlotGroup, class_3545<Integer, Integer>>();
    @Unique
    private final Map<SlotGroup, List<class_3545<Integer, Integer>>> slotHeights = new HashMap<SlotGroup, List<class_3545<Integer, Integer>>>();
    @Unique
    private final Map<SlotGroup, List<SlotType>> slotTypes = new HashMap<SlotGroup, List<SlotType>>();
    @Unique
    private final Map<SlotGroup, Integer> slotWidths = new HashMap<SlotGroup, Integer>();
    @Unique
    private int trinketSlotStart = 0;
    @Unique
    private int trinketSlotEnd = 0;
    @Unique
    private int groupCount = 0;
    @Unique
    private class_1661 inventory;

    private PlayerScreenHandlerMixin() {
        super(null, 0);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void init(class_1661 playerInv, boolean onServer, class_1657 owner, CallbackInfo info) {
        this.inventory = playerInv;
        this.updateTrinketSlots(true);
    }

    @Override
    public void updateTrinketSlots(boolean slotsChanged) {
        TrinketsApi.getTrinketComponent((class_1309)this.field_7828).ifPresent(trinkets -> {
            if (slotsChanged) {
                trinkets.update();
            }
            Map<String, SlotGroup> groups = trinkets.getGroups();
            this.groupPos.clear();
            while (this.trinketSlotStart < this.trinketSlotEnd) {
                this.field_7761.remove(this.trinketSlotStart);
                ((ScreenHandlerAccessor)((Object)this)).getTrackedStacks().remove(this.trinketSlotStart);
                ((ScreenHandlerAccessor)((Object)this)).getPreviousTrackedStacks().remove(this.trinketSlotStart);
                --this.trinketSlotEnd;
            }
            int groupNum = 1;
            for (SlotGroup slotGroup : groups.values().stream().sorted(Comparator.comparing(SlotGroup::getOrder)).toList()) {
                int y;
                if (!this.hasSlots((TrinketComponent)trinkets, slotGroup)) continue;
                int id = slotGroup.getSlotId();
                if (id != -1) {
                    class_1735 slot;
                    if (this.field_7761.size() <= id || (slot = (class_1735)this.field_7761.get(id)) instanceof TrinketSlot) continue;
                    this.groupPos.put(slotGroup, (class_3545<Integer, Integer>)new class_3545((Object)slot.field_7873, (Object)slot.field_7872));
                    continue;
                }
                int x = 77;
                if (groupNum >= 4) {
                    x = 4 - groupNum / 4 * 18;
                    y = 8 + groupNum % 4 * 18;
                } else {
                    y = 62 - groupNum * 18;
                }
                this.groupPos.put(slotGroup, (class_3545<Integer, Integer>)new class_3545((Object)x, (Object)y));
                ++groupNum;
            }
            if (groupNum > 4) {
                this.groupCount = groupNum - 4;
            }
            this.trinketSlotStart = this.field_7761.size();
            this.slotWidths.clear();
            this.slotHeights.clear();
            this.slotTypes.clear();
            for (Map.Entry entry : trinkets.getInventory().entrySet()) {
                String groupId = (String)entry.getKey();
                SlotGroup group = groups.get(groupId);
                int groupOffset = 1;
                if (group.getSlotId() != -1) {
                    ++groupOffset;
                }
                int width = 0;
                class_3545<Integer, Integer> pos = this.getGroupPos(group);
                if (pos == null) continue;
                for (Map.Entry slot : ((Map)entry.getValue()).entrySet().stream().sorted((a, b) -> Integer.compare(((TrinketInventory)a.getValue()).getSlotType().getOrder(), ((TrinketInventory)b.getValue()).getSlotType().getOrder())).toList()) {
                    TrinketInventory stacks = (TrinketInventory)slot.getValue();
                    if (stacks.method_5439() == 0) continue;
                    int slotOffset = 1;
                    int x = (int)((double)((Integer)pos.method_15442()).intValue() + (double)(groupOffset / 2 * 18) * Math.pow(-1.0, groupOffset));
                    this.slotHeights.computeIfAbsent(group, k -> new ArrayList()).add(new class_3545((Object)x, (Object)stacks.method_5439()));
                    this.slotTypes.computeIfAbsent(group, k -> new ArrayList()).add(stacks.getSlotType());
                    for (int i = 0; i < stacks.method_5439(); ++i) {
                        int y = (int)((double)((Integer)pos.method_15441()).intValue() + (double)(slotOffset / 2 * 18) * Math.pow(-1.0, slotOffset));
                        this.method_7621(new TrinketSlot(stacks, i, x, y, group, stacks.getSlotType(), i, groupOffset == 1 && i == 0));
                        ++slotOffset;
                    }
                    ++groupOffset;
                    ++width;
                }
                this.slotWidths.put(group, width);
            }
            this.trinketSlotEnd = this.field_7761.size();
        });
    }

    @Unique
    private boolean hasSlots(TrinketComponent comp, SlotGroup group) {
        for (TrinketInventory inv : comp.getInventory().get(group.getName()).values()) {
            if (inv.method_5439() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public class_3545<Integer, Integer> getGroupPos(SlotGroup group) {
        return this.groupPos.get(group);
    }

    @Override
    public List<class_3545<Integer, Integer>> getSlotHeights(SlotGroup group) {
        return this.slotHeights.get(group);
    }

    @Override
    public List<SlotType> getSlotTypes(SlotGroup group) {
        return this.slotTypes.get(group);
    }

    @Override
    public int getSlotWidth(SlotGroup group) {
        return this.slotWidths.get(group);
    }

    @Override
    public int getGroupCount() {
        return this.groupCount;
    }

    @Inject(at={@At(value="HEAD")}, method={"close"})
    private void close(class_1657 player, CallbackInfo info) {
        if (player.field_6002.field_9236) {
            TrinketsClient.activeGroup = null;
            TrinketsClient.activeType = null;
            TrinketsClient.quickMoveGroup = null;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"transferSlot"}, cancellable=true)
    private void transferSlot(class_1657 player, int index, CallbackInfoReturnable<class_1799> info) {
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 stack = slot.method_7677();
            if (index >= this.trinketSlotStart && index < this.trinketSlotEnd) {
                if (!this.method_7616(stack, 9, 45, false)) {
                    info.setReturnValue((Object)class_1799.field_8037);
                } else {
                    info.setReturnValue((Object)stack);
                }
            } else if (index >= 9 && index < 45) {
                TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinkets -> {
                    for (int i = this.trinketSlotStart; i < this.trinketSlotEnd; ++i) {
                        class_1735 s = (class_1735)this.field_7761.get(i);
                        if (!(s instanceof TrinketSlot) || !s.method_7680(stack)) continue;
                        TrinketSlot ts = (TrinketSlot)s;
                        SlotType type = ts.getType();
                        SlotReference ref = new SlotReference((TrinketInventory)ts.field_7871, ts.method_34266());
                        boolean res = TrinketsApi.evaluatePredicateSet(type.getQuickMovePredicates(), stack, ref, (class_1309)player);
                        if (!res || !this.method_7616(stack, i, i + 1, false) || !player.field_6002.field_9236) continue;
                        TrinketsClient.quickMoveTimer = 20;
                        TrinketsClient.quickMoveGroup = TrinketsApi.getPlayerSlots().get(type.getGroup());
                        TrinketsClient.quickMoveType = ref.index() > 0 ? type : null;
                    }
                });
            }
        }
    }
}

