/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.common;

import fr.mrcraftcod.fallingtree.common.FallingTreeCommon;
import fr.mrcraftcod.fallingtree.common.leaf.LeafBreakingHandler;
import fr.mrcraftcod.fallingtree.common.wrapper.DirectionCompat;
import fr.mrcraftcod.fallingtree.common.wrapper.IBlock;
import fr.mrcraftcod.fallingtree.common.wrapper.IBlockPos;
import fr.mrcraftcod.fallingtree.common.wrapper.IBlockState;
import fr.mrcraftcod.fallingtree.common.wrapper.IComponent;
import fr.mrcraftcod.fallingtree.common.wrapper.IItem;
import fr.mrcraftcod.fallingtree.common.wrapper.ILevel;
import fr.mrcraftcod.fallingtree.common.wrapper.IPlayer;
import fr.raksrinana.fallingtree.forge.common.wrapper.BlockWrapper;
import fr.raksrinana.fallingtree.forge.common.wrapper.ComponentWrapper;
import fr.raksrinana.fallingtree.forge.common.wrapper.ItemWrapper;
import fr.raksrinana.fallingtree.forge.event.BlockBreakListener;
import fr.raksrinana.fallingtree.forge.event.FallingTreeBlockBreakEvent;
import fr.raksrinana.fallingtree.forge.event.FallingTreeEnchantments;
import fr.raksrinana.fallingtree.forge.event.LeafBreakingListener;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class FallingTreeCommonsImpl
extends FallingTreeCommon<Direction> {
    private final LeafBreakingHandler leafBreakingHandler = new LeafBreakingHandler(this);

    @Override
    @NotNull
    public IComponent translate(@NotNull String key, Object ... objects) {
        return new ComponentWrapper((MutableComponent)new TranslatableComponent(key, objects));
    }

    @Override
    @NotNull
    public LeafBreakingHandler getLeafBreakingHandler() {
        return this.leafBreakingHandler;
    }

    @Override
    @NotNull
    public Stream<IBlock> getBlock(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            ResourceLocation resourceLocation = new ResourceLocation(name);
            if (isTag) {
                return Optional.ofNullable(BlockTags.m_13115_().m_13404_(resourceLocation)).stream().map(Tag::m_6497_).flatMap(Collection::stream).map(BlockWrapper::new);
            }
            return Stream.of((Block)ForgeRegistries.BLOCKS.getValue(resourceLocation)).filter(Objects::nonNull).map(BlockWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    @NotNull
    public Stream<IItem> getItem(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            ResourceLocation resourceLocation = new ResourceLocation(name);
            if (isTag) {
                return Optional.ofNullable(ItemTags.m_13193_().m_13404_(resourceLocation)).stream().map(Tag::m_6497_).flatMap(Collection::stream).map(ItemWrapper::new);
            }
            return Stream.of((Item)ForgeRegistries.ITEMS.getValue(resourceLocation)).filter(Objects::nonNull).map(ItemWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    public boolean isLeafBlock(@NotNull IBlock block) {
        boolean isAllowedBlock;
        boolean bl = isAllowedBlock = BlockTags.f_13035_.m_8110_((Object)((Block)block.getRaw())) || this.getConfiguration().getTrees().getAllowedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
        if (isAllowedBlock) {
            boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
            return !isDeniedBlock;
        }
        return false;
    }

    @Override
    public boolean isLogBlock(@NotNull IBlock block) {
        boolean isAllowedBlock;
        boolean bl = isAllowedBlock = this.getConfiguration().getTrees().getDefaultLogsBlocks(this).stream().anyMatch(log -> log.equals(block)) || this.getConfiguration().getTrees().getAllowedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
        if (isAllowedBlock) {
            boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
            return !isDeniedBlock;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<IBlock> getAllNonStrippedLogsBlocks() {
        return BlockTags.f_13106_.m_6497_().stream().filter(block -> Optional.ofNullable(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block)).map(ResourceLocation::m_135815_).map(name -> name.startsWith("stripped")).orElse(false) == false).map(BlockWrapper::new).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public DirectionCompat asDirectionCompat(@NotNull Direction dir) {
        return DirectionCompat.valueOf(dir.name());
    }

    @Override
    @NotNull
    public Direction asDirection(@NotNull DirectionCompat dir) {
        return Direction.valueOf((String)dir.name());
    }

    @Override
    public boolean isNetherWartOrShroomlight(@NotNull IBlock block) {
        return BlockTags.f_13078_.m_8110_((Object)((Block)block.getRaw())) || Blocks.f_50701_.equals(block.getRaw());
    }

    @Override
    public boolean checkCanBreakBlock(@NotNull ILevel level, @NotNull IBlockPos blockPos, @NotNull IBlockState blockState, @NotNull IPlayer player) {
        return !MinecraftForge.EVENT_BUS.post((Event)new FallingTreeBlockBreakEvent((Level)level.getRaw(), (BlockPos)blockPos.getRaw(), (BlockState)blockState.getRaw(), (Player)player.getRaw()));
    }

    public void registerMod(@NotNull IEventBus eventBus) {
        FallingTreeEnchantments.register(eventBus);
    }

    public void registerForge(@NotNull IEventBus eventBus) {
        eventBus.register((Object)new BlockBreakListener(this));
        eventBus.register((Object)new LeafBreakingListener(this));
    }
}

