/*
 * Decompiled with CFR 0.152.
 */
package fr.mrcraftcod.fallingtree.common.tree.builder.position;

import fr.mrcraftcod.fallingtree.common.FallingTreeCommon;
import fr.mrcraftcod.fallingtree.common.tree.builder.ToAnalyzePos;
import fr.mrcraftcod.fallingtree.common.tree.builder.position.IPositionFetcher;
import fr.mrcraftcod.fallingtree.common.wrapper.IBlock;
import fr.mrcraftcod.fallingtree.common.wrapper.IBlockPos;
import fr.mrcraftcod.fallingtree.common.wrapper.ILevel;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AboveYFetcher
implements IPositionFetcher {
    private static AboveYFetcher INSTANCE;
    @NotNull
    private final FallingTreeCommon<?> mod;

    @Override
    @NotNull
    public Collection<ToAnalyzePos> getPositions(@NotNull ILevel level, @NotNull IBlockPos originPos, @NotNull ToAnalyzePos parent) {
        IBlockPos parentPos = parent.checkPos();
        IBlock parentBlock = level.getBlockState(parentPos).getBlock();
        return parentPos.betweenClosedStream(parentPos.above().north().east(), parentPos.below().south().west()).filter(pos -> pos.getY() > originPos.getY()).map(checkPos -> {
            IBlock checkBlock = level.getBlockState((IBlockPos)checkPos).getBlock();
            return new ToAnalyzePos(this, parentPos, parentBlock, checkPos.immutable(), checkBlock, this.mod.getTreePart(checkBlock), parent.sequence() + 1);
        }).collect(Collectors.toList());
    }

    public static AboveYFetcher getInstance(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new AboveYFetcher(common);
        }
        return INSTANCE;
    }

    private AboveYFetcher(@NotNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

