/*
 * Decompiled with CFR 0.152.
 */
package fr.mrcraftcod.fallingtree.common.config;

import com.google.gson.annotations.Expose;
import fr.mrcraftcod.fallingtree.common.config.ConfigLoader;
import fr.mrcraftcod.fallingtree.common.config.ToolConfiguration;
import fr.mrcraftcod.fallingtree.common.config.TreeConfiguration;
import fr.mrcraftcod.fallingtree.common.config.enums.NotificationMode;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    @Expose
    @NotNull
    private TreeConfiguration trees = new TreeConfiguration();
    @Expose
    @NotNull
    private ToolConfiguration tools = new ToolConfiguration();
    @Expose
    private boolean reverseSneaking = false;
    @Expose
    private boolean breakInCreative = false;
    @Expose
    @NotNull
    private NotificationMode notificationMode = NotificationMode.ACTION_BAR;

    public static Configuration read() throws RuntimeException {
        Path path = Configuration.getConfigPath();
        try {
            return ConfigLoader.loadConfig(new Configuration(), Configuration.class, path);
        }
        catch (IOException e) {
            log.error("Failed to get FallingTree configuration from {}, using default", (Object)path, (Object)e);
            return new Configuration();
        }
    }

    public void onUpdate() {
        this.trees.invalidate();
        this.tools.invalidate();
        Path path = Configuration.getConfigPath();
        try {
            ConfigLoader.saveConfig(this, path);
        }
        catch (IOException e) {
            log.error("Failed to saved FallingTree configuration to {}", (Object)path, (Object)e);
        }
    }

    private static Path getConfigPath() {
        return Paths.get(".", new String[0]).resolve("config").resolve("fallingtree.json");
    }

    private Configuration() {
    }

    @NotNull
    public TreeConfiguration getTrees() {
        return this.trees;
    }

    @NotNull
    public ToolConfiguration getTools() {
        return this.tools;
    }

    public boolean isReverseSneaking() {
        return this.reverseSneaking;
    }

    public boolean isBreakInCreative() {
        return this.breakInCreative;
    }

    @NotNull
    public NotificationMode getNotificationMode() {
        return this.notificationMode;
    }

    public void setTrees(@NotNull TreeConfiguration trees) {
        if (trees == null) {
            throw new NullPointerException("trees is marked non-null but is null");
        }
        this.trees = trees;
    }

    public void setTools(@NotNull ToolConfiguration tools) {
        if (tools == null) {
            throw new NullPointerException("tools is marked non-null but is null");
        }
        this.tools = tools;
    }

    public void setReverseSneaking(boolean reverseSneaking) {
        this.reverseSneaking = reverseSneaking;
    }

    public void setBreakInCreative(boolean breakInCreative) {
        this.breakInCreative = breakInCreative;
    }

    public void setNotificationMode(@NotNull NotificationMode notificationMode) {
        if (notificationMode == null) {
            throw new NullPointerException("notificationMode is marked non-null but is null");
        }
        this.notificationMode = notificationMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReverseSneaking() != other.isReverseSneaking()) {
            return false;
        }
        if (this.isBreakInCreative() != other.isBreakInCreative()) {
            return false;
        }
        TreeConfiguration this$trees = this.getTrees();
        TreeConfiguration other$trees = other.getTrees();
        if (this$trees == null ? other$trees != null : !((Object)this$trees).equals(other$trees)) {
            return false;
        }
        ToolConfiguration this$tools = this.getTools();
        ToolConfiguration other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        NotificationMode this$notificationMode = this.getNotificationMode();
        NotificationMode other$notificationMode = other.getNotificationMode();
        return !(this$notificationMode == null ? other$notificationMode != null : !((Object)((Object)this$notificationMode)).equals((Object)other$notificationMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReverseSneaking() ? 79 : 97);
        result = result * 59 + (this.isBreakInCreative() ? 79 : 97);
        TreeConfiguration $trees = this.getTrees();
        result = result * 59 + ($trees == null ? 43 : ((Object)$trees).hashCode());
        ToolConfiguration $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        NotificationMode $notificationMode = this.getNotificationMode();
        result = result * 59 + ($notificationMode == null ? 43 : ((Object)((Object)$notificationMode)).hashCode());
        return result;
    }

    public String toString() {
        return "Configuration(trees=" + this.getTrees() + ", tools=" + this.getTools() + ", reverseSneaking=" + this.isReverseSneaking() + ", breakInCreative=" + this.isBreakInCreative() + ", notificationMode=" + this.getNotificationMode() + ")";
    }
}

