/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util.biome;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import me.pepperbell.continuity.client.util.biome.BiomeHolder;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.jetbrains.annotations.ApiStatus;

@Contract(threading=ThreadingBehavior.UNSAFE)
public final class BiomeHolderManager {
    private static final Map<class_2960, BiomeHolder> HOLDER_CACHE = new Object2ObjectOpenHashMap();
    private static class_5455 registryManager;

    public static BiomeHolder getOrCreateHolder(class_2960 id) {
        BiomeHolder holder = HOLDER_CACHE.get(id);
        if (holder == null) {
            holder = new BiomeHolder(id);
            HOLDER_CACHE.put(id, holder);
        }
        return holder;
    }

    @ApiStatus.Internal
    public static void setup(class_5455 registryManager) {
        BiomeHolderManager.registryManager = registryManager;
        BiomeHolderManager.refreshHolders();
    }

    public static void refreshHolders() {
        if (registryManager == null) {
            return;
        }
        Object2ObjectOpenHashMap compressedIdMap = new Object2ObjectOpenHashMap();
        class_2378 biomeRegistry = registryManager.method_30530(class_2378.field_25114);
        for (class_2960 id : biomeRegistry.method_10235()) {
            class_2960 compressedId;
            String compressedPath;
            String path = id.method_12832();
            if (path.equals(compressedPath = path.replace("_", "")) || biomeRegistry.method_10250(compressedId = new class_2960(id.method_12836(), compressedPath))) continue;
            compressedIdMap.put(compressedId, id);
        }
        for (BiomeHolder holder : HOLDER_CACHE.values()) {
            holder.refresh((class_2378<class_1959>)biomeRegistry, (Map<class_2960, class_2960>)compressedIdMap);
        }
    }

    @ApiStatus.Internal
    public static void clearCache() {
        HOLDER_CACHE.clear();
    }
}

