/*
 * Decompiled with CFR 0.152.
 */
package win.baruna.blockmeter;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigManager;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_634;
import win.baruna.blockmeter.BlockMeter;
import win.baruna.blockmeter.ModConfig;
import win.baruna.blockmeter.gui.OptionsGui;
import win.baruna.blockmeter.gui.SelectBoxGui;
import win.baruna.blockmeter.measurebox.ClientMeasureBox;

public class BlockMeterClient
implements ClientModInitializer {
    private static BlockMeterClient instance;
    private static ConfigManager<ModConfig> confMgr;
    private boolean active = false;
    private class_1792 currentItem;
    private List<ClientMeasureBox> boxes = new ArrayList<ClientMeasureBox>();
    private Map<class_2561, List<ClientMeasureBox>> otherUsersBoxes = null;
    private OptionsGui quickMenu = new OptionsGui();
    private SelectBoxGui selectBoxGui = new SelectBoxGui();

    public static BlockMeterClient getInstance() {
        return instance;
    }

    public static ConfigManager<ModConfig> getConfigManager() {
        return confMgr;
    }

    public BlockMeterClient() {
        instance = this;
    }

    public void disable() {
        this.active = false;
        if (((ModConfig)BlockMeterClient.confMgr.getConfig()).deleteBoxesOnDisable) {
            this.clear();
        }
    }

    public void reset() {
        this.otherUsersBoxes = null;
        this.boxes.clear();
        ModConfig cfg = (ModConfig)confMgr.getConfig();
        if (cfg.incrementColor) {
            cfg.colorIndex = 0;
            confMgr.save();
        }
    }

    public boolean clear() {
        boolean hasBox = this.boxes.size() > 0;
        this.boxes.clear();
        this.sendBoxList();
        ModConfig cfg = (ModConfig)confMgr.getConfig();
        if (cfg.incrementColor) {
            cfg.colorIndex = 0;
            confMgr.save();
        }
        return hasBox;
    }

    public boolean undo() {
        if (this.boxes.size() == 0) {
            return false;
        }
        this.boxes.remove(this.boxes.size() - 1);
        this.sendBoxList();
        ModConfig cfg = (ModConfig)confMgr.getConfig();
        if (cfg.incrementColor) {
            cfg.colorIndex = Math.floorMod(cfg.colorIndex - 1, class_1767.values().length);
            confMgr.save();
        }
        return true;
    }

    public void renderOverlay(float partialTicks, class_4587 stack) {
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        class_2960 currentDimension = client.field_1724.field_6002.method_27983().method_29177();
        ModConfig cfg = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        client.field_1772.method_1729(stack, "XXX", -100.0f, -100.0f, 0);
        if (this.active || cfg.showBoxesWhenDisabled) {
            if (cfg.showOtherUsersBoxes) {
                if (this.otherUsersBoxes != null && this.otherUsersBoxes.size() > 0) {
                    this.otherUsersBoxes.forEach((playerText, boxList) -> boxList.forEach(box -> box.render(camera, stack, currentDimension, (class_2561)playerText)));
                    this.boxes.forEach(box -> {
                        if (!box.isFinished()) {
                            box.render(camera, stack, currentDimension);
                        }
                    });
                }
                if (!cfg.sendBoxes) {
                    this.boxes.forEach(box -> {
                        if (box.isFinished()) {
                            box.render(camera, stack, currentDimension, client.field_1724.method_5476());
                        } else {
                            box.render(camera, stack, currentDimension);
                        }
                    });
                }
            } else {
                this.boxes.forEach(box -> box.render(camera, stack, currentDimension));
            }
        }
    }

    public void onDisconnected() {
        this.reset();
    }

    public void onConnected() {
        ClientPlayNetworking.registerReceiver((class_2960)BlockMeter.S2CPacketIdentifier, this::handleServerBoxList);
        this.sendBoxList();
    }

    public ClientMeasureBox getCurrentBox() {
        return this.boxes.stream().filter(box -> !box.isFinished()).findAny().orElse(null);
    }

    public void onInitializeClient() {
        class_304 keyBinding = new class_304("key.blockmeter.assign", class_3675.class_307.field_1668, 77, "category.blockmeter.key");
        class_304 keyBindingMenu = new class_304("key.blockmeter.menu", class_3675.class_307.field_1668, 342, "category.blockmeter.key");
        KeyBindingHelper.registerKeyBinding((class_304)keyBinding);
        KeyBindingHelper.registerKeyBinding((class_304)keyBindingMenu);
        confMgr = (ConfigManager)AutoConfig.register(ModConfig.class, Toml4jConfigSerializer::new);
        ClientTickEvents.START_CLIENT_TICK.register(e -> {
            class_239 rayHit;
            ClientMeasureBox currentBox;
            if (keyBinding.method_1436()) {
                if (class_437.method_25442()) {
                    if (this.undo()) {
                        e.field_1724.method_7353((class_2561)new class_2588("blockmeter.clearLast"), true);
                    }
                } else if (class_437.method_25441()) {
                    if (this.clear()) {
                        e.field_1724.method_7353((class_2561)new class_2588("blockmeter.clearAll"), true);
                    }
                } else if (this.active) {
                    this.disable();
                    e.field_1724.method_7353((class_2561)new class_2588("blockmeter.toggle.off", new Object[0]), true);
                } else {
                    this.active = true;
                    class_1799 itemStack = e.field_1724.method_6047();
                    this.currentItem = itemStack.method_7909();
                    e.field_1724.method_7353((class_2561)new class_2588("blockmeter.toggle.on", new Object[]{new class_2588(itemStack.method_7922(), new Object[0])}), true);
                }
            }
            if (keyBindingMenu.method_1436() && this.active && class_310.method_1551().field_1724.method_6047().method_7909() == this.currentItem) {
                class_310.method_1551().method_1507((class_437)this.quickMenu);
            }
            if (this.active && this.boxes.size() > 0 && (currentBox = this.getCurrentBox()) != null && (rayHit = e.field_1724.method_5745((double)e.field_1761.method_2904(), 1.0f, false)).method_17783() == class_239.class_240.field_1332) {
                class_3965 blockHitResult = (class_3965)rayHit;
                currentBox.setBlockEnd(new class_2338((class_2382)blockHitResult.method_17777()));
            }
        });
        UseBlockCallback.EVENT.register((playerEntity, world, hand, hitResult) -> this.onBlockMeterClick(playerEntity, hitResult));
    }

    private class_1269 onBlockMeterClick(class_1657 playerEntity, class_3965 hitResult) {
        if (!this.active) {
            return class_1269.field_5811;
        }
        if (playerEntity.method_6047().method_7909().equals(this.currentItem)) {
            class_2338 block = hitResult.method_17777();
            ClientMeasureBox currentBox = this.getCurrentBox();
            if (currentBox == null) {
                if (class_437.method_25442()) {
                    ClientMeasureBox[] boxes = this.findBoxes(block);
                    switch (boxes.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            boxes[0].loosenCorner(block);
                            break;
                        }
                        default: {
                            this.selectBoxGui.setBoxes(boxes);
                            this.selectBoxGui.setBlock(block);
                            class_310.method_1551().method_1507((class_437)this.selectBoxGui);
                            break;
                        }
                    }
                } else {
                    ClientMeasureBox box = ClientMeasureBox.getBox(block, playerEntity.field_6002.method_27983().method_29177());
                    this.boxes.add(box);
                }
            } else {
                currentBox.setBlockEnd(block);
                currentBox.setFinished();
                this.sendBoxList();
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private ClientMeasureBox[] findBoxes(class_2338 block) {
        return (ClientMeasureBox[])this.boxes.stream().filter(box -> box.isCorner(block)).toArray(ClientMeasureBox[]::new);
    }

    private void sendBoxList() {
        if (!((ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig()).sendBoxes) {
            return;
        }
        class_2540 passedData = new class_2540(Unpooled.buffer());
        passedData.writeInt(this.boxes.size());
        for (int i = 0; i < this.boxes.size(); ++i) {
            this.boxes.get(i).writePacketBuf(passedData);
        }
        ClientPlayNetworking.send((class_2960)BlockMeter.C2SPacketIdentifier, (class_2540)passedData);
    }

    private void handleServerBoxList(class_310 client, class_634 handler, class_2540 data, PacketSender responseSender) {
        HashMap receivedBoxes = new HashMap();
        int playerCount = data.readInt();
        for (int i = 0; i < playerCount; ++i) {
            class_2561 playerName = data.method_10808();
            int boxCount = data.readInt();
            ArrayList<ClientMeasureBox> boxes = new ArrayList<ClientMeasureBox>(boxCount);
            for (int j = 0; j < boxCount; ++j) {
                boxes.add(ClientMeasureBox.fromPacketByteBuf(data));
            }
            receivedBoxes.put(playerName, boxes);
        }
        client.method_18859(() -> {
            this.otherUsersBoxes = receivedBoxes;
        });
    }
}

