/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.sun.jna.ptr.PointerByReference;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.opus4j.Opus;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;

public class OpusDecoder {
    protected PointerByReference opusDecoder;
    protected int sampleRate;
    protected int frameSize;
    protected int maxPayloadSize;

    private OpusDecoder(int sampleRate, int frameSize, int maxPayloadSize) {
        this.sampleRate = sampleRate;
        this.frameSize = frameSize;
        this.maxPayloadSize = maxPayloadSize;
        this.open();
    }

    public void open() {
        if (this.opusDecoder != null) {
            return;
        }
        IntBuffer error = IntBuffer.allocate(1);
        this.opusDecoder = Opus.INSTANCE.opus_decoder_create(this.sampleRate, 1, error);
        if (error.get() != 0 && this.opusDecoder == null) {
            throw new IllegalStateException("Opus decoder error " + error.get());
        }
        Voicechat.LOGGER.info("Initializing Opus decoder with sample rate " + this.sampleRate + " Hz, frame size " + this.frameSize + " bytes and max payload size " + this.maxPayloadSize + " bytes");
    }

    public short[] decode(@Nullable byte[] data) {
        if (this.isClosed()) {
            throw new IllegalStateException("Decoder is closed");
        }
        ShortBuffer decoded = ShortBuffer.allocate(4096);
        int result = data == null || data.length == 0 ? Opus.INSTANCE.opus_decode(this.opusDecoder, null, 0, decoded, this.frameSize, 0) : Opus.INSTANCE.opus_decode(this.opusDecoder, data, data.length, decoded, this.frameSize, 0);
        if (result < 0) {
            throw new RuntimeException("Failed to decode audio data");
        }
        short[] audio = new short[result];
        decoded.get(audio);
        return audio;
    }

    public boolean isClosed() {
        return this.opusDecoder == null;
    }

    public void close() {
        if (this.opusDecoder == null) {
            return;
        }
        Opus.INSTANCE.opus_decoder_destroy(this.opusDecoder);
        this.opusDecoder = null;
    }

    public void resetState() {
        if (this.isClosed()) {
            throw new IllegalStateException("Decoder is closed");
        }
        Opus.INSTANCE.opus_decoder_ctl(this.opusDecoder, 4028, new Object[0]);
    }

    @Nullable
    public static OpusDecoder createDecoder(int sampleRate, int frameSize, int maxPayloadSize) {
        return Utils.createSafe(() -> new OpusDecoder(sampleRate, frameSize, maxPayloadSize));
    }
}

