/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ALSpeaker;
import de.maxhenkel.voicechat.voice.client.AudioPacketBuffer;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.client.NativeDependencyException;
import de.maxhenkel.voicechat.voice.client.OpusDecoder;
import de.maxhenkel.voicechat.voice.common.GroupSoundPacket;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import org.apache.commons.lang3.tuple.Pair;

public class AudioChannel
extends Thread {
    private final class_310 minecraft;
    private final ClientVoicechat client;
    private final ClientVoicechatConnection clientConnection;
    private final UUID uuid;
    private final BlockingQueue<SoundPacket<?>> queue;
    private final AudioPacketBuffer packetBuffer;
    private long lastPacketTime;
    private ALSpeaker speaker;
    private boolean stopped;
    private final OpusDecoder decoder;
    private long lastSequenceNumber;

    public AudioChannel(ClientVoicechat client, ClientVoicechatConnection clientConnection, UUID uuid) throws NativeDependencyException {
        this.client = client;
        this.clientConnection = clientConnection;
        this.uuid = uuid;
        this.queue = new LinkedBlockingQueue();
        this.packetBuffer = new AudioPacketBuffer(VoicechatClient.CLIENT_CONFIG.audioPacketThreshold.get());
        this.lastPacketTime = System.currentTimeMillis();
        this.stopped = false;
        this.decoder = OpusDecoder.createDecoder(48000, 960, clientConnection.getData().getMtuSize());
        if (this.decoder == null) {
            throw new NativeDependencyException("Failed to load Opus decoder");
        }
        this.lastSequenceNumber = -1L;
        this.minecraft = class_310.method_1551();
        this.setDaemon(true);
        this.setName("AudioChannelThread-" + uuid.toString());
        Voicechat.LOGGER.info("Creating audio channel for " + uuid);
    }

    public boolean canKill() {
        return System.currentTimeMillis() - this.lastPacketTime > 30000L;
    }

    public void closeAndKill() {
        Voicechat.LOGGER.info("Closing audio channel for " + this.uuid);
        this.stopped = true;
        this.queue.clear();
        if (Thread.currentThread() == this) {
            return;
        }
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void addToQueue(SoundPacket<?> p) {
        this.queue.add(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.speaker = ClientCompatibilityManager.INSTANCE.createSpeaker(this.client.getSoundManager(), 48000, 960);
            this.speaker.open();
            while (!this.stopped) {
                if (ClientManager.getPlayerStateManager().isDisabled()) {
                    this.closeAndKill();
                    return;
                }
                SoundPacket<?> packet = this.packetBuffer.poll(this.queue);
                if (packet == null) continue;
                this.lastPacketTime = System.currentTimeMillis();
                if (this.lastSequenceNumber >= 0L && packet.getSequenceNumber() <= this.lastSequenceNumber || this.minecraft.field_1687 == null || this.minecraft.field_1724 == null) continue;
                this.speaker.checkBufferEmpty(this::flushRecordingSync);
                if (packet.getData().length == 0) {
                    this.lastSequenceNumber = -1L;
                    this.packetBuffer.clear();
                    this.speaker.runInContext(this::flushRecordingSync);
                    this.decoder.resetState();
                    continue;
                }
                if (this.lastSequenceNumber >= 0L) {
                    int packetsToCompensate = (int)(packet.getSequenceNumber() - (this.lastSequenceNumber + 1L));
                    if (packetsToCompensate > 0) {
                        Voicechat.LOGGER.debug("Compensating {}/{} packets ", (Object)(packetsToCompensate >= 4 ? 0 : packetsToCompensate), (Object)packetsToCompensate);
                    }
                    if (packetsToCompensate <= 4) {
                        for (int i = 0; i < packetsToCompensate; ++i) {
                            this.writeToSpeaker(packet, this.decoder.decode(null));
                        }
                    }
                }
                this.lastSequenceNumber = packet.getSequenceNumber();
                short[] decodedAudio = this.decoder.decode(packet.getData());
                this.writeToSpeaker(packet, decodedAudio);
            }
        }
        catch (InterruptedException packet) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (this.speaker != null) {
                this.speaker.runInContext(this::flushRecordingSync);
                this.speaker.close();
            }
            this.decoder.close();
            Voicechat.LOGGER.info("Closed audio channel for " + this.uuid);
        }
    }

    private void flushRecordingSync() {
        AudioRecorder recorder = this.client.getRecorder();
        if (recorder == null) {
            return;
        }
        recorder.writeChunkThreaded(this.uuid);
    }

    private void writeToSpeaker(Packet<?> packet, short[] monoData) {
        class_1657 player = this.minecraft.field_1687.method_18470(this.uuid);
        float volume = VoicechatClient.CLIENT_CONFIG.voiceChatVolume.get().floatValue() * (float)VoicechatClient.VOLUME_CONFIG.getVolume(this.uuid);
        boolean stereo = VoicechatClient.CLIENT_CONFIG.stereo.get();
        if (packet instanceof GroupSoundPacket) {
            this.speaker.write(monoData, volume, null);
            this.client.getTalkCache().updateTalking(this.uuid, false);
            this.appendRecording(player, () -> Utils.convertToStereo(monoData, 1.0f, 1.0f));
        } else if (packet instanceof PlayerSoundPacket) {
            PlayerSoundPacket soundPacket = (PlayerSoundPacket)packet;
            if (player == null) {
                return;
            }
            if (player == this.minecraft.field_1719) {
                this.speaker.write(monoData, volume, null);
                this.client.getTalkCache().updateTalking(this.uuid, soundPacket.isWhispering());
                this.appendRecording(player, () -> Utils.convertToStereo(monoData, 1.0f, 1.0f));
                return;
            }
            class_243 pos = player.method_33571();
            float crouchMultiplayer = player.method_18276() ? (float)this.clientConnection.getData().getCrouchDistanceMultiplier() : 1.0f;
            float whisperMultiplayer = soundPacket.isWhispering() ? (float)this.clientConnection.getData().getWhisperDistanceMultiplier() : 1.0f;
            float multiplier = crouchMultiplayer * whisperMultiplayer;
            float outputVolume = volume * this.getDistanceVolume(pos, multiplier);
            this.speaker.write(monoData, outputVolume, (class_243)(stereo ? pos : null));
            if (outputVolume >= 0.01f) {
                this.client.getTalkCache().updateTalking(this.uuid, soundPacket.isWhispering());
            }
            this.appendRecording(player, () -> this.convertLocationalPacketToStereo(pos, monoData, multiplier));
        } else if (packet instanceof LocationSoundPacket) {
            LocationSoundPacket p = (LocationSoundPacket)packet;
            this.speaker.write(monoData, volume * this.getDistanceVolume(p.getLocation()), stereo ? p.getLocation() : null);
            this.client.getTalkCache().updateTalking(this.uuid, false);
            this.appendRecording(player, () -> this.convertLocationalPacketToStereo(p.getLocation(), monoData));
        }
    }

    private short[] convertLocationalPacketToStereo(class_243 pos, short[] monoData) {
        return this.convertLocationalPacketToStereo(pos, monoData, 1.0f);
    }

    private short[] convertLocationalPacketToStereo(class_243 pos, short[] monoData, float distanceMultiplier) {
        float distanceVolume = this.getDistanceVolume(pos, distanceMultiplier);
        if (VoicechatClient.CLIENT_CONFIG.stereo.get().booleanValue()) {
            Pair<Float, Float> stereoVolume = Utils.getStereoVolume(this.minecraft, pos, this.clientConnection.getData().getVoiceChatDistance() * (double)distanceMultiplier);
            return Utils.convertToStereo(monoData, distanceVolume * ((Float)stereoVolume.getLeft()).floatValue(), distanceVolume * ((Float)stereoVolume.getRight()).floatValue());
        }
        return Utils.convertToStereo(monoData, distanceVolume, distanceVolume);
    }

    private float getDistanceVolume(class_243 pos) {
        return this.getDistanceVolume(pos, 1.0f);
    }

    private float getDistanceVolume(class_243 pos, float distanceMultiplier) {
        float distance = (float)pos.method_1022(this.minecraft.field_1719.method_33571());
        float fadeDistance = (float)this.clientConnection.getData().getVoiceChatFadeDistance() * distanceMultiplier;
        float maxDistance = (float)this.clientConnection.getData().getVoiceChatDistance() * distanceMultiplier;
        if (distance < fadeDistance) {
            return 1.0f;
        }
        if (distance > maxDistance) {
            return 0.0f;
        }
        float percentage = (distance - fadeDistance) / (maxDistance - fadeDistance);
        return 1.0f / (1.0f + (float)Math.exp(percentage * 12.0f - 6.0f));
    }

    private void appendRecording(class_1657 player, Supplier<short[]> stereo) {
        this.speaker.runInContext(() -> {
            if (this.client.getRecorder() != null) {
                try {
                    this.client.getRecorder().appendChunk(player != null ? player.method_7334() : null, System.currentTimeMillis(), (short[])stereo.get());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public boolean isClosed() {
        return this.stopped;
    }
}

