/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ALSpeaker;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.MicThread;
import de.maxhenkel.voicechat.voice.client.MicrophoneException;
import de.maxhenkel.voicechat.voice.client.NativeDependencyException;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.SpeakerException;
import de.maxhenkel.voicechat.voice.common.Utils;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4264;
import net.minecraft.class_4587;
import net.minecraft.class_6382;

public class MicTestButton
extends class_4264 {
    private boolean micActive;
    @Nullable
    private VoiceThread voiceThread;
    private final MicListener micListener;
    @Nullable
    private final ClientVoicechat client;

    public MicTestButton(int xIn, int yIn, int widthIn, int heightIn, MicListener micListener) {
        super(xIn, yIn, widthIn, heightIn, class_2585.field_24366);
        this.micListener = micListener;
        this.client = ClientManager.getClient();
        this.updateText();
    }

    private void updateText() {
        if (!this.field_22764) {
            this.method_25355((class_2561)new class_2588("message.voicechat.mic_test_unavailable"));
            return;
        }
        if (this.micActive) {
            this.method_25355((class_2561)new class_2588("message.voicechat.mic_test_on"));
        } else {
            this.method_25355((class_2561)new class_2588("message.voicechat.mic_test_off"));
        }
    }

    public void method_25394(class_4587 matrixStack, int x, int y, float partialTicks) {
        super.method_25394(matrixStack, x, y, partialTicks);
        if (this.voiceThread != null) {
            this.voiceThread.updateLastRender();
        }
    }

    public void setMicActive(boolean micActive) {
        this.micActive = micActive;
        this.updateText();
    }

    public void method_25306() {
        this.setMicActive(!this.micActive);
        this.updateText();
        if (this.micActive) {
            if (this.voiceThread != null) {
                this.voiceThread.close();
                this.voiceThread = null;
            }
            try {
                this.voiceThread = new VoiceThread();
                this.voiceThread.start();
            }
            catch (Exception e) {
                this.setMicActive(false);
                this.field_22763 = false;
                e.printStackTrace();
            }
        } else if (this.voiceThread != null) {
            this.voiceThread.close();
            this.voiceThread = null;
        }
    }

    public void method_37020(class_6382 narrationElementOutput) {
        this.method_37021(narrationElementOutput);
    }

    public static interface MicListener {
        public void onMicValue(double var1);
    }

    private class VoiceThread
    extends Thread {
        private final ALSpeaker speaker;
        private boolean running = true;
        private long lastRender;
        private MicThread micThread;
        private boolean usesOwnMicThread;
        @Nullable
        private SoundManager ownSoundManager;

        public VoiceThread() throws SpeakerException, MicrophoneException, NativeDependencyException {
            SoundManager soundManager;
            this.setDaemon(true);
            this.setName("VoiceTestingThread");
            MicThread micThread = this.micThread = MicTestButton.this.client != null ? MicTestButton.this.client.getMicThread() : null;
            if (this.micThread == null) {
                this.micThread = new MicThread(MicTestButton.this.client, null);
                this.usesOwnMicThread = true;
            }
            if (MicTestButton.this.client == null) {
                this.ownSoundManager = soundManager = ClientCompatibilityManager.INSTANCE.createSoundManager(VoicechatClient.CLIENT_CONFIG.speaker.get());
            } else {
                soundManager = MicTestButton.this.client.getSoundManager();
            }
            this.speaker = ClientCompatibilityManager.INSTANCE.createSpeaker(soundManager, 48000, 960);
            this.speaker.open();
            this.updateLastRender();
            this.setMicLocked(true);
        }

        @Override
        public void run() {
            while (this.running && System.currentTimeMillis() - this.lastRender <= 500L) {
                short[] buff = this.micThread.pollMic();
                if (buff == null) continue;
                MicTestButton.this.micListener.onMicValue(Utils.dbToPerc(Utils.getHighestAudioLevel(buff)));
                this.speaker.write(buff, VoicechatClient.CLIENT_CONFIG.voiceChatVolume.get().floatValue(), null);
            }
            this.speaker.close();
            this.setMicLocked(false);
            MicTestButton.this.micListener.onMicValue(0.0);
            if (this.usesOwnMicThread) {
                this.micThread.close();
            }
            if (this.ownSoundManager != null) {
                this.ownSoundManager.close();
            }
            Voicechat.LOGGER.info("Mic test audio channel closed");
        }

        public void updateLastRender() {
            this.lastRender = System.currentTimeMillis();
        }

        private void setMicLocked(boolean locked) {
            this.micThread.setMicrophoneLocked(locked);
        }

        public void close() {
            if (!this.running) {
                return;
            }
            Voicechat.LOGGER.info("Stopping mic test audio channel");
            this.running = false;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

