/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline;

import java.util.List;
import java.util.Random;
import me.jellysquid.mods.sodium.client.model.IndexBufferBuilder;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadColorProvider;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadWinding;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.rand.XoRoShiRoRandom;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorsExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_777;

public class BlockRenderer {
    private final Random random = new XoRoShiRoRandom();
    private final BlockColorsExtended blockColors;
    private final BlockOcclusionCache occlusionCache;
    private final QuadLightData cachedQuadLightData = new QuadLightData();
    private final BiomeColorBlender biomeColorBlender;
    private final LightPipelineProvider lighters;
    private final boolean useAmbientOcclusion;

    public BlockRenderer(class_310 client, LightPipelineProvider lighters, BiomeColorBlender biomeColorBlender) {
        this.blockColors = (BlockColorsExtended)client.method_1505();
        this.biomeColorBlender = biomeColorBlender;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = class_310.method_1588();
    }

    public boolean renderModel(class_1920 world, class_2680 state, class_2338 pos, class_2338 origin, class_1087 model, ChunkModelBuilder buffers, boolean cull, long seed) {
        LightPipeline lighter = this.lighters.getLighter(this.getLightingMode(state, model));
        class_243 offset = state.method_26226((class_1922)world, pos);
        boolean rendered = false;
        for (class_2350 dir : DirectionUtil.ALL_DIRECTIONS) {
            this.random.setSeed(seed);
            List sided = model.method_4707(state, dir, this.random);
            if (sided.isEmpty() || cull && !this.occlusionCache.shouldDrawSide(state, (class_1922)world, pos, dir)) continue;
            this.renderQuadList(world, state, pos, origin, lighter, offset, buffers, sided, ModelQuadFacing.fromDirection(dir));
            rendered = true;
        }
        this.random.setSeed(seed);
        List all = model.method_4707(state, null, this.random);
        if (!all.isEmpty()) {
            this.renderQuadList(world, state, pos, origin, lighter, offset, buffers, all, ModelQuadFacing.UNASSIGNED);
            rendered = true;
        }
        return rendered;
    }

    private void renderQuadList(class_1920 world, class_2680 state, class_2338 pos, class_2338 origin, LightPipeline lighter, class_243 offset, ChunkModelBuilder buffers, List<class_777> quads, ModelQuadFacing facing) {
        ModelQuadColorProvider<class_2680> colorizer = null;
        ModelVertexSink vertices = buffers.getVertexSink();
        vertices.ensureCapacity(quads.size() * 4);
        IndexBufferBuilder indices = buffers.getIndexBufferBuilder(facing);
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            class_777 quad = quads.get(i);
            QuadLightData light = this.cachedQuadLightData;
            lighter.calculate((ModelQuadView)quad, pos, light, quad.method_3358(), quad.method_24874());
            if (quad.method_3360() && colorizer == null) {
                colorizer = this.blockColors.getColorProvider(state);
            }
            this.renderQuad(world, state, pos, origin, vertices, indices, offset, colorizer, quad, light, buffers);
        }
        vertices.flush();
    }

    private void renderQuad(class_1920 world, class_2680 state, class_2338 pos, class_2338 origin, ModelVertexSink vertices, IndexBufferBuilder indices, class_243 blockOffset, ModelQuadColorProvider<class_2680> colorProvider, class_777 bakedQuad, QuadLightData light, ChunkModelBuilder model) {
        ModelQuadView src = (ModelQuadView)bakedQuad;
        ModelQuadOrientation orientation = ModelQuadOrientation.orientByBrightness(light.br);
        int[] colors = null;
        if (bakedQuad.method_3360()) {
            colors = this.biomeColorBlender.getColors(world, pos, src, colorProvider, state);
        }
        int vertexStart = vertices.getVertexCount();
        for (int i = 0; i < 4; ++i) {
            int j = orientation.getVertexIndex(i);
            float x = src.getX(j) + (float)blockOffset.method_10216();
            float y = src.getY(j) + (float)blockOffset.method_10214();
            float z = src.getZ(j) + (float)blockOffset.method_10215();
            int color = ColorABGR.mul(colors != null ? colors[j] : -1, light.br[j]);
            float u = src.getTexU(j);
            float v = src.getTexV(j);
            int lm = light.lm[j];
            vertices.writeVertex((class_2382)origin, x, y, z, color, u, v, lm, model.getChunkId());
        }
        indices.add(vertexStart, ModelQuadWinding.CLOCKWISE);
        class_1058 sprite = src.getSprite();
        if (sprite != null) {
            model.addSprite(sprite);
        }
    }

    private LightMode getLightingMode(class_2680 state, class_1087 model) {
        if (this.useAmbientOcclusion && model.method_4708() && state.method_26213() == 0) {
            return LightMode.SMOOTH;
        }
        return LightMode.FLAT;
    }
}

