/*
 * Decompiled with CFR 0.152.
 */
package dev.sapphic.couplings;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.base.Preconditions;
import dev.sapphic.couplings.CouplingsClient;
import dev.sapphic.couplings.CouplingsPlayer;
import io.netty.buffer.Unpooled;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;

public final class Couplings
implements ModInitializer {
    public static final int COUPLING_DISTANCE = 64;
    public static final int COUPLING_SIGNAL = 8;
    static final class_2960 CLIENT_CONFIG = new class_2960("couplings", "client_config");
    static final class_2960 SERVER_CONFIG = new class_2960("couplings", "server_config");
    static final boolean IGNORE_SNEAKING;
    static final boolean COUPLE_DOORS;
    static final boolean COUPLE_FENCE_GATES;
    static final boolean COUPLE_TRAPDOORS;

    public static boolean ignoresSneaking(class_1657 player) {
        if (player instanceof CouplingsPlayer) {
            return CouplingsPlayer.ignoresSneaking(player);
        }
        return IGNORE_SNEAKING;
    }

    public static boolean couplesDoors(class_1937 level) {
        return level.method_8608() ? CouplingsClient.serverCouplesDoors() : COUPLE_DOORS;
    }

    public static boolean couplesFenceGates(class_1937 level) {
        return level.method_8608() ? CouplingsClient.serverCouplesFenceGates() : COUPLE_FENCE_GATES;
    }

    public static boolean couplesTrapdoors(class_1937 level) {
        return level.method_8608() ? CouplingsClient.serverCouplesTrapdoors() : COUPLE_TRAPDOORS;
    }

    public void onInitialize() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CLIENT_CONFIG, (server, player, listener, buf, sender) -> {
            Preconditions.checkArgument((buf.readableBytes() == 1 ? 1 : 0) != 0, (Object)buf);
            byte clientConfig = buf.readByte();
            Preconditions.checkArgument((clientConfig <= 1 ? 1 : 0) != 0, (Object)buf);
            server.execute(() -> CouplingsPlayer.ignoresSneaking((class_1657)player, clientConfig != 0));
        });
        ServerPlayConnectionEvents.JOIN.register((listener, sender, server) -> {
            int couplings = 0;
            couplings |= (COUPLE_DOORS ? 1 : 0) << 2;
            couplings |= (COUPLE_FENCE_GATES ? 1 : 0) << 1;
            ServerPlayNetworking.send((class_3222)listener.field_14140, (class_2960)SERVER_CONFIG, (class_2540)new class_2540(Unpooled.buffer((int)1, (int)1).writeByte(couplings |= COUPLE_TRAPDOORS ? 1 : 0).asReadOnly()));
        });
    }

    static {
        CommentedFileConfig config = CommentedFileConfig.of((Path)FabricLoader.getInstance().getConfigDir().resolve("couplings.toml"));
        config.load();
        String ignoreSneaking = "ignore_sneaking";
        String coupleDoors = "couple_doors";
        String coupleFenceGates = "couple_fence_gates";
        String coupleTrapdoors = "couple_trapdoors";
        ConfigSpec spec = new ConfigSpec();
        spec.define("ignore_sneaking", (Object)true);
        spec.define("couple_doors", (Object)true);
        spec.define("couple_fence_gates", (Object)true);
        spec.define("couple_trapdoors", (Object)true);
        spec.correct((Config)config);
        config.setComment("ignore_sneaking", "Couple regardless of whether the player is sneaking when interacting");
        config.setComment("couple_doors", "Couple neighboring doors with opposing hinges");
        config.setComment("couple_fence_gates", "Couple neighboring fence gates above and below on the same axis");
        config.setComment("couple_trapdoors", "Couple neighboring trapdoors along either sides and opposing");
        config.save();
        IGNORE_SNEAKING = (Boolean)config.get("ignore_sneaking");
        COUPLE_DOORS = (Boolean)config.get("couple_doors");
        COUPLE_FENCE_GATES = (Boolean)config.get("couple_fence_gates");
        COUPLE_TRAPDOORS = (Boolean)config.get("couple_trapdoors");
        if (!(COUPLE_DOORS && COUPLE_FENCE_GATES && COUPLE_TRAPDOORS)) {
            LogManager.getLogger().warn("No features are enabled, this could be a bug!");
        }
    }
}

