/*
 * Decompiled with CFR 0.152.
 */
package safro.oxidized.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2248;
import org.jetbrains.annotations.Nullable;
import safro.oxidized.registry.BlockRegistry;

public class CopperStateMap {
    private static final Map<class_2248, class_2248> INCREASES = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> DECREASES = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> WAXED = new HashMap<class_2248, class_2248>();
    private static final Map<class_2248, class_2248> UNWAXED = new HashMap<class_2248, class_2248>();

    public static void put(class_2248 block, @Nullable class_2248 oxidized, class_2248 waxed) {
        if (oxidized != null) {
            INCREASES.put(block, oxidized);
            DECREASES.put(oxidized, block);
        }
        WAXED.put(block, waxed);
        UNWAXED.put(waxed, block);
    }

    public static Optional<class_2248> getIncrease(class_2248 block) {
        return Optional.ofNullable(INCREASES.get(block));
    }

    public static Optional<class_2248> getDecrease(class_2248 block) {
        return Optional.ofNullable(DECREASES.get(block));
    }

    public static Optional<class_2248> getWaxed(class_2248 block) {
        return Optional.ofNullable(WAXED.get(block));
    }

    public static Optional<class_2248> getUnwaxed(class_2248 block) {
        return Optional.ofNullable(UNWAXED.get(block));
    }

    public static class_2248 getOriginalStage(class_2248 block) {
        class_2248 result = block;
        Optional<class_2248> b = CopperStateMap.getDecrease(block);
        while (b.isPresent()) {
            result = b.get();
            b = CopperStateMap.getDecrease(b.get());
        }
        return result;
    }

    static {
        CopperStateMap.put(BlockRegistry.VERTICAL_CUT_COPPER, BlockRegistry.VERTICAL_EXPOSED_CUT_COPPER, BlockRegistry.WAXED_VERTICAL_CUT_COPPER);
        CopperStateMap.put(BlockRegistry.VERTICAL_EXPOSED_CUT_COPPER, BlockRegistry.VERTICAL_WEATHERED_CUT_COPPER, BlockRegistry.WAXED_VERTICAL_EXPOSED_CUT_COPPER);
        CopperStateMap.put(BlockRegistry.VERTICAL_WEATHERED_CUT_COPPER, BlockRegistry.VERTICAL_OXIDIZED_CUT_COPPER, BlockRegistry.WAXED_VERTICAL_WEATHERED_CUT_COPPER);
        CopperStateMap.put(BlockRegistry.VERTICAL_OXIDIZED_CUT_COPPER, null, BlockRegistry.WAXED_VERTICAL_OXIDIZED_CUT_COPPER);
    }
}

