/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import java.nio.file.Path;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.shader.StandardMacros;
import org.anarres.cpp.DefaultPreprocessorListener;
import org.anarres.cpp.Feature;
import org.anarres.cpp.Preprocessor;
import org.anarres.cpp.PreprocessorListener;
import org.anarres.cpp.Source;
import org.anarres.cpp.StringLexerSource;
import org.anarres.cpp.Token;

public class PropertiesPreprocessor {
    public static String process(Path rootPath, Path shaderPath, String source) {
        source = "#define MC_VERSION " + StandardMacros.getMcVersion() + "\n" + source;
        return PropertiesPreprocessor.preprocessSource(source);
    }

    public static String preprocessSource(String source) {
        Preprocessor pp = new Preprocessor();
        pp.setListener((PreprocessorListener)new DefaultPreprocessorListener());
        pp.addInput((Source)new StringLexerSource(source, true));
        pp.addFeature(Feature.KEEPCOMMENTS);
        StringBuilder builder = new StringBuilder();
        try {
            Token tok;
            while ((tok = pp.token()) != null && tok.getType() != 265) {
                builder.append(tok.getText());
            }
        }
        catch (Exception e) {
            Iris.logger.error("Properties pre-processing failed", (Throwable)e);
        }
        builder.append("\n");
        source = builder.toString();
        return source;
    }
}

