/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Set;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.DirectiveHolder;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ShaderProperties;

public class PackDirectives {
    private int noiseTextureResolution = 256;
    private float sunPathRotation = 0.0f;
    private float ambientOcclusionLevel = 1.0f;
    private boolean areCloudsEnabled;
    private boolean separateAo;
    private boolean oldLighting;
    private Object2ObjectMap<String, Object2BooleanMap<String>> explicitFlips = new Object2ObjectOpenHashMap();
    private final PackRenderTargetDirectives renderTargetDirectives;
    private final PackShadowDirectives shadowDirectives;

    private PackDirectives(Set<Integer> supportedRenderTargets) {
        this.renderTargetDirectives = new PackRenderTargetDirectives(supportedRenderTargets);
        this.shadowDirectives = new PackShadowDirectives();
    }

    PackDirectives(Set<Integer> supportedRenderTargets, ShaderProperties properties) {
        this(supportedRenderTargets);
        this.areCloudsEnabled = properties.areCloudsEnabled();
        this.separateAo = properties.getSeparateAo().orElse(false);
        this.oldLighting = properties.getOldLighting().orElse(false);
        this.explicitFlips = properties.getExplicitFlips();
    }

    PackDirectives(Set<Integer> supportedRenderTargets, PackDirectives directives) {
        this(supportedRenderTargets);
        this.areCloudsEnabled = directives.areCloudsEnabled();
        this.separateAo = directives.separateAo;
        this.oldLighting = directives.oldLighting;
        this.explicitFlips = directives.explicitFlips;
    }

    public int getNoiseTextureResolution() {
        return this.noiseTextureResolution;
    }

    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    public float getAmbientOcclusionLevel() {
        return this.ambientOcclusionLevel;
    }

    public boolean areCloudsEnabled() {
        return this.areCloudsEnabled;
    }

    public boolean shouldUseSeparateAo() {
        return this.separateAo;
    }

    public boolean isOldLighting() {
        return this.oldLighting;
    }

    public PackRenderTargetDirectives getRenderTargetDirectives() {
        return this.renderTargetDirectives;
    }

    public PackShadowDirectives getShadowDirectives() {
        return this.shadowDirectives;
    }

    public void acceptDirectivesFrom(DirectiveHolder directives) {
        this.renderTargetDirectives.acceptDirectives(directives);
        this.shadowDirectives.acceptDirectives(directives);
        directives.acceptConstIntDirective("noiseTextureResolution", noiseTextureResolution -> {
            this.noiseTextureResolution = noiseTextureResolution;
        });
        directives.acceptConstFloatDirective("sunPathRotation", sunPathRotation -> {
            this.sunPathRotation = sunPathRotation;
        });
        directives.acceptConstFloatDirective("ambientOcclusionLevel", ambientOcclusionLevel -> {
            this.ambientOcclusionLevel = ambientOcclusionLevel;
        });
    }

    public ImmutableMap<Integer, Boolean> getExplicitFlips(String pass) {
        ImmutableMap.Builder explicitFlips = ImmutableMap.builder();
        Object2BooleanMap explicitFlipsStr = (Object2BooleanMap)this.explicitFlips.get((Object)pass);
        if (explicitFlipsStr == null) {
            explicitFlipsStr = Object2BooleanMaps.emptyMap();
        }
        explicitFlipsStr.forEach((buffer, shouldFlip) -> {
            int index = PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.indexOf(buffer);
            if (index == -1 && buffer.startsWith("colortex")) {
                String id = buffer.substring("colortex".length());
                try {
                    index = Integer.parseInt(id);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (index != -1) {
                explicitFlips.put((Object)index, shouldFlip);
            } else {
                Iris.logger.warn("Unknown buffer with ID " + buffer + " specified in flip directive for pass " + pass);
            }
        });
        return explicitFlips.build();
    }
}

