/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.samplers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shadows.ShadowMapRenderer;
import net.coderbot.iris.texunits.TextureUnit;
import net.minecraft.class_1044;

public class IrisSamplers {
    public static final ImmutableSet<Integer> WORLD_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)TextureUnit.TERRAIN.getSamplerId(), (Object)TextureUnit.LIGHTMAP.getSamplerId(), (Object)TextureUnit.OVERLAY.getSamplerId());
    public static final ImmutableSet<Integer> COMPOSITE_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)TextureUnit.LIGHTMAP.getSamplerId(), (Object)TextureUnit.OVERLAY.getSamplerId());

    private IrisSamplers() {
    }

    public static void addRenderTargetSamplers(SamplerHolder samplers, Supplier<ImmutableSet<Integer>> flipped, RenderTargets renderTargets, boolean isFullscreenPass) {
        int startIndex;
        for (int i = startIndex = isFullscreenPass ? 0 : 4; i < renderTargets.getRenderTargetCount(); ++i) {
            int index = i;
            IntSupplier sampler = () -> {
                ImmutableSet flippedBuffers = (ImmutableSet)flipped.get();
                RenderTarget target = renderTargets.get(index);
                if (flippedBuffers.contains((Object)index)) {
                    return target.getAltTexture();
                }
                return target.getMainTexture();
            };
            String name = "colortex" + i;
            if (i < PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.size()) {
                String legacyName = (String)PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.get(i);
                if (i == 0 && isFullscreenPass) {
                    samplers.addDefaultSampler(sampler, name, legacyName);
                    continue;
                }
                samplers.addDynamicSampler(sampler, name, legacyName);
                continue;
            }
            samplers.addDynamicSampler(sampler, name);
        }
    }

    public static void addNoiseSampler(SamplerHolder samplers, IntSupplier sampler) {
        samplers.addDynamicSampler(sampler, "noisetex");
    }

    public static boolean hasShadowSamplers(SamplerHolder samplers) {
        ImmutableList shadowSamplers = ImmutableList.of((Object)"shadowtex0", (Object)"shadowtex1", (Object)"shadow", (Object)"watershadow", (Object)"shadowcolor", (Object)"shadowcolor0", (Object)"shadowcolor1");
        for (String samplerName : shadowSamplers) {
            if (!samplers.hasSampler(samplerName)) continue;
            return true;
        }
        return false;
    }

    public static boolean addShadowSamplers(SamplerHolder samplers, ShadowMapRenderer shadowMapRenderer) {
        boolean usesShadows;
        boolean waterShadowEnabled = samplers.hasSampler("watershadow");
        if (waterShadowEnabled) {
            usesShadows = true;
            samplers.addDynamicSampler(shadowMapRenderer::getDepthTextureId, "shadowtex0", "watershadow");
            samplers.addDynamicSampler(shadowMapRenderer::getDepthTextureNoTranslucentsId, "shadowtex1", "shadow");
        } else {
            usesShadows = samplers.addDynamicSampler(shadowMapRenderer::getDepthTextureId, "shadowtex0", "shadow");
            usesShadows |= samplers.addDynamicSampler(shadowMapRenderer::getDepthTextureNoTranslucentsId, "shadowtex1");
        }
        samplers.addDynamicSampler(shadowMapRenderer::getColorTexture0Id, "shadowcolor", "shadowcolor0");
        samplers.addDynamicSampler(shadowMapRenderer::getColorTexture1Id, "shadowcolor1");
        return usesShadows;
    }

    public static void addLevelSamplers(SamplerHolder samplers, class_1044 normals, class_1044 specular) {
        samplers.addExternalSampler(TextureUnit.TERRAIN.getSamplerId(), "tex", "texture", "gtexture");
        samplers.addExternalSampler(TextureUnit.LIGHTMAP.getSamplerId(), "lightmap");
        samplers.addDynamicSampler(() -> ((class_1044)normals).method_4624(), "normals");
        samplers.addDynamicSampler(() -> ((class_1044)specular).method_4624(), "specular");
    }

    public static void addWorldDepthSamplers(SamplerHolder samplers, RenderTargets renderTargets) {
        samplers.addDynamicSampler(renderTargets.getDepthTexture()::getTextureId, "depthtex0");
        samplers.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
    }

    public static void addCompositeSamplers(SamplerHolder samplers, RenderTargets renderTargets) {
        samplers.addDynamicSampler(renderTargets.getDepthTexture()::getTextureId, "gdepthtex", "depthtex0");
        samplers.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
        samplers.addDynamicSampler(renderTargets.getDepthTextureNoHand()::getTextureId, "depthtex2");
    }
}

