/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import java.io.IOException;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.minecraft.class_284;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;

public class ExtendedShader
extends class_5944
implements SamplerHolder {
    NewWorldRenderingPipeline parent;
    ProgramUniforms uniforms;
    GlFramebuffer writingToBeforeTranslucent;
    GlFramebuffer writingToAfterTranslucent;
    GlFramebuffer baseline;
    BlendModeOverride blendModeOverride;
    HashMap<String, IntSupplier> dynamicSamplers;
    private final boolean intensitySwizzle;

    public ExtendedShader(class_5912 resourceFactory, String string, class_293 vertexFormat, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, GlFramebuffer baseline, BlendModeOverride blendModeOverride, Consumer<DynamicUniformHolder> uniformCreator, NewWorldRenderingPipeline parent) throws IOException {
        super(resourceFactory, string, vertexFormat);
        int programId = this.method_1270();
        ProgramUniforms.Builder uniformBuilder = ProgramUniforms.builder(string, programId);
        uniformCreator.accept(uniformBuilder);
        this.uniforms = uniformBuilder.buildUniforms();
        this.writingToBeforeTranslucent = writingToBeforeTranslucent;
        this.writingToAfterTranslucent = writingToAfterTranslucent;
        this.baseline = baseline;
        this.blendModeOverride = blendModeOverride;
        this.dynamicSamplers = new HashMap();
        this.parent = parent;
        this.intensitySwizzle = this.method_35787().contains("intensity");
    }

    public boolean isIntensitySwizzle() {
        return this.intensitySwizzle;
    }

    public void method_34585() {
        ProgramUniforms.clearActiveUniforms();
        super.method_34585();
        if (this.blendModeOverride != null) {
            BlendModeOverride.restore();
        }
        class_310.method_1551().method_1522().method_1235(false);
    }

    public void method_34586() {
        this.dynamicSamplers.forEach((name, supplier) -> this.addIrisSampler((String)name, supplier.getAsInt()));
        super.method_34586();
        this.uniforms.update();
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        if (this.parent.isBeforeTranslucent) {
            this.writingToBeforeTranslucent.bind();
        } else {
            this.writingToAfterTranslucent.bind();
        }
    }

    public void addIrisSampler(String name, int id) {
        super.method_34583(name, (Object)id);
    }

    public void addIrisSampler(String name, IntSupplier supplier) {
        this.dynamicSamplers.put(name, supplier);
    }

    public void method_34583(String name, Object sampler) {
        if (name.equals("Sampler0")) {
            name = "gtexture";
            super.method_34583("texture", sampler);
            super.method_34583("tex", sampler);
        } else if (name.equals("Sampler2")) {
            name = "lightmap";
        } else {
            if (name.startsWith("Sampler")) {
                return;
            }
            Iris.logger.warn("Iris: didn't recognize the sampler name " + name + " in addSampler, please use addIrisSampler for custom Iris-specific samplers instead.");
            return;
        }
        super.method_34583(name, sampler);
    }

    @Nullable
    public class_284 method_34582(String name) {
        return super.method_34582("iris_" + name);
    }

    @Override
    public void addExternalSampler(int textureUnit, String ... names) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public boolean hasSampler(String name) {
        return GL20C.glGetUniformLocation((int)this.method_1270(), (CharSequence)name) != -1;
    }

    @Override
    public boolean addDefaultSampler(IntSupplier sampler, String ... names) {
        throw new UnsupportedOperationException("addDefaultSampler is not yet implemented");
    }

    @Override
    public boolean addDynamicSampler(IntSupplier sampler, String ... names) {
        boolean used = false;
        for (String name : names) {
            if (this.hasSampler(name)) {
                used = true;
            }
            this.addIrisSampler(name, sampler);
        }
        return used;
    }
}

