/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.layer.GbufferProgram;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.pipeline.ClearPassCreator;
import net.coderbot.iris.pipeline.CustomTextureManager;
import net.coderbot.iris.pipeline.HandRenderer;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.CompositeRenderer;
import net.coderbot.iris.postprocess.FinalPassRenderer;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.EmptyShadowMapRenderer;
import net.coderbot.iris.shadows.ShadowMapRenderer;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.class_1044;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;

public class DeferredWorldRenderingPipeline
implements WorldRenderingPipeline {
    private final RenderTargets renderTargets;
    private final List<Pass> allPasses;
    @Nullable
    private final Pass basic;
    @Nullable
    private final Pass textured;
    @Nullable
    private final Pass texturedLit;
    @Nullable
    private final Pass skyBasic;
    @Nullable
    private final Pass skyTextured;
    @Nullable
    private final Pass clouds;
    @Nullable
    private final Pass terrain;
    @Nullable
    private final Pass translucent;
    @Nullable
    private final Pass damagedBlock;
    @Nullable
    private final Pass weather;
    @Nullable
    private final Pass beaconBeam;
    @Nullable
    private final Pass entities;
    @Nullable
    private final Pass blockEntities;
    @Nullable
    private final Pass hand;
    @Nullable
    private final Pass handTranslucent;
    @Nullable
    private final Pass glowingEntities;
    @Nullable
    private final Pass glint;
    @Nullable
    private final Pass eyes;
    private final ImmutableList<ClearPass> clearPassesFull;
    private final ImmutableList<ClearPass> clearPasses;
    private final GlFramebuffer baseline;
    private Runnable createShadowMapRenderer;
    private ShadowMapRenderer shadowMapRenderer;
    private final CompositeRenderer deferredRenderer;
    private final CompositeRenderer compositeRenderer;
    private final FinalPassRenderer finalPassRenderer;
    private final CustomTextureManager customTextureManager;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final ImmutableSet<Integer> flippedBeforeTranslucent;
    private final ImmutableSet<Integer> flippedAfterTranslucent;
    private final SodiumTerrainPipeline sodiumTerrainPipeline;
    private boolean isBeforeTranslucent;
    private final int waterId;
    private final float sunPathRotation;
    private final boolean shouldRenderClouds;
    private final boolean oldLighting;
    private final OptionalInt forcedShadowRenderDistanceChunks;
    private final List<GbufferProgram> programStack = new ArrayList<GbufferProgram>();
    private final List<String> programStackLog = new ArrayList<String>();
    private static final class_2960 WATER_IDENTIFIER = new class_2960("minecraft", "water");
    private boolean isRenderingWorld = false;
    private boolean isRenderingShadow = false;

    public DeferredWorldRenderingPipeline(ProgramSet programs) {
        Objects.requireNonNull(programs);
        this.shouldRenderClouds = programs.getPackDirectives().areCloudsEnabled();
        this.oldLighting = programs.getPackDirectives().isOldLighting();
        this.updateNotifier = new FrameUpdateNotifier();
        this.allPasses = new ArrayList<Pass>();
        this.renderTargets = new RenderTargets(class_310.method_1551().method_1522(), programs.getPackDirectives().getRenderTargetDirectives());
        this.waterId = programs.getPack().getIdMap().getBlockProperties().getOrDefault(((class_2248)class_2378.field_11146.method_10223(WATER_IDENTIFIER)).method_9564(), -1);
        this.sunPathRotation = programs.getPackDirectives().getSunPathRotation();
        PackShadowDirectives shadowDirectives = programs.getPackDirectives().getShadowDirectives();
        this.forcedShadowRenderDistanceChunks = shadowDirectives.isDistanceRenderMulExplicit() ? ((double)shadowDirectives.getDistanceRenderMul() >= 0.0 ? OptionalInt.of(((int)(shadowDirectives.getDistance() * shadowDirectives.getDistanceRenderMul()) + 15) / 16) : OptionalInt.of(-1)) : OptionalInt.empty();
        BlockRenderingSettings.INSTANCE.setIdMap(programs.getPack().getIdMap());
        BlockRenderingSettings.INSTANCE.setAmbientOcclusionLevel(programs.getPackDirectives().getAmbientOcclusionLevel());
        BlockRenderingSettings.INSTANCE.setDisableDirectionalShading(this.shouldDisableDirectionalShading());
        BlockRenderingSettings.INSTANCE.setUseSeparateAo(programs.getPackDirectives().shouldUseSeparateAo());
        GlStateManager.glActiveTexture((int)33986);
        this.customTextureManager = new CustomTextureManager(programs.getPackDirectives(), programs.getPack().getCustomTextureDataMap(), programs.getPack().getCustomNoiseTexture());
        GlStateManager.glActiveTexture((int)33984);
        ImmutableSet flippedBeforeTerrain = ImmutableSet.of();
        this.createShadowMapRenderer = () -> {
            this.shadowMapRenderer = new ShadowRenderer(this, programs.getShadow().orElse(null), programs.getPackDirectives(), () -> flippedBeforeTerrain, this.renderTargets, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular(), this.customTextureManager.getNoiseTexture(), programs, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object)Object2ObjectMaps.emptyMap())));
            this.createShadowMapRenderer = () -> {};
        };
        BufferFlipper flipper = new BufferFlipper();
        this.centerDepthSampler = new CenterDepthSampler(this.renderTargets, this.updateNotifier);
        this.flippedBeforeTranslucent = flipper.snapshot();
        Supplier<ShadowMapRenderer> shadowMapRendererSupplier = () -> {
            this.createShadowMapRenderer.run();
            return this.shadowMapRenderer;
        };
        this.deferredRenderer = new CompositeRenderer(programs.getPackDirectives(), programs.getDeferred(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, shadowMapRendererSupplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.DEFERRED, (Object)Object2ObjectMaps.emptyMap())), programs.getPackDirectives().getExplicitFlips("deferred_pre"));
        this.flippedAfterTranslucent = flipper.snapshot();
        this.compositeRenderer = new CompositeRenderer(programs.getPackDirectives(), programs.getComposite(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, shadowMapRendererSupplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object)Object2ObjectMaps.emptyMap())), programs.getPackDirectives().getExplicitFlips("composite_pre"));
        this.finalPassRenderer = new FinalPassRenderer(programs, this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, flipper.snapshot(), this.centerDepthSampler, shadowMapRendererSupplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object)Object2ObjectMaps.emptyMap())), this.compositeRenderer.getFlippedAtLeastOnceFinal());
        Supplier<ImmutableSet> flipped = () -> this.isBeforeTranslucent ? this.flippedBeforeTranslucent : this.flippedAfterTranslucent;
        IntFunction<ProgramSamplers> createTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object)Object2ObjectMaps.emptyMap())));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular());
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                this.createShadowMapRenderer.run();
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowMapRenderer);
            }
            return builder.build();
        };
        IntFunction<ProgramSamplers> createShadowTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object)Object2ObjectMaps.emptyMap())));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> flippedBeforeTerrain, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular());
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor) && this.shadowMapRenderer != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowMapRenderer);
            }
            return builder.build();
        };
        this.basic = programs.getGbuffersBasic().map(this::createPass).orElse(null);
        this.textured = programs.getGbuffersTextured().map(this::createPass).orElse(this.basic);
        this.texturedLit = programs.getGbuffersTexturedLit().map(this::createPass).orElse(this.textured);
        this.skyBasic = programs.getGbuffersSkyBasic().map(this::createPass).orElse(this.basic);
        this.skyTextured = programs.getGbuffersSkyTextured().map(this::createPass).orElse(this.textured);
        this.clouds = programs.getGbuffersClouds().map(this::createPass).orElse(this.textured);
        this.terrain = programs.getGbuffersTerrain().map(this::createPass).orElse(this.texturedLit);
        this.translucent = programs.getGbuffersWater().map(this::createPass).orElse(this.terrain);
        this.damagedBlock = programs.getGbuffersDamagedBlock().map(this::createPass).orElse(this.terrain);
        this.weather = programs.getGbuffersWeather().map(this::createPass).orElse(this.texturedLit);
        this.beaconBeam = programs.getGbuffersBeaconBeam().map(this::createPass).orElse(this.textured);
        this.entities = programs.getGbuffersEntities().map(this::createPass).orElse(this.texturedLit);
        this.blockEntities = programs.getGbuffersBlock().map(this::createPass).orElse(this.terrain);
        this.hand = programs.getGbuffersHand().map(this::createPass).orElse(this.texturedLit);
        this.handTranslucent = programs.getGbuffersHandWater().map(this::createPass).orElse(this.hand);
        this.glowingEntities = programs.getGbuffersEntitiesGlowing().map(this::createPass).orElse(this.entities);
        this.glint = programs.getGbuffersGlint().map(this::createPass).orElse(this.textured);
        this.eyes = programs.getGbuffersEntityEyes().map(this::createPass).orElse(this.textured);
        this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, programs.getPackDirectives().getRenderTargetDirectives());
        this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, programs.getPackDirectives().getRenderTargetDirectives());
        this.baseline = this.renderTargets.createFramebufferWritingToMain(new int[]{0});
        if (this.shadowMapRenderer == null) {
            this.shadowMapRenderer = new EmptyShadowMapRenderer(programs.getPackDirectives().getShadowDirectives().getResolution());
        }
        this.sodiumTerrainPipeline = new SodiumTerrainPipeline(programs, createTerrainSamplers, createShadowTerrainSamplers, this.renderTargets, this.flippedBeforeTranslucent, this.flippedAfterTranslucent, this.shadowMapRenderer instanceof ShadowRenderer ? ((ShadowRenderer)this.shadowMapRenderer).getFramebuffer() : null);
    }

    private void checkWorld() {
        if (class_310.method_1551().field_1687 == null) {
            this.isRenderingWorld = false;
            this.programStackLog.clear();
            this.programStack.clear();
        }
    }

    @Override
    public void pushProgram(GbufferProgram program) {
        this.checkWorld();
        if (!this.isRenderingWorld || this.isRenderingShadow) {
            return;
        }
        this.programStack.add(program);
        this.useProgram(program);
        this.programStackLog.add("push:" + (Object)((Object)program));
    }

    @Override
    public void popProgram(GbufferProgram expected) {
        Pass poppedPass;
        this.checkWorld();
        if (!this.isRenderingWorld || this.isRenderingShadow) {
            return;
        }
        if (this.programStack.isEmpty()) {
            Iris.logger.fatal("Tried to pop from an empty program stack!");
            Iris.logger.fatal("Program stack log: " + this.programStackLog);
            throw new IllegalStateException("Tried to pop from an empty program stack!");
        }
        GbufferProgram popped = this.programStack.remove(this.programStack.size() - 1);
        if (popped != expected) {
            Iris.logger.fatal("Program stack in invalid state, popped " + (Object)((Object)popped) + " but expected to pop " + (Object)((Object)expected));
            Iris.logger.fatal("Program stack content after pop: " + this.programStack);
            throw new IllegalStateException("Program stack in invalid state, popped " + (Object)((Object)popped) + " but expected to pop " + (Object)((Object)expected));
        }
        if (popped != GbufferProgram.NONE && (poppedPass = this.getPass(popped)) != null) {
            poppedPass.stopUsing();
        }
        this.programStackLog.add("pop:" + (Object)((Object)popped));
        if (this.programStack.isEmpty()) {
            this.teardownProgram();
            return;
        }
        GbufferProgram toUse = this.programStack.get(this.programStack.size() - 1);
        this.useProgram(toUse);
    }

    private Pass getPass(GbufferProgram program) {
        switch (program) {
            case TERRAIN: {
                return this.terrain;
            }
            case TRANSLUCENT_TERRAIN: {
                return this.translucent;
            }
            case DAMAGED_BLOCKS: {
                return this.damagedBlock;
            }
            case BASIC: {
                return this.basic;
            }
            case BEACON_BEAM: {
                return this.beaconBeam;
            }
            case ENTITIES: {
                return this.entities;
            }
            case BLOCK_ENTITIES: {
                return this.blockEntities;
            }
            case ENTITIES_GLOWING: {
                return this.glowingEntities;
            }
            case EYES: {
                return this.eyes;
            }
            case ARMOR_GLINT: {
                return this.glint;
            }
            case CLOUDS: {
                return this.clouds;
            }
            case SKY_BASIC: {
                return this.skyBasic;
            }
            case SKY_TEXTURED: {
                return this.skyTextured;
            }
            case TEXTURED_LIT: {
                return this.texturedLit;
            }
            case TEXTURED: {
                return this.textured;
            }
            case WEATHER: {
                return this.weather;
            }
            case HAND: {
                return this.hand;
            }
            case HAND_TRANSLUCENT: {
                return this.handTranslucent;
            }
        }
        throw new UnsupportedOperationException("TODO: Unsupported gbuffer program: " + (Object)((Object)program));
    }

    private void useProgram(GbufferProgram program) {
        if (program == GbufferProgram.NONE) {
            Program.unbind();
            return;
        }
        Pass pass = this.getPass(program);
        this.beginPass(pass);
        if (program == GbufferProgram.TERRAIN) {
            if (this.terrain != null) {
                DeferredWorldRenderingPipeline.setupAttributes(this.terrain);
            }
        } else if (program == GbufferProgram.TRANSLUCENT_TERRAIN && this.translucent != null) {
            DeferredWorldRenderingPipeline.setupAttributes(this.translucent);
            DeferredWorldRenderingPipeline.setupAttribute(this.translucent, "mc_Entity", 10, this.waterId, -1.0f, -1.0f, -1.0f);
        }
        if (program != GbufferProgram.TRANSLUCENT_TERRAIN && pass != null && pass == this.translucent) {
            DeferredWorldRenderingPipeline.setupAttribute(this.translucent, "mc_Entity", 10, -1.0f, -1.0f, -1.0f, -1.0f);
        }
    }

    private void teardownProgram() {
        Program.unbind();
        this.baseline.bind();
    }

    @Override
    public boolean shouldDisableVanillaEntityShadows() {
        return true;
    }

    @Override
    public boolean shouldDisableDirectionalShading() {
        return !this.oldLighting;
    }

    @Override
    public boolean shouldRenderClouds() {
        return this.shouldRenderClouds;
    }

    @Override
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    private void beginPass(Pass pass) {
        if (pass != null) {
            pass.use();
        } else {
            Program.unbind();
            this.baseline.bind();
        }
    }

    private Pass createPass(ProgramSource source) {
        ProgramBuilder builder;
        Objects.requireNonNull(source.getVertexSource());
        Objects.requireNonNull(source.getFragmentSource());
        try {
            builder = ProgramBuilder.begin(source.getName(), source.getVertexSource().orElse(null), source.getGeometrySource().orElse(null), source.getFragmentSource().orElse(null), IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Shader compilation failed!", e);
        }
        CommonUniforms.addCommonUniforms(builder, source.getParent().getPack().getIdMap(), source.getParent().getPackDirectives(), this.updateNotifier, null);
        Supplier<ImmutableSet<Integer>> flipped = () -> this.isBeforeTranslucent ? this.flippedBeforeTranslucent : this.flippedAfterTranslucent;
        TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)textureStage, (Object)Object2ObjectMaps.emptyMap())));
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false);
        IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular());
        IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            this.createShadowMapRenderer.run();
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowMapRenderer);
        }
        GlFramebuffer framebufferBeforeTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedBeforeTranslucent, source.getDirectives().getDrawBuffers());
        GlFramebuffer framebufferAfterTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, source.getDirectives().getDrawBuffers());
        builder.bindAttributeLocation(10, "mc_Entity");
        builder.bindAttributeLocation(11, "mc_midTexCoord");
        builder.bindAttributeLocation(12, "at_tangent");
        AlphaTest alphaTestOverride = source.getDirectives().getAlphaTestOverride().orElse(null);
        Pass pass = new Pass(builder.build(), framebufferBeforeTranslucents, framebufferAfterTranslucents, alphaTestOverride, source.getDirectives().getBlendModeOverride());
        this.allPasses.add(pass);
        return pass;
    }

    @Override
    public void destroy() {
        DeferredWorldRenderingPipeline.destroyPasses(this.allPasses);
        this.compositeRenderer.destroy();
        this.deferredRenderer.destroy();
        this.finalPassRenderer.destroy();
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
        GlStateManager._glBindFramebuffer((int)36009, (int)0);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
        class_310.method_1551().method_1522().method_1235(false);
        this.renderTargets.destroy();
        this.shadowMapRenderer.destroy();
        this.customTextureManager.destroy();
    }

    private static void destroyPasses(List<Pass> passes) {
        HashSet<Pass> destroyed = new HashSet<Pass>();
        for (Pass pass : passes) {
            if (pass == null || destroyed.contains(pass)) continue;
            pass.destroy();
            destroyed.add(pass);
        }
    }

    private static void setupAttributes(Pass pass) {
        float blockId = -1.0f;
        DeferredWorldRenderingPipeline.setupAttribute(pass, "mc_Entity", 10, blockId, -1.0f, -1.0f, -1.0f);
        DeferredWorldRenderingPipeline.setupAttribute(pass, "mc_midTexCoord", 11, 0.0f, 0.0f, 0.0f, 0.0f);
        DeferredWorldRenderingPipeline.setupAttribute(pass, "at_tangent", 12, 1.0f, 0.0f, 0.0f, 1.0f);
    }

    private static void setupAttribute(Pass pass, String name, int expectedLocation, float v0, float v1, float v2, float v3) {
        int location = GL20.glGetAttribLocation((int)pass.getProgram().getProgramId(), (CharSequence)name);
        if (location != -1) {
            if (location != expectedLocation) {
                throw new IllegalStateException();
            }
            GL20.glVertexAttrib4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
        }
    }

    private void prepareRenderTargets() {
        ImmutableList<ClearPass> passes;
        RenderSystem.activeTexture((int)33984);
        class_276 main = class_310.method_1551().method_1522();
        this.renderTargets.resizeIfNeeded(main.field_1482, main.field_1481);
        if (this.renderTargets.isFullClearRequired()) {
            this.renderTargets.onFullClear();
            passes = this.clearPassesFull;
        } else {
            passes = this.clearPasses;
        }
        class_243 fogColor3 = CapturedRenderingState.INSTANCE.getFogColor();
        Vector4f fogColor = new Vector4f((float)fogColor3.field_1352, (float)fogColor3.field_1351, (float)fogColor3.field_1350, 1.0f);
        for (ClearPass clearPass : passes) {
            clearPass.execute(fogColor);
        }
    }

    @Override
    public void beginHand() {
        this.baseline.bindAsReadBuffer();
        GlStateManager._bindTexture((int)this.renderTargets.getDepthTextureNoHand().getTextureId());
        GL20C.glCopyTexImage2D((int)3553, (int)0, (int)6402, (int)0, (int)0, (int)this.renderTargets.getCurrentWidth(), (int)this.renderTargets.getCurrentHeight(), (int)0);
        GlStateManager._bindTexture((int)0);
    }

    @Override
    public void beginTranslucents() {
        this.isBeforeTranslucent = false;
        this.baseline.bindAsReadBuffer();
        GlStateManager._bindTexture((int)this.renderTargets.getDepthTextureNoTranslucents().getTextureId());
        GL20C.glCopyTexImage2D((int)3553, (int)0, (int)6402, (int)0, (int)0, (int)this.renderTargets.getCurrentWidth(), (int)this.renderTargets.getCurrentHeight(), (int)0);
        GlStateManager._bindTexture((int)0);
        this.deferredRenderer.renderAll();
        Program.unbind();
        RenderSystem.enableBlend();
        class_310.method_1551().field_1773.method_22974().method_3316();
        class_310.method_1551().field_1773.method_22975().method_23209();
        if (!this.programStack.isEmpty()) {
            GbufferProgram toUse = this.programStack.get(this.programStack.size() - 1);
            this.useProgram(toUse);
        } else {
            this.useProgram(GbufferProgram.NONE);
            this.baseline.bind();
        }
    }

    @Override
    public void renderShadows(LevelRendererAccessor worldRenderer, class_4184 playerCamera) {
        this.shadowMapRenderer.renderShadows(worldRenderer, playerCamera);
    }

    @Override
    public void addDebugText(List<String> messages) {
        if (this.shadowMapRenderer != null) {
            messages.add("");
            this.shadowMapRenderer.addDebugText(messages);
        }
    }

    @Override
    public OptionalInt getForcedShadowRenderDistanceChunksForDisplay() {
        return this.forcedShadowRenderDistanceChunks;
    }

    @Override
    public void beginLevelRendering() {
        this.isRenderingWorld = true;
        this.isBeforeTranslucent = true;
        HandRenderer.INSTANCE.getBufferSource().resetDrawCalls();
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("beginWorldRender was called but we are not currently rendering a world?");
            return;
        }
        if (!this.programStack.isEmpty()) {
            throw new IllegalStateException("Program stack before the start of rendering, something has gone very wrong!");
        }
        this.updateNotifier.onNewFrame();
        this.prepareRenderTargets();
        this.pushProgram(GbufferProgram.BASIC);
    }

    @Override
    public void finalizeLevelRendering() {
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("finalizeWorldRendering was called but we are not currently rendering a world?");
            return;
        }
        this.popProgram(GbufferProgram.BASIC);
        if (!this.programStack.isEmpty()) {
            Iris.logger.fatal("Program stack not empty at end of rendering, something has gone very wrong!");
            Iris.logger.fatal("Program stack log: " + this.programStackLog);
            Iris.logger.fatal("Program stack content: " + this.programStack);
            throw new IllegalStateException("Program stack not empty at end of rendering, something has gone very wrong!");
        }
        this.isRenderingWorld = false;
        this.programStackLog.clear();
        this.compositeRenderer.renderAll();
        this.finalPassRenderer.renderFinalPass();
    }

    @Override
    public SodiumTerrainPipeline getSodiumTerrainPipeline() {
        return this.sodiumTerrainPipeline;
    }

    @Override
    public FrameUpdateNotifier getFrameUpdateNotifier() {
        return this.updateNotifier;
    }

    @Override
    public void beginShadowRender() {
        this.isRenderingShadow = true;
    }

    @Override
    public void endShadowRender() {
        this.isRenderingShadow = false;
    }

    private final class Pass {
        private final Program program;
        private final GlFramebuffer framebufferBeforeTranslucents;
        private final GlFramebuffer framebufferAfterTranslucents;
        private final AlphaTest alphaTestOverride;
        private final BlendModeOverride blendModeOverride;

        private Pass(Program program, GlFramebuffer framebufferBeforeTranslucents, GlFramebuffer framebufferAfterTranslucents, AlphaTest alphaTestOverride, BlendModeOverride blendModeOverride) {
            this.program = program;
            this.framebufferBeforeTranslucents = framebufferBeforeTranslucents;
            this.framebufferAfterTranslucents = framebufferAfterTranslucents;
            this.alphaTestOverride = alphaTestOverride;
            this.blendModeOverride = blendModeOverride;
        }

        public void use() {
            if (DeferredWorldRenderingPipeline.this.isBeforeTranslucent) {
                this.framebufferBeforeTranslucents.bind();
            } else {
                this.framebufferAfterTranslucents.bind();
            }
            this.program.use();
            if (this.alphaTestOverride != null) {
                this.alphaTestOverride.setup();
            }
            if (this.blendModeOverride != null) {
                this.blendModeOverride.apply();
            } else {
                BlendModeOverride.restore();
            }
        }

        public void stopUsing() {
            if (this.alphaTestOverride != null) {
                AlphaTest.teardown();
            }
            if (this.blendModeOverride != null) {
                BlendModeOverride.restore();
            }
        }

        public Program getProgram() {
            return this.program;
        }

        public void destroy() {
            this.program.destroy();
        }
    }
}

