/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.coderbot.iris.HorizonRenderer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.HandRenderer;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.WorldRenderingPhase;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
@Environment(value=EnvType.CLIENT)
public class MixinLevelRenderer {
    @Shadow
    @Final
    private class_310 field_4088;
    private static final String PROFILER_SWAP = "Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V";
    private static final String RENDER = "Lnet/minecraft/client/renderer/LevelRenderer;renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lcom/mojang/math/Matrix4f;)V";
    private static final String CLEAR = "Lcom/mojang/blaze3d/systems/RenderSystem;clear(IZ)V";
    private static final String RENDER_SKY = "Lnet/minecraft/client/renderer/LevelRenderer;renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/math/Matrix4f;FLjava/lang/Runnable;)V";
    private static final String RENDER_LAYER = "renderLayer(Lnet/minecraft/client/render/RenderLayer;Lnet/minecraft/client/util/math/MatrixStack;DDD)V";
    private static final String RENDER_CLOUDS = "Lnet/minecraft/client/render/WorldRenderer;renderClouds(Lnet/minecraft/client/util/math/MatrixStack;FDDD)V";
    private static final String RENDER_WEATHER = "Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V";
    private static final String RENDER_WORLD_BORDER = "Lnet/minecraft/client/render/WorldRenderer;renderWorldBorder(Lnet/minecraft/client/render/Camera;)V";
    @Unique
    private HorizonRenderer horizonRenderer = new HorizonRenderer();
    @Unique
    private boolean skyTextureEnabled;
    @Unique
    private int previousViewDistance;
    @Unique
    private WorldRenderingPipeline pipeline;

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;clear(IZ)V", shift=At.Shift.AFTER, remap=false)})
    private void iris$beginLevelRender(class_4587 poseStack, float tickDelta, long startTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 projection, CallbackInfo callback) {
        if (Iris.isSodiumInvalid()) {
            throw new IllegalStateException("An invalid version of Sodium is installed, and the warning screen somehow didn't work. This is a bug! Please report it to the Iris developers.");
        }
        CapturedRenderingState.INSTANCE.setGbufferModelView(poseStack.method_23760().method_23761());
        CapturedRenderingState.INSTANCE.setGbufferProjection(projection);
        CapturedRenderingState.INSTANCE.setTickDelta(tickDelta);
        SystemTimeUniforms.COUNTER.beginFrame();
        SystemTimeUniforms.TIMER.beginFrame(startTime);
        if (this.previousViewDistance != this.field_4088.field_1690.field_1870) {
            this.horizonRenderer.close();
            this.horizonRenderer = new HorizonRenderer();
            this.previousViewDistance = this.field_4088.field_1690.field_1870;
        }
        this.pipeline = Iris.getPipelineManager().preparePipeline(Iris.getCurrentDimension());
        this.pipeline.beginLevelRendering();
        this.pipeline.setPhase(WorldRenderingPhase.OTHER);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lcom/mojang/math/Matrix4f;)V"}, at={@At(value="RETURN", shift=At.Shift.BEFORE)})
    private void iris$endLevelRender(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 matrix4f, CallbackInfo callback) {
        HandRenderer.INSTANCE.renderTranslucent(poseStack, tickDelta, camera, gameRenderer, this.pipeline);
        class_310.method_1551().method_16011().method_15405("iris_final");
        this.pipeline.finalizeLevelRendering();
        this.pipeline.setPhase(WorldRenderingPhase.NOT_RENDERING_WORLD);
        this.pipeline = null;
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lcom/mojang/math/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V", shift=At.Shift.AFTER)})
    private void iris$renderTerrainShadows(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 matrix4f, CallbackInfo callback) {
        this.pipeline.renderShadows((LevelRendererAccessor)((Object)this), camera);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/math/Matrix4f;FLjava/lang/Runnable;)V")})
    private void iris$beginSky(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 projection, CallbackInfo callback) {
        this.pipeline.setPhase(WorldRenderingPhase.SKY);
        RenderSystem.setShader(class_757::method_34539);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/math/Matrix4f;FLjava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/FogRenderer;levelFogColor()V")})
    private void iris$renderSky$drawHorizon(class_4587 poseStack, class_1159 projectionMatrix, float f, Runnable runnable, CallbackInfo callback) {
        RenderSystem.depthMask((boolean)false);
        class_243 fogColor = CapturedRenderingState.INSTANCE.getFogColor();
        RenderSystem.setShaderColor((float)((float)fogColor.field_1352), (float)((float)fogColor.field_1351), (float)((float)fogColor.field_1350), (float)1.0f);
        this.horizonRenderer.renderHorizon(poseStack.method_23760().method_23761().method_22673(), projectionMatrix.method_22673(), class_757.method_34539());
        RenderSystem.depthMask((boolean)true);
    }

    @Inject(method={"renderSky"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getTimeOfDay(F)F")}, slice={@Slice(from=@At(value="FIELD", target="com/mojang/math/Vector3f.YP : Lcom/mojang/math/Vector3f;"))})
    private void iris$renderSky$tiltSun(class_4587 poseStack, class_1159 projectionMatrix, float f, Runnable runnable, CallbackInfo callback) {
        poseStack.method_22907(class_1160.field_20707.method_23214(this.pipeline.getSunPathRotation()));
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lcom/mojang/math/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/math/Matrix4f;FLjava/lang/Runnable;)V", shift=At.Shift.AFTER)})
    private void iris$endSky(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 matrix4f, CallbackInfo callback) {
        this.pipeline.setPhase(WorldRenderingPhase.OTHER);
    }

    @Inject(method={"renderClouds"}, at={@At(value="HEAD")}, cancellable=true)
    private void iris$maybeRemoveClouds(class_4587 poseStack, class_1159 matrix4f, float f, double d, double e, double g, CallbackInfo ci) {
        if (!this.pipeline.shouldRenderClouds()) {
            ci.cancel();
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lcom/mojang/math/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V")})
    private void iris$beginWeather(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 matrix4f, CallbackInfo callback) {
        this.pipeline.setPhase(WorldRenderingPhase.WEATHER);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/LevelRenderer;renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lcom/mojang/math/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V", shift=At.Shift.AFTER)})
    private void iris$endWeather(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 matrix4f, CallbackInfo callback) {
        this.pipeline.setPhase(WorldRenderingPhase.OTHER);
    }

    @Inject(method={"renderLevel"}, at={@At(value="CONSTANT", args={"stringValue=translucent"})})
    private void iris$beginTranslucents(class_4587 poseStack, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, class_1159 projection, CallbackInfo ci) {
        this.pipeline.beginHand();
        HandRenderer.INSTANCE.renderSolid(poseStack, tickDelta, camera, gameRenderer, this.pipeline);
        class_310.method_1551().method_16011().method_15405("iris_pre_translucent");
        this.pipeline.beginTranslucents();
    }
}

