/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.text.StringCharacterIterator;
import java.util.List;
import java.util.Objects;
import net.coderbot.iris.Iris;
import net.minecraft.class_124;
import net.minecraft.class_340;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_340.class})
public abstract class MixinDebugScreenOverlay {
    @Unique
    private static final List<BufferPoolMXBean> pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
    @Unique
    private static final BufferPoolMXBean directPool;

    @Inject(method={"getSystemInformation"}, at={@At(value="RETURN")})
    private void appendShaderPackText(CallbackInfoReturnable<List<String>> cir) {
        List messages = (List)cir.getReturnValue();
        messages.add("");
        messages.add("[Iris] Version: " + Iris.getFormattedVersion());
        messages.add("");
        if (Iris.getIrisConfig().areShadersEnabled()) {
            messages.add("[Iris] Shaderpack: " + Iris.getCurrentPackName());
        } else {
            messages.add("[Iris] Shaders are disabled");
        }
        messages.add(3, "Direct Buffers: +" + MixinDebugScreenOverlay.humanReadableByteCountBin(directPool.getMemoryUsed()));
        if (!Iris.isSodiumInstalled()) {
            messages.add(3, "Native Memory: +" + MixinDebugScreenOverlay.humanReadableByteCountBin(MixinDebugScreenOverlay.getNativeMemoryUsage()));
        }
    }

    @Inject(method={"getGameInformation"}, at={@At(value="RETURN")})
    private void appendShadowDebugText(CallbackInfoReturnable<List<String>> cir) {
        List messages = (List)cir.getReturnValue();
        if (!Iris.isSodiumInstalled() && Iris.getCurrentPack().isPresent()) {
            messages.add(1, class_124.field_1054 + "[Iris] Sodium isn't installed; you will have poor performance.");
            messages.add(2, class_124.field_1054 + "[Iris] Install Sodium if you want to run benchmarks or get higher FPS!");
        }
        Iris.getPipelineManager().getPipeline().addDebugText(messages);
    }

    private static String humanReadableByteCountBin(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.3f %ciB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }

    private static long getNativeMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed();
    }

    static {
        BufferPoolMXBean found = null;
        for (BufferPoolMXBean pool : pools) {
            if (!pool.getName().equals("direct")) continue;
            found = pool;
            break;
        }
        directPool = Objects.requireNonNull(found);
    }
}

