/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.screen;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.element.ShaderPackSelectionList;
import net.coderbot.iris.gui.screen.HudHideable;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

public class ShaderPackScreen
extends class_437
implements HudHideable {
    private static final class_2561 SELECT_TITLE = new class_2588("pack.iris.select.title").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
    private final class_437 parent;
    private ShaderPackSelectionList shaderPackList;
    private class_2561 addedPackDialog = null;
    private int addedPackDialogTimer = 0;
    private boolean dropChanges = false;

    public ShaderPackScreen(class_437 parent) {
        super((class_2561)new class_2588("options.iris.shaderPackSelection.title"));
        this.parent = parent;
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        if (this.field_22787.field_1687 == null) {
            this.method_25420(poseStack);
        } else {
            this.method_25296(poseStack, 0, 0, this.field_22789, this.field_22790, 1327702819, 1327702819);
        }
        this.shaderPackList.method_25394(poseStack, mouseX, mouseY, delta);
        super.method_25394(poseStack, mouseX, mouseY, delta);
        ShaderPackScreen.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)this.field_22785, (int)((int)((double)this.field_22789 * 0.5)), (int)8, (int)0xFFFFFF);
        if (this.addedPackDialog != null && this.addedPackDialogTimer > 0) {
            ShaderPackScreen.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)this.addedPackDialog, (int)((int)((double)this.field_22789 * 0.5)), (int)21, (int)0xFFFFFF);
        } else {
            ShaderPackScreen.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)SELECT_TITLE, (int)((int)((double)this.field_22789 * 0.5)), (int)21, (int)0xFFFFFF);
        }
    }

    protected void method_25426() {
        super.method_25426();
        int bottomCenter = this.field_22789 / 2 - 50;
        int topCenter = this.field_22789 / 2 - 76;
        boolean inWorld = this.field_22787.field_1687 != null;
        this.shaderPackList = new ShaderPackSelectionList(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 58, 0, this.field_22789);
        if (inWorld) {
            this.shaderPackList.method_31322(false);
        }
        this.method_37063((class_364)this.shaderPackList);
        this.method_37063((class_364)new class_4185(bottomCenter + 104, this.field_22790 - 27, 100, 20, class_5244.field_24334, button -> this.method_25419()));
        this.method_37063((class_364)new class_4185(bottomCenter, this.field_22790 - 27, 100, 20, (class_2561)new class_2588("options.iris.apply"), button -> this.applyChanges()));
        this.method_37063((class_364)new class_4185(bottomCenter - 104, this.field_22790 - 27, 100, 20, class_5244.field_24335, button -> this.dropChangesAndClose()));
        this.method_37063((class_364)new class_4185(topCenter - 78, this.field_22790 - 51, 152, 20, (class_2561)new class_2588("options.iris.openShaderPackFolder"), button -> this.openShaderPackFolder()));
        this.method_37063((class_364)new class_4185(topCenter + 78, this.field_22790 - 51, 152, 20, (class_2561)new class_2588("options.iris.refreshShaderPacks"), button -> this.shaderPackList.refresh()));
    }

    public void method_25393() {
        super.method_25393();
        if (this.addedPackDialogTimer > 0) {
            --this.addedPackDialogTimer;
        }
    }

    public void method_29638(List<Path> paths) {
        List packs = paths.stream().filter(Iris::isValidShaderpack).collect(Collectors.toList());
        for (Path pack : packs) {
            String fileName = pack.getFileName().toString();
            try {
                ShaderPackScreen.copyShaderPack(pack, fileName);
            }
            catch (FileAlreadyExistsException e) {
                this.addedPackDialog = new class_2588("options.iris.shaderPackSelection.copyErrorAlreadyExists", new Object[]{fileName}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
                this.addedPackDialogTimer = 100;
                this.shaderPackList.refresh();
                return;
            }
            catch (IOException e) {
                Iris.logger.warn("Error copying dragged shader pack", (Throwable)e);
                this.addedPackDialog = new class_2588("options.iris.shaderPackSelection.copyError", new Object[]{fileName}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
                this.addedPackDialogTimer = 100;
                this.shaderPackList.refresh();
                return;
            }
        }
        this.shaderPackList.refresh();
        if (packs.size() == 0) {
            if (paths.size() == 1) {
                String fileName = paths.get(0).getFileName().toString();
                this.addedPackDialog = new class_2588("options.iris.shaderPackSelection.failedAddSingle", new Object[]{fileName}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
            } else {
                this.addedPackDialog = new class_2588("options.iris.shaderPackSelection.failedAdd").method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
            }
        } else if (packs.size() == 1) {
            String packName = ((Path)packs.get(0)).getFileName().toString();
            this.addedPackDialog = new class_2588("options.iris.shaderPackSelection.addedPack", new Object[]{packName}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1054});
            this.shaderPackList.select(packName);
        } else {
            this.addedPackDialog = new class_2588("options.iris.shaderPackSelection.addedPacks", new Object[]{packs.size()}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1054});
        }
        this.addedPackDialogTimer = 100;
    }

    private static void copyShaderPack(Path pack, String name) throws IOException {
        Path target = Iris.getShaderpacksDirectory().resolve(name);
        Files.copy(pack, target, new CopyOption[0]);
        if (Files.isDirectory(pack, new LinkOption[0])) {
            for (Path p2 : Files.walk(pack, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList())) {
                Path folder = pack.relativize(p2);
                if (Files.exists(folder, new LinkOption[0])) continue;
                Files.createDirectory(target.resolve(folder), new FileAttribute[0]);
            }
            for (Path p2 : Files.walk(pack, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).collect(Collectors.toSet())) {
                Path file = pack.relativize(p2);
                Files.copy(p2, target.resolve(file), new CopyOption[0]);
            }
        }
    }

    public void method_25419() {
        if (!this.dropChanges) {
            this.applyChanges();
        }
        this.field_22787.method_1507(this.parent);
    }

    private void dropChangesAndClose() {
        this.dropChanges = true;
        this.method_25419();
    }

    private void applyChanges() {
        ShaderPackSelectionList.BaseEntry base = (ShaderPackSelectionList.BaseEntry)this.shaderPackList.method_25334();
        if (!(base instanceof ShaderPackSelectionList.ShaderPackEntry)) {
            return;
        }
        ShaderPackSelectionList.ShaderPackEntry entry = (ShaderPackSelectionList.ShaderPackEntry)base;
        String name = entry.getPackName();
        Iris.getIrisConfig().setShaderPackName(name);
        Iris.getIrisConfig().setShadersEnabled(this.shaderPackList.getEnableShadersButton().enabled);
        try {
            Iris.getIrisConfig().save();
        }
        catch (IOException e) {
            Iris.logger.error("Error saving configuration file!");
            Iris.logger.catching((Throwable)e);
        }
        try {
            Iris.reload();
        }
        catch (IOException e) {
            Iris.logger.error("Error reloading shader pack while applying changes!");
            Iris.logger.catching((Throwable)e);
        }
    }

    private void openShaderPackFolder() {
        class_156.method_668().method_672(Iris.getShaderpacksDirectory().toFile());
    }
}

