/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import com.google.common.collect.ImmutableList;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.element.IrisObjectSelectionList;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class ShaderPackSelectionList
extends IrisObjectSelectionList<BaseEntry> {
    public static final List<String> BUILTIN_PACKS = ImmutableList.of();
    private static final class_2561 PACK_LIST_LABEL = new class_2588("pack.iris.list.label").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080});
    private static final class_2561 SHADERS_DISABLED_LABEL = new class_2588("options.iris.shaders.disabled");
    private static final class_2561 SHADERS_ENABLED_LABEL = new class_2588("options.iris.shaders.enabled");
    private final EnableShadersButtonEntry enableShadersButton = new EnableShadersButtonEntry(Iris.getIrisConfig().areShadersEnabled());

    public ShaderPackSelectionList(class_310 client, int width, int height, int top, int bottom, int left, int right) {
        super(client, width, height, top, bottom, left, right, 20);
        this.refresh();
    }

    public int method_25322() {
        return Math.min(308, this.field_22742 - 50);
    }

    protected int method_25337(int index) {
        return super.method_25337(index) + 2;
    }

    public void refresh() {
        this.method_25339();
        try {
            this.method_25321((class_350.class_351)this.enableShadersButton);
            Path path = Iris.getShaderpacksDirectory();
            int index = 0;
            for (String pack : BUILTIN_PACKS) {
                this.addEntry(++index, pack);
            }
            Collection folders = Files.list(path).filter(Iris::isValidShaderpack).collect(Collectors.toList());
            for (Path folder : folders) {
                String name = folder.getFileName().toString();
                if (BUILTIN_PACKS.contains(name)) continue;
                this.addEntry(++index, name);
            }
            this.method_25321((class_350.class_351)new LabelEntry(PACK_LIST_LABEL));
        }
        catch (Throwable e) {
            Iris.logger.error("Error reading files while constructing selection UI");
            Iris.logger.catching(e);
        }
    }

    public void addEntry(int index, String name) {
        ShaderPackEntry entry = new ShaderPackEntry(index, this, name);
        Iris.getIrisConfig().getShaderPackName().ifPresent(currentPackName -> {
            if (name.equals(currentPackName)) {
                this.method_25313((class_350.class_351)entry);
            }
        });
        this.method_25321((class_350.class_351)entry);
    }

    public void select(String name) {
        for (int i = 0; i < this.method_25340(); ++i) {
            BaseEntry entry = (BaseEntry)this.method_25326(i);
            if (!(entry instanceof ShaderPackEntry) || !((ShaderPackEntry)entry).packName.equals(name)) continue;
            this.method_25313((class_350.class_351)entry);
            return;
        }
    }

    public EnableShadersButtonEntry getEnableShadersButton() {
        return this.enableShadersButton;
    }

    public static class EnableShadersButtonEntry
    extends BaseEntry {
        public boolean enabled;

        public EnableShadersButtonEntry(boolean enabled) {
            this.enabled = enabled;
        }

        public void method_25343(class_4587 poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            GuiUtil.bindIrisWidgetsTexture();
            GuiUtil.drawButton(poseStack, x - 2, y - 3, entryWidth, 18, hovered, false);
            class_2561 label = this.enabled ? SHADERS_ENABLED_LABEL : SHADERS_DISABLED_LABEL;
            class_332.method_27534((class_4587)poseStack, (class_327)class_310.method_1551().field_1772, (class_2561)label, (int)(x + entryWidth / 2 - 2), (int)(y + (entryHeight - 11) / 2), (int)0xFFFFFF);
        }

        public class_2561 method_37006() {
            return new class_2588("narration.button", new Object[]{this.enabled ? SHADERS_ENABLED_LABEL : SHADERS_DISABLED_LABEL});
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.enabled = !this.enabled;
                GuiUtil.playButtonClickSound();
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }

    public static class LabelEntry
    extends BaseEntry {
        private final class_2561 label;

        public LabelEntry(class_2561 label) {
            this.label = label;
        }

        public class_2561 method_37006() {
            return this.label;
        }

        public void method_25343(class_4587 poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_332.method_27534((class_4587)poseStack, (class_327)class_310.method_1551().field_1772, (class_2561)this.label, (int)(x + entryWidth / 2 - 2), (int)(y + (entryHeight - 11) / 2), (int)0xC2C2C2);
        }
    }

    public static class ShaderPackEntry
    extends BaseEntry {
        private final String packName;
        private final ShaderPackSelectionList list;
        private final int index;

        public ShaderPackEntry(int index, ShaderPackSelectionList list, String packName) {
            this.packName = packName;
            this.list = list;
            this.index = index;
        }

        public boolean isSelected() {
            return this.list.method_25334() == this;
        }

        public String getPackName() {
            return this.packName;
        }

        public class_2561 method_37006() {
            return new class_2588("narrator.select", new Object[]{this.packName});
        }

        public void method_25343(class_4587 poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 font = class_310.method_1551().field_1772;
            int color = 0xFFFFFF;
            String name = this.packName;
            boolean shadersEnabled = this.list.getEnableShadersButton().enabled;
            if (font.method_27525((class_5348)new class_2585(name).method_27692(class_124.field_1067)) > this.list.method_25322() - 3) {
                name = font.method_27523(name, this.list.method_25322() - 8) + "...";
            }
            class_2585 text = new class_2585(name);
            if (shadersEnabled && this.method_25405(mouseX, mouseY)) {
                text = text.method_27692(class_124.field_1067);
            }
            if (this.isSelected()) {
                color = 16773731;
            }
            if (!shadersEnabled) {
                color = 0xA2A2A2;
            }
            class_332.method_27534((class_4587)poseStack, (class_327)font, (class_2561)text, (int)(x + entryWidth / 2 - 2), (int)(y + (entryHeight - 11) / 2), (int)color);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.list.getEnableShadersButton().enabled && !this.isSelected() && button == 0) {
                this.list.select(this.index);
                return true;
            }
            return false;
        }
    }

    public static abstract class BaseEntry
    extends class_4280.class_4281<BaseEntry> {
        protected BaseEntry() {
        }
    }
}

