/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import java.util.function.IntSupplier;
import net.coderbot.iris.gl.uniform.Uniform;
import net.coderbot.iris.gl.uniform.ValueUpdateNotifier;
import org.lwjgl.opengl.GL21;

public class IntUniform
extends Uniform {
    private int cachedValue = 0;
    private final IntSupplier value;

    IntUniform(int location, IntSupplier value) {
        this(location, value, null);
    }

    IntUniform(int location, IntSupplier value, ValueUpdateNotifier notifier) {
        super(location, notifier);
        this.value = value;
    }

    @Override
    public void update() {
        this.updateValue();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateValue);
        }
    }

    private void updateValue() {
        int newValue = this.value.getAsInt();
        if (this.cachedValue != newValue) {
            this.cachedValue = newValue;
            GL21.glUniform1i((int)this.location, (int)newValue);
        }
    }
}

