/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.texture;

import java.util.Optional;
import net.coderbot.iris.gl.GlVersion;

public enum InternalTextureFormat {
    RGBA(6408, GlVersion.GL_11),
    R8(33321, GlVersion.GL_30),
    RG8(33323, GlVersion.GL_30),
    RGB8(32849, GlVersion.GL_11),
    RGBA8(32856, GlVersion.GL_11),
    R8_SNORM(36756, GlVersion.GL_31),
    RG8_SNORM(36757, GlVersion.GL_31),
    RGB8_SNORM(36758, GlVersion.GL_31),
    RGBA8_SNORM(36759, GlVersion.GL_31),
    R16(33322, GlVersion.GL_30),
    RG16(33324, GlVersion.GL_30),
    RGB16(32852, GlVersion.GL_11),
    RGBA16(32859, GlVersion.GL_11),
    R16_SNORM(36760, GlVersion.GL_31),
    RG16_SNORM(36761, GlVersion.GL_31),
    RGB16_SNORM(36762, GlVersion.GL_31),
    RGBA16_SNORM(36763, GlVersion.GL_31),
    R16F(33325, GlVersion.GL_30),
    RG16F(33327, GlVersion.GL_30),
    RGB16F(34843, GlVersion.GL_30),
    RGBA16F(34842, GlVersion.GL_30),
    R32F(33326, GlVersion.GL_30),
    RG32F(33328, GlVersion.GL_30),
    RGB32F(34837, GlVersion.GL_30),
    RGBA32F(34836, GlVersion.GL_30),
    R32I(33333, GlVersion.GL_30),
    RG32I(33339, GlVersion.GL_30),
    RGB32I(36227, GlVersion.GL_30),
    RGBA32I(36226, GlVersion.GL_30),
    R32UI(33334, GlVersion.GL_30),
    RG32UI(33340, GlVersion.GL_30),
    RGB32UI(36209, GlVersion.GL_30),
    RGBA32UI(36208, GlVersion.GL_30),
    R3_G3_B2(10768, GlVersion.GL_11),
    RGB5_A1(32855, GlVersion.GL_11),
    RGB10_A2(32857, GlVersion.GL_11),
    R11F_G11F_B10F(35898, GlVersion.GL_30),
    RGB9_E5(35901, GlVersion.GL_30);

    private final int glFormat;
    private final GlVersion minimumGlVersion;

    private InternalTextureFormat(int glFormat, GlVersion minimumGlVersion) {
        this.glFormat = glFormat;
        this.minimumGlVersion = minimumGlVersion;
    }

    public static Optional<InternalTextureFormat> fromString(String name) {
        try {
            return Optional.of(InternalTextureFormat.valueOf(name));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public int getGlFormat() {
        return this.glFormat;
    }

    public GlVersion getMinimumGlVersion() {
        return this.minimumGlVersion;
    }
}

