/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import net.coderbot.iris.gl.shader.GlShader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20C;

public class ProgramCreator {
    private static final Logger LOGGER = LogManager.getLogger(ProgramCreator.class);

    public static int create(String name, GlShader ... shaders) {
        int result;
        int program = GL20C.glCreateProgram();
        GL20C.glBindAttribLocation((int)program, (int)10, (CharSequence)"mc_Entity");
        GL20C.glBindAttribLocation((int)program, (int)11, (CharSequence)"mc_midTexCoord");
        GL20C.glBindAttribLocation((int)program, (int)12, (CharSequence)"at_tangent");
        GL20C.glBindAttribLocation((int)program, (int)0, (CharSequence)"Position");
        GL20C.glBindAttribLocation((int)program, (int)1, (CharSequence)"UV0");
        for (GlShader shader : shaders) {
            GL20C.glAttachShader((int)program, (int)shader.getHandle());
        }
        GL20C.glLinkProgram((int)program);
        for (GlShader shader : shaders) {
            GL20C.glDetachShader((int)program, (int)shader.getHandle());
        }
        String log = GL20C.glGetProgramInfoLog((int)program);
        if (!log.isEmpty()) {
            LOGGER.warn("Program link log for " + name + ": " + log);
        }
        if ((result = GL20C.glGetProgrami((int)program, (int)35714)) != 1) {
            throw new RuntimeException("Shader program linking failed, see log for details");
        }
        return program;
    }
}

