/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.blending;

import java.util.Optional;

public enum AlphaTestFunction {
    NEVER(512, null),
    LESS(513, "<"),
    EQUAL(514, "=="),
    LEQUAL(515, "<="),
    GREATER(516, ">"),
    NOTEQUAL(517, "!="),
    GEQUAL(518, ">="),
    ALWAYS(519, null);

    private final int glId;
    private final String expression;

    private AlphaTestFunction(int glFormat, String expression) {
        this.glId = glFormat;
        this.expression = expression;
    }

    public static Optional<AlphaTestFunction> fromString(String name) {
        if ("GL_ALWAYS".equals(name)) {
            return Optional.of(ALWAYS);
        }
        try {
            return Optional.of(AlphaTestFunction.valueOf(name));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public int getGlId() {
        return this.glId;
    }

    public String getExpression() {
        return this.expression;
    }
}

