/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.shader_overrides;

import com.mojang.blaze3d.systems.RenderSystem;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.ShaderChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkProgramOverrides;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkShaderInterface;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.ShaderChunkRendererExt;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.shadows.ShadowRenderingState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderChunkRenderer.class})
public class MixinShaderChunkRenderer
implements ShaderChunkRendererExt {
    @Unique
    private IrisChunkProgramOverrides irisChunkProgramOverrides;
    @Unique
    private GlProgram<IrisChunkShaderInterface> override;
    @Shadow(remap=false)
    private GlProgram<ChunkShaderInterface> activeProgram;
    @Shadow(remap=false)
    @Final
    protected ChunkVertexType vertexType;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    private void iris$onInit(RenderDevice device, ChunkVertexType vertexType, CallbackInfo ci) {
        this.irisChunkProgramOverrides = new IrisChunkProgramOverrides();
    }

    @Inject(method={"begin"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void iris$begin(BlockRenderPass pass, CallbackInfo ci) {
        this.override = this.irisChunkProgramOverrides.getProgramOverride(pass, this.vertexType);
        if (this.override == null) {
            return;
        }
        ci.cancel();
        this.activeProgram = null;
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            RenderSystem.disableCull();
        }
        this.override.bind();
        ((IrisChunkShaderInterface)this.override.getInterface()).setup();
        this.irisChunkProgramOverrides.bindFramebuffer(pass);
    }

    @Inject(method={"end"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void iris$onEnd(CallbackInfo ci) {
        ProgramUniforms.clearActiveUniforms();
        if (this.override != null) {
            this.irisChunkProgramOverrides.unbindFramebuffer();
            ((IrisChunkShaderInterface)this.override.getInterface()).restore();
            this.override.unbind();
            this.override = null;
            ci.cancel();
        }
    }

    @Inject(method={"delete"}, at={@At(value="HEAD")}, remap=false)
    private void iris$onDelete(CallbackInfo ci) {
        this.irisChunkProgramOverrides.deleteShaders();
    }

    @Override
    public GlProgram<IrisChunkShaderInterface> iris$getOverride() {
        return this.override;
    }
}

