/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.shader_overrides;

import java.util.EnumMap;
import java.util.Optional;
import me.jellysquid.mods.sodium.client.gl.GlObject;
import me.jellysquid.mods.sodium.client.gl.shader.GlProgram;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import net.coderbot.iris.Iris;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkShaderInterface;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisShaderTypes;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisTerrainPass;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.ShaderBindingContextExt;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.shadows.ShadowRenderingState;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class IrisChunkProgramOverrides {
    private boolean shadersCreated = false;
    private final EnumMap<IrisTerrainPass, GlProgram<IrisChunkShaderInterface>> programs = new EnumMap(IrisTerrainPass.class);

    private GlShader createVertexShader(IrisTerrainPass pass, SodiumTerrainPipeline pipeline) {
        Optional<String> irisVertexShader;
        if (pass == IrisTerrainPass.SHADOW || pass == IrisTerrainPass.SHADOW_CUTOUT) {
            irisVertexShader = pipeline.getShadowVertexShaderSource();
        } else if (pass == IrisTerrainPass.GBUFFER_SOLID || pass == IrisTerrainPass.GBUFFER_CUTOUT) {
            irisVertexShader = pipeline.getTerrainVertexShaderSource();
        } else if (pass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            irisVertexShader = pipeline.getTranslucentVertexShaderSource();
        } else {
            throw new IllegalArgumentException("Unknown pass type " + (Object)((Object)pass));
        }
        String source = irisVertexShader.orElse(null);
        if (source == null) {
            return null;
        }
        return new GlShader(ShaderType.VERTEX, new class_2960("iris", "sodium-terrain.vsh"), source);
    }

    private GlShader createGeometryShader(IrisTerrainPass pass, SodiumTerrainPipeline pipeline) {
        Optional<String> irisGeometryShader;
        if (pass == IrisTerrainPass.SHADOW || pass == IrisTerrainPass.SHADOW_CUTOUT) {
            irisGeometryShader = pipeline.getShadowGeometryShaderSource();
        } else if (pass == IrisTerrainPass.GBUFFER_SOLID || pass == IrisTerrainPass.GBUFFER_CUTOUT) {
            irisGeometryShader = pipeline.getTerrainGeometryShaderSource();
        } else if (pass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            irisGeometryShader = pipeline.getTranslucentGeometryShaderSource();
        } else {
            throw new IllegalArgumentException("Unknown pass type " + (Object)((Object)pass));
        }
        String source = irisGeometryShader.orElse(null);
        if (source == null) {
            return null;
        }
        return new GlShader(IrisShaderTypes.GEOMETRY, new class_2960("iris", "sodium-terrain.gsh"), source);
    }

    private GlShader createFragmentShader(IrisTerrainPass pass, SodiumTerrainPipeline pipeline) {
        Optional<String> irisFragmentShader;
        if (pass == IrisTerrainPass.SHADOW) {
            irisFragmentShader = pipeline.getShadowFragmentShaderSource();
        } else if (pass == IrisTerrainPass.SHADOW_CUTOUT) {
            irisFragmentShader = pipeline.getShadowCutoutFragmentShaderSource();
        } else if (pass == IrisTerrainPass.GBUFFER_SOLID) {
            irisFragmentShader = pipeline.getTerrainFragmentShaderSource();
        } else if (pass == IrisTerrainPass.GBUFFER_CUTOUT) {
            irisFragmentShader = pipeline.getTerrainCutoutFragmentShaderSource();
        } else if (pass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            irisFragmentShader = pipeline.getTranslucentFragmentShaderSource();
        } else {
            throw new IllegalArgumentException("Unknown pass type " + (Object)((Object)pass));
        }
        String source = irisFragmentShader.orElse(null);
        if (source == null) {
            return null;
        }
        return new GlShader(ShaderType.FRAGMENT, new class_2960("iris", "sodium-terrain.fsh"), source);
    }

    private BlendModeOverride getBlendOverride(IrisTerrainPass pass, SodiumTerrainPipeline pipeline) {
        if (pass == IrisTerrainPass.SHADOW || pass == IrisTerrainPass.SHADOW_CUTOUT) {
            return pipeline.getShadowBlendOverride();
        }
        if (pass == IrisTerrainPass.GBUFFER_SOLID || pass == IrisTerrainPass.GBUFFER_CUTOUT) {
            return pipeline.getTerrainBlendOverride();
        }
        if (pass == IrisTerrainPass.GBUFFER_TRANSLUCENT) {
            return pipeline.getTranslucentBlendOverride();
        }
        throw new IllegalArgumentException("Unknown pass type " + (Object)((Object)pass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private GlProgram<IrisChunkShaderInterface> createShader(IrisTerrainPass pass, SodiumTerrainPipeline pipeline) {
        GlShader vertShader = this.createVertexShader(pass, pipeline);
        GlShader geomShader = this.createGeometryShader(pass, pipeline);
        GlShader fragShader = this.createFragmentShader(pass, pipeline);
        BlendModeOverride blendOverride = this.getBlendOverride(pass, pipeline);
        if (vertShader == null || fragShader == null) {
            if (vertShader != null) {
                vertShader.delete();
            }
            if (geomShader != null) {
                geomShader.delete();
            }
            if (fragShader != null) {
                fragShader.delete();
            }
            return null;
        }
        try {
            GlProgram.Builder builder = GlProgram.builder((class_2960)new class_2960("sodium", "chunk_shader_for_" + pass.getName()));
            if (geomShader != null) {
                builder.attachShader(geomShader);
            }
            GlProgram glProgram = builder.attachShader(vertShader).attachShader(fragShader).bindAttribute("a_PosId", 1).bindAttribute("a_Color", 2).bindAttribute("a_TexCoord", 3).bindAttribute("a_LightCoord", 4).bindAttribute("mc_Entity", 5).bindAttribute("mc_midTexCoord", 6).bindAttribute("at_tangent", 7).bindAttribute("a_Normal", 8).bindFragmentData("iris_FragData", 0).link(shader -> {
                int handle = ((GlObject)shader).handle();
                ShaderBindingContextExt contextExt = (ShaderBindingContextExt)shader;
                return new IrisChunkShaderInterface(handle, contextExt, pipeline, pass == IrisTerrainPass.SHADOW || pass == IrisTerrainPass.SHADOW_CUTOUT, blendOverride);
            });
            return glProgram;
        }
        finally {
            vertShader.delete();
            if (geomShader != null) {
                geomShader.delete();
            }
            fragShader.delete();
        }
    }

    private SodiumTerrainPipeline getSodiumTerrainPipeline() {
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipeline();
        if (worldRenderingPipeline != null) {
            return worldRenderingPipeline.getSodiumTerrainPipeline();
        }
        return null;
    }

    private void createShaders(ChunkVertexType vertexType) {
        SodiumTerrainPipeline pipeline = this.getSodiumTerrainPipeline();
        Iris.getPipelineManager().clearSodiumShaderReloadNeeded();
        if (pipeline != null) {
            pipeline.patchShaders(vertexType);
            for (IrisTerrainPass pass : IrisTerrainPass.values()) {
                this.programs.put(pass, this.createShader(pass, pipeline));
            }
        } else {
            this.programs.clear();
        }
        this.shadersCreated = true;
    }

    @Nullable
    public GlProgram<IrisChunkShaderInterface> getProgramOverride(BlockRenderPass pass, ChunkVertexType vertexType) {
        if (Iris.getPipelineManager().isSodiumShaderReloadNeeded()) {
            this.deleteShaders();
        }
        if (!this.shadersCreated) {
            this.createShaders(vertexType);
        }
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            if (pass == BlockRenderPass.CUTOUT || pass == BlockRenderPass.CUTOUT_MIPPED) {
                return this.programs.get((Object)IrisTerrainPass.SHADOW_CUTOUT);
            }
            return this.programs.get((Object)IrisTerrainPass.SHADOW);
        }
        if (pass == BlockRenderPass.CUTOUT || pass == BlockRenderPass.CUTOUT_MIPPED) {
            return this.programs.get((Object)IrisTerrainPass.GBUFFER_CUTOUT);
        }
        if (pass.isTranslucent()) {
            return this.programs.get((Object)IrisTerrainPass.GBUFFER_TRANSLUCENT);
        }
        return this.programs.get((Object)IrisTerrainPass.GBUFFER_SOLID);
    }

    public void bindFramebuffer(BlockRenderPass pass) {
        GlFramebuffer framebuffer;
        SodiumTerrainPipeline pipeline = this.getSodiumTerrainPipeline();
        boolean isShadowPass = ShadowRenderingState.areShadowsCurrentlyBeingRendered();
        if (pipeline != null && (framebuffer = isShadowPass ? pipeline.getShadowFramebuffer() : (pass.isTranslucent() ? pipeline.getTranslucentFramebuffer() : pipeline.getTerrainFramebuffer())) != null) {
            framebuffer.bind();
        }
    }

    public void unbindFramebuffer() {
        class_310.method_1551().method_1522().method_1235(false);
    }

    public void deleteShaders() {
        for (GlProgram<IrisChunkShaderInterface> program : this.programs.values()) {
            if (program == null) continue;
            program.delete();
        }
        this.programs.clear();
        this.shadersCreated = false;
    }
}

