/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.renderer;

import juuxel.adorn.block.entity.TradingStationBlockEntity;
import juuxel.adorn.platform.PlatformBridges;
import juuxel.adorn.platform.PlatformBridgesKt;
import juuxel.adorn.trading.Trade;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.ColorsKt;
import juuxel.adorn.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_809;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0007\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016JP\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ljuuxel/adorn/client/renderer/TradingStationRenderer;", "Lnet/minecraft/client/render/block/entity/BlockEntityRenderer;", "Ljuuxel/adorn/block/entity/TradingStationBlockEntity;", "context", "Lnet/minecraft/client/render/block/entity/BlockEntityRendererFactory$Context;", "(Lnet/minecraft/client/render/block/entity/BlockEntityRendererFactory$Context;)V", "dispatcher", "Lnet/minecraft/client/render/block/entity/BlockEntityRenderDispatcher;", "kotlin.jvm.PlatformType", "textRenderer", "Lnet/minecraft/client/font/TextRenderer;", "render", "", "be", "tickDelta", "", "matrices", "Lnet/minecraft/client/util/math/MatrixStack;", "vertexConsumers", "Lnet/minecraft/client/render/VertexConsumerProvider;", "light", "", "overlay", "renderLabel", "Lnet/minecraft/block/entity/BlockEntity;", "label", "Lnet/minecraft/text/Text;", "x", "", "y", "z", "maxDistance", "Companion", "Adorn"})
@Environment(value=EnvType.CLIENT)
public final class TradingStationRenderer
implements class_827<TradingStationBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final class_824 dispatcher;
    private final class_327 textRenderer;
    private static final float SELLING_ROTATION_MULTIPLIER = 1.2f;
    @NotNull
    private static final String OWNER_LABEL = "block.adorn.trading_station.label.owner";
    @NotNull
    private static final String SELLING_LABEL = "block.adorn.trading_station.label.selling";
    @NotNull
    private static final String PRICE_LABEL = "block.adorn.trading_station.label.price";

    public TradingStationRenderer(@NotNull class_5614.class_5615 context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.dispatcher = context.method_32139();
        this.textRenderer = context.method_32143();
    }

    public void render(@NotNull TradingStationBlockEntity be, float tickDelta, @NotNull class_4587 matrices, @NotNull class_4597 vertexConsumers, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        class_239 hitResult = this.dispatcher.field_4350;
        boolean lookingAtBlock = hitResult != null && hitResult.method_17783() == class_239.class_240.field_1332 && Intrinsics.areEqual((Object)be.method_11016(), (Object)((class_3965)hitResult).method_17777());
        Trade trade = be.getTrade();
        if (!trade.isEmpty()) {
            matrices.method_22903();
            matrices.method_22904(0.5, 1.2, 0.5);
            class_746 class_7462 = class_310.method_1551().field_1724;
            Intrinsics.checkNotNull((Object)class_7462);
            int playerAge = class_7462.field_6012;
            matrices.method_22903();
            matrices.method_22907(class_1160.field_20705.method_23214(((float)playerAge + tickDelta) * 1.2f));
            matrices.method_22905(0.6f, 0.6f, 0.6f);
            matrices.method_22904(0.0, 0.3, 0.0);
            class_918 itemRenderer = class_310.method_1551().method_1480();
            itemRenderer.method_23178(trade.getSelling(), class_809.class_811.field_4319, light, overlay, matrices, vertexConsumers, 0);
            matrices.method_22909();
            matrices.method_22909();
        }
        if (lookingAtBlock) {
            PlatformBridges.Companion this_$iv = PlatformBridges.Companion;
            boolean $i$f$getConfigManager2 = false;
            if (PlatformBridgesKt.get(this_$iv).getConfigManager().getConfig().getClient().getShowTradingStationTooltips()) {
                Object[] $i$f$getConfigManager2 = new Object[]{be.getOwnerName().method_27662().method_27692(class_124.field_1065)};
                class_2588 label1 = new class_2588(OWNER_LABEL, $i$f$getConfigManager2);
                this.renderLabel(be, (class_2561)label1, 0.0, 0.9, 0.0, 12, matrices, vertexConsumers, light);
                if (!be.getTrade().isEmpty()) {
                    Object[] objectArray = new Object[]{ExtensionsKt.toTextWithCount(be.getTrade().getSelling())};
                    class_2588 label2 = new class_2588(SELLING_LABEL, objectArray);
                    Object[] objectArray2 = new Object[]{ExtensionsKt.toTextWithCount(be.getTrade().getPrice())};
                    class_2588 label3 = new class_2588(PRICE_LABEL, objectArray2);
                    this.renderLabel(be, (class_2561)label2, 0.0, 0.65, 0.0, 12, matrices, vertexConsumers, light);
                    this.renderLabel(be, (class_2561)label3, 0.0, 0.4, 0.0, 12, matrices, vertexConsumers, light);
                }
            }
        }
    }

    private final void renderLabel(class_2586 be, class_2561 label, double x, double y, double z, int maxDistance, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_4184 camera = this.dispatcher.field_4344;
        double dist = ExtensionsKt.getSquaredDistance(be, camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350);
        if (dist < (double)(maxDistance * maxDistance)) {
            matrices.method_22903();
            matrices.method_22904(x + 0.5, y + 1.5, z + 0.5);
            matrices.method_22907(camera.method_23767());
            matrices.method_22905(-0.025f, -0.025f, 0.025f);
            class_1159 positionMatrix = matrices.method_23760().method_23761();
            float opacity = class_310.method_1551().field_1690.method_19343(0.25f);
            int backgroundColor = ColorsKt.color(0, opacity);
            float textX = (float)(-this.textRenderer.method_27525((class_5348)label)) / 2.0f;
            this.textRenderer.method_30882(label, textX, 0.0f, Colors.INSTANCE.getWHITE(), false, positionMatrix, vertexConsumers, false, backgroundColor, light);
            matrices.method_22909();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljuuxel/adorn/client/renderer/TradingStationRenderer$Companion;", "", "()V", "OWNER_LABEL", "", "PRICE_LABEL", "SELLING_LABEL", "SELLING_ROTATION_MULTIPLIER", "", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

