/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.chisel.legacy.config;

import com.matthewperiut.chisel.legacy.Ref;
import com.matthewperiut.chisel.legacy.block.ReplaceBlock;
import com.matthewperiut.chisel.legacy.item.ChiselBlockItem;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.blockstate.JBlockModel;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.models.JModel;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4970;

public class BlockVariant {
    private final String packDir;
    private final String typeName;
    private final String variantName;
    private final class_2248 block;
    private final String model;

    public BlockVariant(String packDir, String typeName, String variantName, FabricBlockSettings settings, String model, boolean transparent) {
        this.packDir = packDir;
        this.typeName = typeName;
        this.variantName = variantName;
        this.model = model;
        this.block = this.makeBlock(settings, transparent);
    }

    public String getName() {
        return this.packDir + "/" + this.typeName + "/" + this.variantName;
    }

    public String getVariantName() {
        return this.variantName;
    }

    public class_2960 identifier() {
        return new class_2960("chisel", this.getName());
    }

    public class_2248 makeBlock(FabricBlockSettings settings, boolean transparent) {
        FabricBlockSettings tempSettings = FabricBlockSettings.copyOf((class_4970.class_2251)settings);
        return new ReplaceBlock((class_4970.class_2251)tempSettings, this.typeName, this.variantName);
    }

    public void registerBlock() {
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)this.identifier(), (Object)this.block);
        ChiselBlockItem item = new ChiselBlockItem(this.block, (class_1792.class_1793)new FabricItemSettings(), this.packDir, this.typeName, this.variantName);
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)this.identifier(), (Object)((Object)item));
    }

    public void registerDrop(RuntimeResourcePack resourcePack) {
        JLootTable table = JLootTable.loot((String)"minecraft:block").pool(JLootTable.pool().rolls(Integer.valueOf(1)).entry(JLootTable.entry().type("minecraft:item").name(this.identifier().toString())).condition(JLootTable.predicate((String)"minecraft:survives_explosion")));
        resourcePack.addLootTable(new class_2960("chisel", "blocks/" + this.packDir + "/" + this.typeName + "/" + this.variantName), table);
    }

    public void registerBlockModel(RuntimeResourcePack resourcePack) {
        JModel blockModel;
        String texturePath = "chisel:blocks/" + this.getName();
        if (this.model.equals("block/cube_column")) {
            String textureSide = texturePath + "-side";
            String textureEnd = texturePath + "-top";
            blockModel = JModel.model((String)this.model).textures(JModel.textures().var("side", textureSide).var("end", textureEnd));
        } else if (this.model.equals("block/cube_bottom_top")) {
            String textureSide = texturePath + "-side";
            String textureTop = texturePath + "-top";
            String textureBottom = texturePath + "-bottom";
            blockModel = JModel.model((String)this.model).textures(JModel.textures().var("side", textureSide).var("top", textureTop).var("bottom", textureBottom));
        } else if (this.model.equals("two_layer_topshaded")) {
            String textureParticle = texturePath + "-particle";
            String textureTop = texturePath + "-top";
            String textureBot = texturePath + "-bot";
            blockModel = Ref.CUBE_TWO_LAYER_TOPSHADED.clone().textures(JModel.textures().var("particle", textureParticle).var("top", textureTop).var("bot", textureBot));
        } else if (this.model.equals("three_layer_topshaded")) {
            String textureParticle = texturePath + "-particle";
            String textureTop = texturePath + "-top";
            String textureMid = texturePath + "-mid";
            String textureBot = texturePath + "-bot";
            blockModel = Ref.CUBE_THREE_LAYER_TOPSHADED.clone().textures(JModel.textures().var("particle", textureParticle).var("top", textureTop).var("mid", textureMid).var("bot", textureBot));
        } else {
            blockModel = JModel.model((String)"block/cube_all").textures(JModel.textures().var("all", texturePath));
        }
        resourcePack.addModel(blockModel, new class_2960("chisel", "block/" + this.getName()));
    }

    public void registerItemModel(RuntimeResourcePack resourcePack) {
        String modelPath = "chisel:block/" + this.getName();
        JModel itemModel = JModel.model((String)modelPath);
        resourcePack.addModel(itemModel, new class_2960("chisel", "item/" + this.getName()));
    }

    public void registerBlockState(RuntimeResourcePack resourcePack) {
        JState blockState = JState.state((JVariant[])new JVariant[]{JState.variant((JBlockModel)JState.model((String)("chisel:block/" + this.getName())))});
        resourcePack.addBlockState(blockState, this.identifier());
    }
}

