/*
 * Decompiled with CFR 0.152.
 */
package uk.me.desert_island.rer.rei_stuff;

import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import org.apache.commons.lang3.StringUtils;
import uk.me.desert_island.rer.RERUtils;
import uk.me.desert_island.rer.client.ClientWorldGenState;
import uk.me.desert_island.rer.rei_stuff.LootDisplay;
import uk.me.desert_island.rer.rei_stuff.WorldGenDisplay;

@Environment(value=EnvType.CLIENT)
public class WorldGenCategory
implements DisplayCategory<WorldGenDisplay> {
    static final Map<class_5321<class_1937>, CategoryIdentifier<?>> WORLD_IDENTIFIER_MAP = Maps.newHashMap();
    private final class_5321<class_1937> world;
    private int scroll;

    public CategoryIdentifier<? extends WorldGenDisplay> getCategoryIdentifier() {
        return WORLD_IDENTIFIER_MAP.get(this.world);
    }

    public WorldGenCategory(class_5321<class_1937> world) {
        WORLD_IDENTIFIER_MAP.put(world, CategoryIdentifier.of((String)"roughlyenoughresources", (String)(world.method_29177().method_12832() + "_worldgen_category")));
        this.world = world;
    }

    public class_5321<class_1937> getWorld() {
        return this.world;
    }

    public Renderer getIcon() {
        return EntryStacks.of((class_1799)RERUtils.fromWorldToItemStack(this.world));
    }

    public DisplayRenderer getSimpleRenderer(WorldGenDisplay recipe) {
        final EntryIngredient stacks = recipe.getOutputEntries().get(0);
        final Tooltip[] tooltip = new Tooltip[]{null};
        return new DisplayRenderer(){

            private EntryStack<?> getCurrent() {
                if (stacks.isEmpty()) {
                    return EntryStack.empty();
                }
                return stacks.size() == 1 ? (EntryStack)stacks.get(0) : (EntryStack)stacks.get(class_3532.method_15357((double)((double)(System.currentTimeMillis() / 500L) % (double)stacks.size())));
            }

            public Tooltip getTooltip(Point mouse) {
                return tooltip[0];
            }

            public int getHeight() {
                return 22;
            }

            public void render(class_4587 matrices, Rectangle rectangle, int mouseX, int mouseY, float delta) {
                EntryStack<?> current = this.getCurrent();
                Rectangle innerBounds = new Rectangle(rectangle.x + rectangle.width / 2 - 8, rectangle.y + 3, 16, 16);
                current.render(matrices, innerBounds, mouseX, mouseY, delta);
                tooltip[0] = innerBounds.contains(mouseX, mouseY) ? current.getTooltip(new Point(mouseX, mouseY)) : null;
            }
        };
    }

    public class_2561 getTitle() {
        return new class_2588("rer.worldgen.category", new Object[]{WorldGenCategory.mapAndJoinToString(this.world.method_29177().method_12832().split("_"), StringUtils::capitalize, " ")});
    }

    public static <T> String mapAndJoinToString(T[] list, Function<T, String> function, String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        for (T t : list) {
            joiner.add(function.apply(t));
        }
        return joiner.toString();
    }

    public List<Widget> setupDisplay(WorldGenDisplay display, Rectangle bounds) {
        this.scroll = 0;
        class_2248 block = display.getOutputBlock();
        Point startPoint = new Point(bounds.getMinX() + 2, bounds.getMinY() + 3);
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        widgets.add((Widget)Widgets.createSlotBase((Rectangle)new Rectangle(bounds.x + 1, bounds.y + 2, 130, 62)));
        widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            ClientWorldGenState worldGenState = ClientWorldGenState.byWorld(display.getWorld());
            int graphHeight = 60;
            double maxPortion = worldGenState.getMaxPortion(block);
            int mouseH = mouseX - startPoint.x;
            int mouseHeight = mouseX - startPoint.x + -64 + this.scroll;
            for (int height = 0; height < 128; ++height) {
                double portion = worldGenState.getPortionAtHeight(block, height + this.scroll);
                double relPortion = maxPortion == 0.0 ? 0.0 : portion / maxPortion;
                class_332.method_25294((class_4587)matrices, (int)(startPoint.x + height), (int)(startPoint.y + (int)((double)graphHeight * (1.0 - relPortion))), (int)(startPoint.x + height + 1), (int)(startPoint.y + graphHeight), (int)-16777216);
            }
            if (bounds.contains(mouseX, mouseY) && mouseH >= 0 && mouseH < 128 && mouseY < bounds.y + 64 && mouseHeight >= -64 && mouseHeight < 320) {
                double portion = worldGenState.getPortionAtHeight(block, mouseHeight - -64);
                double rel_portion = maxPortion == 0.0 ? 0.0 : portion / maxPortion;
                class_332.method_25294((class_4587)matrices, (int)mouseX, (int)startPoint.y, (int)(mouseX + 1), (int)(startPoint.y + graphHeight), (int)-1321676);
                class_332.method_25294((class_4587)matrices, (int)startPoint.x, (int)(startPoint.y + Math.min((int)((double)graphHeight * (1.0 - rel_portion)), graphHeight - 1)), (int)(startPoint.x + 128), (int)(startPoint.y + Math.min((int)((double)graphHeight * (1.0 - rel_portion)), graphHeight - 1) + 1), (int)-1321676);
                REIRuntime.getInstance().queueTooltip(Tooltip.create((Point)new Point(mouseX, mouseY), (class_2561[])new class_2561[]{new class_2585("Y: " + mouseHeight), new class_2585("Chance: " + LootDisplay.FORMAT_MORE.format(portion * 100.0) + "%")}));
            }
        }));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getMaxX() - 16, bounds.getMinY() + 3)).entries((Collection)display.getOutputEntries().get(0)));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.x + 65, bounds.getMaxY() - 10), (class_2561)new class_2585(class_2378.field_11146.method_10221((Object)block).toString())).noShadow().color(-12566464, -4473925));
        Button scrollLeft = Widgets.createButton((Rectangle)new Rectangle(bounds.x + 1, bounds.getMaxY(), 16, 16), (class_2561)new class_2585("\u2193"));
        scrollLeft.setOnClick(button -> this.scroll(-50));
        widgets.add((Widget)scrollLeft);
        Button scrollRight = Widgets.createButton((Rectangle)new Rectangle(bounds.x + 114, bounds.getMaxY(), 16, 16), (class_2561)new class_2585("\u2191"));
        scrollRight.setOnClick(button -> this.scroll(50));
        widgets.add((Widget)scrollRight);
        return widgets;
    }

    public int getDisplayHeight() {
        return 76;
    }

    public void scroll(int incr) {
        this.scroll = Ints.constrainToRange((int)(this.scroll + incr), (int)0, (int)256);
    }
}

