/*
 * Decompiled with CFR 0.152.
 */
package uk.me.desert_island.rer.mixin;

import java.util.concurrent.atomic.AtomicLongArray;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import uk.me.desert_island.rer.RERUtils;
import uk.me.desert_island.rer.WorldGenState;

@Mixin(value={class_2794.class})
public class MixinChunkGenerator {
    @Inject(at={@At(value="RETURN")}, method={"generateFeatures"})
    private void generateFeatures(class_5281 swa, class_2791 chunk, class_5138 structureAccessor, CallbackInfo ci) {
        long startTime = System.nanoTime();
        class_3218 world = swa.method_8410();
        int centerBlockX = chunk.method_12004().method_33940();
        int centerBlockZ = chunk.method_12004().method_33942();
        RERUtils.LOGGER.debug("generateFeatures for block %d,%d", centerBlockX, centerBlockZ);
        WorldGenState state = WorldGenState.byWorld((class_5321<class_1937>)world.method_27983());
        for (int y = -64; y < 320; ++y) {
            for (int x = centerBlockX - 8; x < centerBlockX + 8; ++x) {
                for (int z = centerBlockZ - 8; z < centerBlockZ + 8; ++z) {
                    class_2248 block = chunk.method_8320(new class_2338(x, y, z)).method_26204();
                    state.totalCountsAtLevelsMap.getAndIncrement(y - -64);
                    AtomicLongArray levelCount = state.levelCountsMap.get(block);
                    if (levelCount == null) {
                        levelCount = new AtomicLongArray(384);
                        state.levelCountsMap.put(block, levelCount);
                    }
                    levelCount.getAndIncrement(y - -64);
                    state.markPlayerDirty(block);
                }
            }
        }
        state.method_80();
        long endTime = System.nanoTime();
        RERUtils.LOGGER.debug("RER profiling that chunk took %f ms", (double)(endTime - startTime) / 1.0E9);
    }
}

