/*
 * Decompiled with CFR 0.152.
 */
package uk.me.desert_island.rer.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongArray;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_5321;

@Environment(value=EnvType.CLIENT)
public class ClientWorldGenState {
    public static final Map<class_5321<class_1937>, ClientWorldGenState> dimensionTypeStateMap = new ConcurrentHashMap<class_5321<class_1937>, ClientWorldGenState>();
    public Map<class_2248, AtomicLongArray> levelCountsMap = new ConcurrentHashMap<class_2248, AtomicLongArray>();
    public AtomicLongArray totalCountsAtLevelsMap = new AtomicLongArray(384);

    public static ClientWorldGenState byWorld(class_1937 world) {
        return ClientWorldGenState.byWorld((class_5321<class_1937>)world.method_27983());
    }

    public static ClientWorldGenState byWorld(class_5321<class_1937> dim) {
        return dimensionTypeStateMap.computeIfAbsent(dim, k -> new ClientWorldGenState());
    }

    public void readFromServerTag(class_2540 buf) {
        boolean isAppend = buf.readBoolean();
        if (!isAppend) {
            this.totalCountsAtLevelsMap = new AtomicLongArray(buf.method_10801(null));
        } else {
            long[] totalCountsAtLevels = buf.method_10801(null);
            for (int i = 0; i < totalCountsAtLevels.length; ++i) {
                long atLevel = totalCountsAtLevels[i];
                if (atLevel < 0L) continue;
                this.totalCountsAtLevelsMap.set(i, atLevel);
            }
        }
        if (!isAppend) {
            this.levelCountsMap.clear();
            while (buf.isReadable()) {
                int blockId = buf.readInt();
                class_2248 block = (class_2248)class_2378.field_11146.method_10200(blockId);
                this.levelCountsMap.put(block, new AtomicLongArray(buf.method_10801(null)));
            }
        } else {
            while (buf.isReadable()) {
                int blockId = buf.readInt();
                class_2248 block = (class_2248)class_2378.field_11146.method_10200(blockId);
                AtomicLongArray levelCount = this.levelCountsMap.get(block);
                if (levelCount == null) {
                    this.levelCountsMap.put(block, new AtomicLongArray(buf.method_10801(null)));
                    continue;
                }
                long[] countsForBlockTag = buf.method_10801(null);
                for (int i = 0; i < countsForBlockTag.length; ++i) {
                    long l = countsForBlockTag[i];
                    if (l < 0L) continue;
                    levelCount.set(i, l);
                }
            }
        }
    }

    public double getPortionAtHeight(class_2248 block, int y) {
        AtomicLongArray levelCount = this.levelCountsMap.getOrDefault(block, null);
        if (levelCount == null) {
            return 0.0;
        }
        double blockCount = levelCount.get(y);
        double totalCount = this.totalCountsAtLevelsMap.get(y);
        if (totalCount == 0.0) {
            return 0.0;
        }
        return blockCount / totalCount;
    }

    public double getMaxPortion(class_2248 block) {
        double maxPortion = 0.0;
        for (int y = 0; y < this.totalCountsAtLevelsMap.length(); ++y) {
            maxPortion = Math.max(maxPortion, this.getPortionAtHeight(block, y));
        }
        return maxPortion;
    }
}

