/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.util.CommonUtil;
import org.jetbrains.annotations.Nullable;

public class JsonConfig<T>
implements IJsonConfig<T> {
    private static final ToIntFunction DEFAULT_VERSION_GETTER = t -> 0;
    private static final ObjIntConsumer DEFAULT_VERSION_SETTER = (t, v) -> {};
    private static final Gson DEFAULT_GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
    private final Path path;
    private final CachedSupplier<T> getter;
    private final Gson gson;

    JsonConfig(Path path, Class<T> clazz, Supplier<T> factory, Gson gson, int currentVersion, ToIntFunction<T> versionGetter, ObjIntConsumer<T> versionSetter) {
        this.path = path.toAbsolutePath();
        this.gson = gson;
        this.getter = new CachedSupplier<Object>(() -> {
            Object config;
            boolean init = true;
            if (!this.isFileExists()) {
                Path parent = this.path.getParent();
                if (!Files.exists(parent, new LinkOption[0])) {
                    try {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        CommonUtil.LOGGER.error("Failed to make directory " + parent, (Throwable)e);
                    }
                }
                config = factory.get();
            } else {
                try (BufferedReader reader = Files.newBufferedReader(this.path, StandardCharsets.UTF_8);){
                    config = this.gson.fromJson((Reader)reader, clazz);
                    int version = versionGetter.applyAsInt(config);
                    if (version != currentVersion) {
                        Path old = Paths.get(this.path + "_old", new String[0]);
                        CommonUtil.LOGGER.warn("Config file " + this.path + " contains different version (" + version + ") than required version (" + currentVersion + "), this config will be reset. Old config will be placed at " + old);
                        Files.deleteIfExists(old);
                        Files.copy(this.path, old, new CopyOption[0]);
                        config = factory.get();
                    } else {
                        init = false;
                    }
                }
                catch (Exception e) {
                    Path old = Paths.get(this.path + "_old", new String[0]);
                    CommonUtil.LOGGER.error("Exception when reading config file " + this.path + ", this config will be reset. Old config will be placed at " + old, (Throwable)e);
                    try {
                        Files.deleteIfExists(old);
                        Files.copy(this.path, old, new CopyOption[0]);
                    }
                    catch (IOException e1) {
                        CommonUtil.LOGGER.error("well this is embarrassing...", (Throwable)e1);
                    }
                    config = factory.get();
                }
            }
            if (init) {
                versionSetter.accept(config, currentVersion);
                this.write(config, false);
            }
            return config;
        });
    }

    private void write(T t, Path path, boolean invalidate) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(this.gson.toJson(t));
            if (invalidate) {
                this.invalidate();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isFileExists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    @Override
    public T get() {
        return this.getter.get();
    }

    @Override
    public void save() {
        this.write(this.get(), false);
    }

    @Override
    public void write(T t, boolean invalidate) {
        this.write(t, this.path, invalidate);
    }

    @Override
    public void invalidate() {
        this.getter.invalidate();
    }

    @Override
    public void backup(@Nullable String cause) {
        if (this.isFileExists()) {
            Path backupPath = Paths.get(this.path + "_" + DATE_FORMAT.format(new Date()), new String[0]);
            String msg = "Config " + this.path.getFileName() + " is getting backup to " + backupPath;
            if (cause != null) {
                msg = msg + " because of " + cause;
            }
            CommonUtil.LOGGER.info(msg);
            this.write(this.get(), backupPath, true);
        }
    }

    static class CachedSupplier<T> {
        private final Supplier<T> supplier;
        private T value;

        public CachedSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public T get() {
            return this.value == null ? (this.value = this.supplier.get()) : this.value;
        }

        public void invalidate() {
            this.value = null;
        }
    }

    public static class Builder<T>
    implements IJsonConfig.Builder0<T>,
    IJsonConfig.Builder1<T> {
        final Class<T> clazz;
        Path path;
        Gson gson;
        int currentVersion;
        ToIntFunction<T> versionGetter;
        ObjIntConsumer<T> versionSetter;
        Supplier<T> factory;

        public Builder(Class<T> clazz) {
            this.clazz = clazz;
            this.gson = DEFAULT_GSON;
            this.currentVersion = 0;
            this.versionGetter = DEFAULT_VERSION_GETTER;
            this.versionSetter = DEFAULT_VERSION_SETTER;
            this.factory = () -> {
                try {
                    return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create new config instance", e);
                }
            };
        }

        @Override
        public IJsonConfig.Builder1<T> file(File file) {
            this.path = file.toPath();
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> file(Path path) {
            this.path = path;
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> file(String fileName) {
            this.path = CommonUtil.configDir.resolve(fileName + (fileName.endsWith(".json") ? "" : ".json"));
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> version(int currentVersion, ToIntFunction<T> versionGetter, ObjIntConsumer<T> versionSetter) {
            this.currentVersion = currentVersion;
            this.versionGetter = versionGetter;
            this.versionSetter = versionSetter;
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> factory(Supplier<T> factory) {
            this.factory = factory;
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> gson(Gson gson) {
            this.gson = gson;
            return this;
        }

        @Override
        public IJsonConfig<T> build() {
            return new JsonConfig<T>(this.path, this.clazz, this.factory, this.gson, this.currentVersion, this.versionGetter, this.versionSetter);
        }
    }
}

