/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.util;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.LeafSettingsEntry;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.init.Leaves;
import randommcsomethin.fallingleaves.mixin.NativeImageAccessor;
import randommcsomethin.fallingleaves.mixin.SpriteAccessor;
import randommcsomethin.fallingleaves.util.RegistryUtil;
import randommcsomethin.fallingleaves.util.TextureCache;

public class LeafUtil {
    private static final Random renderRandom = new Random();

    public static void trySpawnLeafParticle(class_2680 state, class_1937 world, class_2338 pos, Random random, LeafSettingsEntry leafSettings) {
        double z;
        double y;
        double x = (double)pos.method_10263() + random.nextDouble();
        if (LeafUtil.shouldSpawnParticle(world, pos, x, y = (double)pos.method_10264(), z = (double)pos.method_10260() + random.nextDouble())) {
            boolean shouldColor;
            class_1058 sprite;
            class_310 client = class_310.method_1551();
            class_1087 model = client.method_1541().method_3349(state);
            renderRandom.setSeed(state.method_26190(pos));
            List quads = model.method_4707(state, class_2350.field_11033, renderRandom);
            if (!quads.isEmpty()) {
                boolean useFirstQuad = true;
                class_2960 id = class_2378.field_11146.method_10221((Object)state.method_26204());
                if (id.method_12836().equals("byg")) {
                    useFirstQuad = false;
                }
                class_777 quad = (class_777)quads.get(useFirstQuad ? 0 : quads.size() - 1);
                sprite = quad.method_35788();
                shouldColor = quad.method_3360();
            } else {
                sprite = model.method_4711();
                shouldColor = true;
            }
            class_2960 spriteId = sprite.method_4598();
            class_1011 texture = ((SpriteAccessor)sprite).getImages()[0];
            int blockColor = shouldColor ? client.method_1505().method_1697(state, (class_1920)world, pos, 0) : -1;
            double[] color = LeafUtil.calculateLeafColor(spriteId, texture, blockColor);
            double r = color[0];
            double g = color[1];
            double b = color[2];
            world.method_8406((class_2394)(leafSettings.isConiferBlock ? Leaves.FALLING_CONIFER_LEAF : Leaves.FALLING_LEAF), x, y, z, r, g, b);
        }
    }

    private static double[] calculateLeafColor(class_2960 spriteId, class_1011 texture, int blockColor) {
        double[] textureColor;
        TextureCache.Data cache = TextureCache.INST.get(spriteId);
        if (cache != null) {
            textureColor = cache.getColor();
        } else {
            textureColor = LeafUtil.averageColor(texture);
            TextureCache.INST.put(spriteId, new TextureCache.Data(textureColor));
            FallingLeavesClient.LOGGER.debug("{}: Calculated texture color {} ", (Object)spriteId, (Object)textureColor);
        }
        if (blockColor != -1) {
            textureColor[0] = textureColor[0] * ((double)(blockColor >> 16 & 0xFF) / 255.0);
            textureColor[1] = textureColor[1] * ((double)(blockColor >> 8 & 0xFF) / 255.0);
            textureColor[2] = textureColor[2] * ((double)(blockColor & 0xFF) / 255.0);
        }
        return textureColor;
    }

    private static boolean shouldSpawnParticle(class_1937 world, class_2338 pos, double x, double y, double z) {
        if (LeafUtil.isLeafBlock(world.method_8320(pos.method_10074()).method_26204(), true)) {
            return false;
        }
        double y2 = y - (double)Config.CONFIG.minimumFreeSpaceBelow * 0.5;
        class_238 collisionBox = new class_238(x - 0.1, y, z - 0.1, x + 0.1, y2, z + 0.1);
        return !world.method_20812(null, collisionBox).iterator().hasNext();
    }

    public static Map<class_2960, LeafSettingsEntry> getRegisteredLeafBlocks(boolean useBlockTags) {
        return class_2378.field_11146.method_10235().stream().filter(entry -> LeafUtil.isLeafBlock((class_2248)class_2378.field_11146.method_10223(entry), useBlockTags)).collect(Collectors.toMap(Function.identity(), LeafSettingsEntry::new));
    }

    public static boolean isLeafBlock(class_2248 block, boolean useBlockTags) {
        return block instanceof class_2397 || useBlockTags && block.method_9564().method_26164((class_3494)class_3481.field_15503);
    }

    @Nullable
    public static LeafSettingsEntry getLeafSettingsEntry(class_2680 blockState) {
        return Config.CONFIG.leafSettings.get(RegistryUtil.getBlockId(blockState));
    }

    public static double[] averageColor(class_1011 image) {
        if (image.method_4318() != class_1011.class_1012.field_4997) {
            FallingLeavesClient.LOGGER.error("RGBA image required, was {}", (Object)image.method_4318());
            return new double[]{1.0, 1.0, 1.0};
        }
        NativeImageAccessor imageAcc = (NativeImageAccessor)image;
        long pointer = imageAcc.getPointer();
        if (pointer == 0L) {
            FallingLeavesClient.LOGGER.error("image is not allocated");
            return new double[]{1.0, 1.0, 1.0};
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int n = 0;
        int width = image.method_4307();
        int height = image.method_4323();
        for (int i = 0; i < width * height; ++i) {
            int c = MemoryUtil.memGetInt((long)(pointer + 4L * (long)i));
            int cr = c & 0xFF;
            int cg = c >> 8 & 0xFF;
            int cb = c >> 16 & 0xFF;
            int ca = c >> 24 & 0xFF;
            if (ca == 0) continue;
            r += (double)cr;
            g += (double)cg;
            b += (double)cb;
            ++n;
        }
        return new double[]{r / (double)n / 255.0, g / (double)n / 255.0, b / (double)n / 255.0};
    }
}

