/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.darkenchanting.util;

import io.github.frqnny.darkenchanting.DarkEnchanting;
import io.github.frqnny.darkenchanting.config.DarkEnchantingConfig;
import io.github.frqnny.darkenchanting.init.ModBlocks;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;

public class BookcaseUtils {
    public static boolean getObsidianCount(class_1937 world, class_2338 blockPos) {
        int base_obsidian = 0;
        for (int z = -1; z <= 1; ++z) {
            for (int x = -1; x <= 1; ++x) {
                if (z == 0 && x == 0 || !world.method_22347(blockPos.method_10069(x, 0, z)) || !world.method_22347(blockPos.method_10069(x, 1, z))) continue;
                if (world.method_8320(blockPos.method_10069(x * 2, -1, z * 2)).method_27852(class_2246.field_22423)) {
                    ++base_obsidian;
                }
                if (x == 0 || z == 0) continue;
                if (world.method_8320(blockPos.method_10069(x * 2, -1, z)).method_27852(class_2246.field_22423)) {
                    ++base_obsidian;
                }
                if (!world.method_8320(blockPos.method_10069(x, -1, z * 2)).method_27852(class_2246.field_22423)) continue;
                ++base_obsidian;
            }
        }
        return base_obsidian == 16;
    }

    public static int getBookshelfCount(class_1937 world, class_2338 blockPos) {
        int bookshelves = 0;
        class_3494 bookshelvesTag = world.method_8514().method_33166(class_2378.field_25105, new class_2960("c", "bookshelves"), id -> new RuntimeException("Could not load tag: " + id.toString()));
        if (BookcaseUtils.getObsidianCount(world, blockPos)) {
            for (int y = 0; y <= 5; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    for (int x = -1; x <= 1; ++x) {
                        if (z == 0 && x == 0 || !world.method_22347(blockPos.method_10069(x, 0, z)) || !world.method_22347(blockPos.method_10069(x, 1, z))) continue;
                        if (world.method_8320(blockPos.method_10069(x * 2, y, z * 2)).method_26164(bookshelvesTag)) {
                            ++bookshelves;
                        }
                        if (x == 0 || z == 0) continue;
                        if (world.method_8320(blockPos.method_10069(x * 2, y, z)).method_26164(bookshelvesTag)) {
                            ++bookshelves;
                        }
                        if (!world.method_8320(blockPos.method_10069(x, y, z * 2)).method_26164(bookshelvesTag)) continue;
                        ++bookshelves;
                    }
                }
            }
            return Math.min(15, bookshelves);
        }
        return 0;
    }

    public static boolean getObsidianCount_2(class_1937 world, class_2338 blockPos) {
        int base_obsidian_2 = 0;
        int y = -1;
        for (int z = -4; z <= 4; ++z) {
            if (z == 0) continue;
            if (world.method_8320(blockPos.method_10069(4, y, z)).method_27852(class_2246.field_22423)) {
                ++base_obsidian_2;
            }
            if (z == 4 || !world.method_8320(blockPos.method_10069(-4, y, z)).method_27852(class_2246.field_22423)) continue;
            ++base_obsidian_2;
        }
        for (int x = -4; x <= 4; ++x) {
            if (x == 0) continue;
            if (world.method_8320(blockPos.method_10069(x, y, 4)).method_27852(class_2246.field_22423)) {
                ++base_obsidian_2;
            }
            if (x == 4 || !world.method_8320(blockPos.method_10069(x, y, -4)).method_27852(class_2246.field_22423)) continue;
            ++base_obsidian_2;
        }
        return Math.min(30, base_obsidian_2) == 30;
    }

    public static int getBookshelfCount_2(class_1937 world, class_2338 blockPos) {
        int bookshelves_2 = 0;
        class_3494 bookshelvesTag = world.method_8514().method_33166(class_2378.field_25105, new class_2960("c", "bookshelves"), id -> new RuntimeException("Could not load tag: " + id.toString()));
        if (BookcaseUtils.getObsidianCount_2(world, blockPos)) {
            for (int y = 0; y <= 5; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    if (z == 0) continue;
                    if (world.method_8320(blockPos.method_10069(4, y, z)).method_26164(bookshelvesTag)) {
                        ++bookshelves_2;
                    }
                    if (z == 4 || !world.method_8320(blockPos.method_10069(-4, y, z)).method_26164(bookshelvesTag)) continue;
                    ++bookshelves_2;
                }
                for (int x = -4; x <= 4; ++x) {
                    if (x == 0) continue;
                    if (world.method_8320(blockPos.method_10069(x, y, 4)).method_26164(bookshelvesTag)) {
                        ++bookshelves_2;
                    }
                    if (x == 4 || !world.method_8320(blockPos.method_10069(x, y, -4)).method_26164(bookshelvesTag)) continue;
                    ++bookshelves_2;
                }
            }
            return Math.min(29, bookshelves_2);
        }
        return 0;
    }

    public static int applyDiscount(int originalCost, class_1937 world, class_2338 pos) {
        return BookcaseUtils.applyDiscount(originalCost, BookcaseUtils.getDiscount(world, pos));
    }

    public static int applyDiscount(int originalCost, double discount) {
        return (int)Math.ceil((double)originalCost * (1.0 - discount));
    }

    public static double getDiscount(class_1937 world, class_2338 pos) {
        DarkEnchantingConfig config = DarkEnchanting.CONFIG;
        double configuredMaxDiscount = config.bookshelvesDiscount;
        double halfDiscount = configuredMaxDiscount / 2.0;
        double bookcase1 = (double)BookcaseUtils.getBookshelfCount(world, pos) / 15.0 * halfDiscount;
        double bookcase2 = (double)BookcaseUtils.getBookshelfCount_2(world, pos) / 29.0 * halfDiscount;
        return bookcase1 + bookcase2 + BookcaseUtils.getConduitDiscount(world, pos);
    }

    public static double getConduitDiscount(class_1937 world, class_2338 pos) {
        DarkEnchantingConfig config = DarkEnchanting.CONFIG;
        if ((double)BookcaseUtils.getBookshelfCount(world, pos) == 15.0 && (double)BookcaseUtils.getBookshelfCount_2(world, pos) == 29.0 && BookcaseUtils.getConduits(world, pos)) {
            return config.conduitDiscount;
        }
        return 0.0;
    }

    public static boolean getConduits(class_1937 world, class_2338 blockPos) {
        int conduitCount = 0;
        int y = 5;
        if (world.method_8320(blockPos.method_10069(4, y, 4)).method_27852((class_2248)ModBlocks.DARK_TORCH) && BookcaseUtils.checkObsidianTower(world, blockPos, 4, 4)) {
            ++conduitCount;
        }
        if (world.method_8320(blockPos.method_10069(-4, y, -4)).method_27852((class_2248)ModBlocks.DARK_TORCH) && BookcaseUtils.checkObsidianTower(world, blockPos, -4, -4)) {
            ++conduitCount;
        }
        if (world.method_8320(blockPos.method_10069(-4, y, 4)).method_27852((class_2248)ModBlocks.DARK_TORCH) && BookcaseUtils.checkObsidianTower(world, blockPos, -4, 4)) {
            ++conduitCount;
        }
        if (world.method_8320(blockPos.method_10069(4, y, -4)).method_27852((class_2248)ModBlocks.DARK_TORCH) && BookcaseUtils.checkObsidianTower(world, blockPos, 4, -4)) {
            ++conduitCount;
        }
        return conduitCount == 4;
    }

    public static boolean checkObsidianTower(class_1937 world, class_2338 pos, int x, int z) {
        for (int i = 0; i < 5; ++i) {
            if (world.method_8320(pos.method_10069(x, i, z)).method_27852(class_2246.field_10540)) continue;
            return false;
        }
        return true;
    }
}

