/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution.instruction;

import li.cil.tis3d.common.module.execution.Machine;
import li.cil.tis3d.common.module.execution.instruction.Instruction;
import li.cil.tis3d.common.module.execution.target.Target;
import li.cil.tis3d.common.module.execution.target.TargetInterface;

public final class JumpRelativeInstruction
implements Instruction {
    public static final String NAME = "JRO";
    private final Target source;

    public JumpRelativeInstruction(Target source) {
        this.source = source;
    }

    @Override
    public void step(Machine machine) {
        TargetInterface sourceInterface = machine.getInterface(this.source);
        if (!sourceInterface.isReading()) {
            sourceInterface.beginRead();
        }
        if (sourceInterface.canTransfer()) {
            machine.getState().pc += sourceInterface.read();
        }
    }

    public String toString() {
        return "JRO " + this.source;
    }
}

