/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import java.util.Optional;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.BlockChangeAware;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.serial.SerialInterface;
import li.cil.tis3d.api.serial.SerialInterfaceProvider;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.common.API;
import li.cil.tis3d.util.WorldUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public final class SerialPortModule
extends AbstractModule
implements BlockChangeAware {
    private short writing;
    private static final String TAG_VALUE = "value";
    private static final String TAG_SERIAL_INTERFACE = "serialInterface";
    private Optional<SerialInterface> serialInterface = Optional.empty();
    private Optional<class_2487> serialInterfaceNbt = Optional.empty();
    private boolean isScanScheduled = true;

    public SerialPortModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void onNeighborBlockChange(class_2338 neighborPos, boolean isModuleNeighbor) {
        if (isModuleNeighbor) {
            this.isScanScheduled = true;
        }
    }

    @Override
    public void step() {
        this.scan();
        this.stepOutput();
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        this.serialInterface.ifPresent(SerialInterface::reset);
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.serialInterface.ifPresent(SerialInterface::skip);
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        class_4588 vc = vcp.getBuffer(class_1921.method_23579());
        class_1058 sprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_MODULE_SERIAL_PORT);
        RenderUtil.drawQuad(sprite, matrices.method_23760(), vc, RenderUtil.maxLight, overlay);
    }

    @Override
    public void readFromNBT(class_2487 nbt) {
        super.readFromNBT(nbt);
        this.writing = nbt.method_10568(TAG_VALUE);
        if (nbt.method_10545(TAG_SERIAL_INTERFACE)) {
            if (this.serialInterface.isPresent()) {
                this.serialInterface.get().readFromNBT(nbt.method_10562(TAG_SERIAL_INTERFACE));
            } else {
                this.serialInterfaceNbt = Optional.of(nbt.method_10562(TAG_SERIAL_INTERFACE));
            }
        }
    }

    @Override
    public void writeToNBT(class_2487 nbt) {
        super.writeToNBT(nbt);
        nbt.method_10575(TAG_VALUE, this.writing);
        if (this.serialInterface.isPresent()) {
            class_2487 serialInterfaceNbt = new class_2487();
            this.serialInterface.get().writeToNBT(serialInterfaceNbt);
            if (!nbt.method_33133()) {
                nbt.method_10566(TAG_SERIAL_INTERFACE, (class_2520)serialInterfaceNbt);
            }
        }
    }

    private void scan() {
        if (!this.isScanScheduled) {
            return;
        }
        this.isScanScheduled = false;
        class_1937 world = this.getCasing().getCasingWorld();
        class_2338 neighborPos = this.getCasing().getPosition().method_10093(Face.toDirection(this.getFace()));
        class_2350 neighborSide = Face.toDirection(this.getFace().getOpposite());
        if (WorldUtils.isBlockLoaded((class_1936)world, neighborPos)) {
            SerialInterfaceProvider provider = API.serial.getProviderFor(world, neighborPos, neighborSide);
            if (provider != null) {
                if (!this.serialInterface.map(s -> provider.isValid(world, neighborPos, neighborSide, (SerialInterface)s)).orElse(false).booleanValue()) {
                    this.reset();
                    this.serialInterface = Optional.ofNullable(provider.interfaceFor(world, neighborPos, neighborSide));
                    if (this.serialInterface.isPresent() && this.serialInterfaceNbt.isPresent()) {
                        this.serialInterface.get().readFromNBT(this.serialInterfaceNbt.get());
                        this.serialInterfaceNbt = Optional.empty();
                    }
                }
            } else {
                this.reset();
            }
        } else {
            this.reset();
        }
    }

    private void reset() {
        this.serialInterface.ifPresent(SerialInterface::reset);
        this.serialInterface = Optional.empty();
        this.cancelRead();
        this.cancelWrite();
    }

    private void stepOutput() {
        if (this.serialInterface.map(SerialInterface::canRead).orElse(false).booleanValue()) {
            short value = this.serialInterface.map(SerialInterface::peek).orElse((short)0);
            if (value != this.writing) {
                this.cancelWrite();
                this.writing = value;
            }
            for (Port port : Port.VALUES) {
                Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
                if (sendingPipe.isWriting()) continue;
                sendingPipe.beginWrite(this.writing);
            }
        } else {
            this.cancelWrite();
        }
    }

    private void stepInput() {
        if (this.serialInterface.map(SerialInterface::canWrite).orElse(false).booleanValue()) {
            for (Port port : Port.VALUES) {
                Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
                if (!receivingPipe.isReading()) {
                    receivingPipe.beginRead();
                }
                if (!receivingPipe.canTransfer()) continue;
                this.serialInterface.ifPresent(s -> s.write(receivingPipe.read()));
            }
        } else {
            this.cancelRead();
        }
    }
}

