/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import java.util.Optional;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.util.ColorUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public final class KeypadModule
extends AbstractModuleWithRotation {
    private Optional<Short> value = Optional.empty();
    private static final String TAG_VALUE = "value";
    private static final byte DATA_TYPE_VALUE = 0;
    private static final float KEYS_U0 = 0.15625f;
    private static final float KEYS_V0 = 0.15625f;
    private static final float KEYS_SIZE_U = 0.15625f;
    private static final float KEYS_SIZE_V = 0.15625f;
    private static final float KEYS_SIZE_V_LAST = 0.125f;
    private static final float KEYS_STEP_U = 0.1875f;
    private static final float KEYS_STEP_V = 0.1875f;
    private static final float[] VALUE_TO_PITCH = new float[]{0.9125f, 0.7f, 0.75f, 0.825f, 0.725f, 0.8f, 0.875f, 0.775f, 0.85f, 0.95f};

    public KeypadModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepOutput();
    }

    @Override
    public void onDisabled() {
        if (this.value.isPresent()) {
            this.value = Optional.empty();
            this.getCasing().sendData(this.getFace(), new class_2487(), (byte)0);
        }
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.value = Optional.empty();
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.getCasing().sendData(this.getFace(), new class_2487(), (byte)0);
    }

    @Override
    public boolean onActivate(class_1657 player, class_1268 hand, class_243 hit) {
        if (player.method_5715()) {
            return false;
        }
        if (!this.getCasing().isEnabled()) {
            return true;
        }
        if (this.value.isPresent()) {
            return true;
        }
        class_1937 world = this.getCasing().getCasingWorld();
        if (world.field_9236) {
            class_243 uv = this.hitToUV(hit);
            int button = this.uvToButton((float)uv.field_1352, (float)uv.field_1351);
            if (button == -1) {
                return true;
            }
            short number = this.buttonToNumber(button);
            class_2487 nbt = new class_2487();
            nbt.method_10575(TAG_VALUE, number);
            this.getCasing().sendData(this.getFace(), nbt, (byte)0);
        }
        return true;
    }

    @Override
    public void onData(class_2487 nbt) {
        class_1937 world = this.getCasing().getCasingWorld();
        if (world.field_9236) {
            this.value = nbt.method_10545(TAG_VALUE) ? Optional.of(nbt.method_10568(TAG_VALUE)) : Optional.empty();
        } else if (!this.value.isPresent() && nbt.method_10545(TAG_VALUE)) {
            short newValue = nbt.method_10568(TAG_VALUE);
            this.value = Optional.of(newValue);
            this.getCasing().sendData(this.getFace(), nbt, (byte)0);
            this.getCasing().getCasingWorld().method_8396(null, this.getCasing().getPosition(), class_3417.field_14791, class_3419.field_15245, 0.3f, VALUE_TO_PITCH[newValue]);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        class_243 hitPos;
        if (!this.getCasing().isEnabled() || !this.isVisible()) {
            return;
        }
        matrices.method_22903();
        this.rotateForRendering(matrices);
        int bright = this.value.isPresent() ? 128 : 255;
        class_1058 baseSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_MODULE_KEYPAD);
        class_4588 vc = vcp.getBuffer(class_1921.method_23579());
        RenderUtil.drawQuad(baseSprite, matrices.method_23760(), vc, 255, bright, bright, bright, RenderUtil.maxLight, overlay);
        if (this.value.isEmpty() && (hitPos = this.getObserverLookAt(rendererDispatcher)) != null) {
            class_243 uv = this.hitToUV(hitPos);
            int button = this.uvToButton((float)uv.field_1352, (float)uv.field_1351);
            if (button >= 0) {
                this.drawButtonOverlay(matrices, vc, RenderUtil.maxLight, overlay, button);
            }
        }
        matrices.method_22909();
    }

    @Override
    public void readFromNBT(class_2487 nbt) {
        super.readFromNBT(nbt);
        if (nbt.method_10545(TAG_VALUE)) {
            this.value = Optional.of(nbt.method_10568(TAG_VALUE));
        }
    }

    @Override
    public void writeToNBT(class_2487 nbt) {
        super.writeToNBT(nbt);
        this.value.ifPresent(x -> nbt.method_10575(TAG_VALUE, x.shortValue()));
    }

    private void stepOutput() {
        if (!this.value.isPresent()) {
            return;
        }
        short v = this.value.get();
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(v);
        }
    }

    private int uvToButton(float u, float v) {
        int button;
        float u0;
        if (u < 0.15625f || u > 0.6875f) {
            return -1;
        }
        if (v < 0.15625f || v > 0.875f) {
            return -1;
        }
        int row = 0;
        float v0 = v - 0.15625f;
        while (true) {
            float f = row == 3 ? 0.125f : 0.15625f;
            if (!(v0 > f)) break;
            ++row;
            v0 -= 0.1875f;
        }
        if (v0 < 0.0f) {
            return -1;
        }
        int column = row == 3 ? -1 : 0;
        for (u0 = u - 0.15625f; u0 > 0.15625f; u0 -= 0.1875f) {
            ++column;
        }
        if (u0 < 0.0f && row != 3 && column != 1) {
            return -1;
        }
        if (column < 0) {
            column = 0;
        }
        if ((button = row * 3 + column) > 9) {
            return -1;
        }
        return button;
    }

    private short buttonToNumber(int button) {
        return (short)((button + 1) % 10);
    }

    @Environment(value=EnvType.CLIENT)
    private void drawButtonOverlay(class_4587 matrices, class_4588 vcColor, int light, int overlay, int button) {
        int column = button % 3;
        int row = button / 3;
        float x = 0.15625f + (float)column * 0.1875f;
        float y = 0.15625f + (float)row * 0.1875f;
        float w = this.buttonToNumber(button) == 0 ? 0.34375f : 0.15625f;
        float h = row == 3 ? 0.125f : 0.15625f;
        float delta = 0.015625f;
        matrices.method_22904(0.0, 0.0, (double)0.0025f);
        RenderUtil.drawColorQuad(matrices.method_23760(), vcColor, x - 0.015625f, y - 0.015625f, w + 0.03125f, h + 0.03125f, ColorUtils.WHITE, light, overlay);
    }
}

