/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.BlockChangeAware;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.client.render.font.AbstractFontRenderer;
import li.cil.tis3d.client.render.font.SmallFontRenderer;
import li.cil.tis3d.common.Constants;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.item.CodeBookItem;
import li.cil.tis3d.common.module.execution.MachineImpl;
import li.cil.tis3d.common.module.execution.MachineState;
import li.cil.tis3d.common.module.execution.compiler.Compiler;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.util.ColorUtils;
import li.cil.tis3d.util.EnumUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public final class ExecutionModule
extends AbstractModuleWithRotation
implements BlockChangeAware {
    private final MachineImpl machine;
    private ParseException compileError;
    private State state = State.IDLE;
    private static final String TAG_STATE = "state";
    private static final String TAG_MACHINE = "machine";
    private static final String TAG_COMPILE_ERROR = "compileError";
    private static final String TAG_MESSAGE = "message";
    private static final String TAG_LINE_NUMBER = "lineNumber";
    private static final String TAG_START = "columnStart";
    private static final String TAG_END = "columnEnd";
    private static final byte DATA_TYPE_FULL = 0;
    private static final byte DATA_TYPE_INCREMENTAL = 1;
    private static final List<SourceCodeProvider> providers = new ArrayList<SourceCodeProvider>(Arrays.asList(new SourceCodeProviderVanilla(), new SourceCodeProviderBookCode()));

    public ExecutionModule(Casing casing, Face face) {
        super(casing, face);
        this.machine = new MachineImpl(this, face);
    }

    public MachineState getState() {
        return this.machine.getState();
    }

    @Override
    public void step() {
        State prevState = this.state;
        if (this.compileError != null) {
            this.state = State.ERR;
        } else if (this.getState().instructions.isEmpty()) {
            this.state = State.IDLE;
        } else {
            if (this.machine.step()) {
                this.state = State.RUN;
                this.getCasing().markDirty();
                this.sendPartialState();
                return;
            }
            this.state = State.WAIT;
        }
        if (prevState != this.state) {
            this.getCasing().markDirty();
            this.sendPartialState();
        }
    }

    @Override
    public void onEnabled() {
        this.sendFullState();
    }

    @Override
    public void onDisabled() {
        this.getState().reset();
        this.state = State.IDLE;
        this.sendPartialState();
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        if (this.compileError == null) {
            this.machine.onBeforeWriteComplete(port);
        }
    }

    @Override
    public void onWriteComplete(Port port) {
        if (this.compileError == null) {
            this.machine.onWriteCompleted(port);
        }
    }

    @Override
    public boolean onActivate(class_1657 player, class_1268 hand, class_243 hit) {
        class_1799 heldItem = player.method_5998(hand);
        if (heldItem.method_7909() == class_1802.field_8529) {
            if (!player.method_5770().field_9236) {
                if (!player.method_31549().field_7477) {
                    heldItem.method_7971(1);
                }
                class_1799 bookCode = new class_1799((class_1935)Items.BOOK_CODE);
                if (player.method_31548().method_7394(bookCode)) {
                    player.field_7498.method_7623();
                }
                if (bookCode.method_7947() > 0) {
                    player.method_7329(bookCode, false, false);
                }
            }
            return true;
        }
        if (Items.isBookCode(heldItem) && player.method_5715()) {
            CodeBookItem.Data data = CodeBookItem.Data.loadFromStack(heldItem);
            if (this.getState().code != null && this.getState().code.length > 0) {
                data.addOrSelectProgram(Arrays.asList(this.getState().code));
                CodeBookItem.Data.saveToStack(heldItem, data);
            }
            return true;
        }
        if (player.method_5715()) {
            return false;
        }
        if (this.getCasing().isLocked()) {
            return false;
        }
        SourceCodeProvider provider = ExecutionModule.providerFor(heldItem);
        if (provider == null) {
            return false;
        }
        Iterable<String> code = provider.codeFor(heldItem);
        if (code == null || !code.iterator().hasNext()) {
            return true;
        }
        class_1937 world = this.getCasing().getCasingWorld();
        if (!world.field_9236) {
            this.compile(code, player);
            this.sendFullState();
        }
        return true;
    }

    @Override
    public void onData(class_2487 nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public void onData(ByteBuf data) {
        MachineState machineState = this.getState();
        machineState.pc = data.readShort();
        machineState.acc = data.readShort();
        machineState.bak = data.readShort();
        machineState.last = data.readBoolean() ? Optional.of(Port.values()[data.readByte()]) : Optional.empty();
        this.state = State.values()[data.readByte()];
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        if (!(this.getCasing().isEnabled() && this.isVisible() || this.isObserverLookingAt(rendererDispatcher))) {
            return;
        }
        matrices.method_22903();
        this.rotateForRendering(matrices);
        class_1058 baseSprite = RenderUtil.getSprite(RenderData.STATE_LOCATIONS[this.state.ordinal()]);
        class_4588 vc = vcp.getBuffer(class_1921.method_23579());
        RenderUtil.drawQuad(baseSprite, matrices.method_23760(), vc, RenderUtil.maxLight, overlay);
        MachineState machineState = this.getState();
        if (machineState.code != null && rendererDispatcher.field_4344.method_19328().method_10262((class_2382)this.getCasing().getPosition()) < 64.0) {
            this.renderState(matrices, vcp, RenderUtil.maxLight, overlay, machineState);
        }
        matrices.method_22909();
    }

    @Override
    public void readFromNBT(class_2487 nbt) {
        super.readFromNBT(nbt);
        class_2487 machineNbt = nbt.method_10562(TAG_MACHINE);
        this.getState().readFromNBT(machineNbt);
        this.state = EnumUtils.readFromNBT(State.class, TAG_STATE, nbt);
        if (nbt.method_10545(TAG_COMPILE_ERROR)) {
            class_2487 errorNbt = nbt.method_10562(TAG_COMPILE_ERROR);
            this.compileError = new ParseException(errorNbt.method_10558(TAG_MESSAGE), errorNbt.method_10550(TAG_LINE_NUMBER), errorNbt.method_10550(TAG_START), errorNbt.method_10550(TAG_END));
        } else {
            this.compileError = null;
        }
    }

    @Override
    public void writeToNBT(class_2487 nbt) {
        super.writeToNBT(nbt);
        class_2487 machineNbt = new class_2487();
        this.getState().writeToNBT(machineNbt);
        nbt.method_10566(TAG_MACHINE, (class_2520)machineNbt);
        EnumUtils.writeToNBT(this.state, TAG_STATE, nbt);
        if (this.compileError != null) {
            class_2487 errorNbt = new class_2487();
            errorNbt.method_10582(TAG_MESSAGE, this.compileError.getMessage());
            errorNbt.method_10569(TAG_LINE_NUMBER, this.compileError.getLineNumber());
            errorNbt.method_10569(TAG_START, this.compileError.getStart());
            errorNbt.method_10569(TAG_END, this.compileError.getEnd());
            nbt.method_10566(TAG_COMPILE_ERROR, (class_2520)errorNbt);
        }
    }

    @Override
    public void onNeighborBlockChange(class_2338 neighborPos, boolean isModuleNeighbor) {
        if (isModuleNeighbor && this.isVisible()) {
            this.sendPartialState();
        }
    }

    private void compile(Iterable<String> code, class_1657 player) {
        this.compileError = null;
        try {
            this.getState().clear();
            Compiler.compile(code, this.getState());
        }
        catch (ParseException e) {
            this.compileError = e;
            player.method_7353((class_2561)new class_2588("tis3d.compiler.error", new Object[]{e.getLineNumber(), e.getStart(), e.getEnd()}).method_10852((class_2561)new class_2588(e.getMessage())), false);
        }
    }

    private void sendFullState() {
        class_2487 nbt = new class_2487();
        this.writeToNBT(nbt);
        this.getCasing().sendData(this.getFace(), nbt, (byte)0);
    }

    private void sendPartialState() {
        if (!this.isVisible()) {
            return;
        }
        ByteBuf data = Unpooled.buffer();
        data.writeShort((int)((short)this.getState().pc));
        data.writeShort((int)this.getState().acc);
        data.writeShort((int)this.getState().bak);
        data.writeBoolean(this.getState().last.isPresent());
        this.getState().last.ifPresent(port -> data.writeByte((int)((byte)port.ordinal())));
        data.writeByte(this.state.ordinal());
        this.getCasing().sendData(this.getFace(), data, (byte)1);
    }

    @Environment(value=EnvType.CLIENT)
    private void renderState(class_4587 matrices, class_4597 vcp, int light, int overlay, MachineState machineState) {
        int color;
        matrices.method_22904(0.21875, 0.21875, 0.0);
        matrices.method_22905(0.0078125f, 0.0078125f, 1.0f);
        matrices.method_22904(1.0, 1.0, 0.0);
        AbstractFontRenderer fontRenderer = (AbstractFontRenderer)SmallFontRenderer.INSTANCE;
        class_4588 vcFont = fontRenderer.chooseVertexConsumer(vcp);
        String accLast = String.format("ACC:%4X LAST:%s", machineState.acc, machineState.last.map(Enum::name).orElse("NONE"));
        fontRenderer.drawString(matrices.method_23760(), vcFont, light, overlay, accLast);
        matrices.method_22904(0.0, (double)(fontRenderer.getCharHeight() + 4), 0.0);
        String bakState = String.format("BAK:%4X MODE:%s", machineState.bak, this.state.name());
        fontRenderer.drawString(matrices.method_23760(), vcFont, light, overlay, bakState);
        matrices.method_22904(0.0, (double)(fontRenderer.getCharHeight() + 4), 0.0);
        matrices.method_22903();
        matrices.method_22904(0.0, 5.0, 0.0);
        int maxLines = 50 / (fontRenderer.getCharHeight() + 1);
        int totalLines = machineState.code.length;
        int currentLine = machineState.lineNumbers.size() > 0 ? Optional.ofNullable(machineState.lineNumbers.get(machineState.pc)).orElse(-1) : (this.compileError != null ? this.compileError.getLineNumber() : -1);
        int page = currentLine / maxLines;
        int offset = page * maxLines;
        int currentLineBgColor = color = ColorUtils.WHITE;
        int yDeltaSum = 5;
        int currentLineOffset = -1;
        for (int lineNumber = offset; lineNumber < Math.min(totalLines, offset + maxLines); ++lineNumber) {
            String line = machineState.code[lineNumber];
            if (lineNumber == currentLine) {
                if (this.state == State.WAIT) {
                    currentLineBgColor = -5723992;
                } else if (this.state == State.ERR || this.compileError != null && this.compileError.getLineNumber() == currentLine) {
                    currentLineBgColor = -65536;
                }
                currentLineOffset = yDeltaSum;
                color = -16777216;
            } else {
                color = ColorUtils.WHITE;
            }
            fontRenderer.drawString(matrices.method_23760(), vcFont, light, overlay, color, line, 18);
            int yDelta = fontRenderer.getCharHeight() + 1;
            yDeltaSum += yDelta;
            matrices.method_22904(0.0, (double)yDelta, 0.0);
        }
        matrices.method_22909();
        class_4588 vcColor = vcp.getBuffer(class_1921.method_23577());
        ExecutionModule.drawLine(matrices.method_23760(), vcColor, light, overlay, ColorUtils.WHITE, 1);
        if (currentLineOffset != -1) {
            matrices.method_22904(0.0, (double)currentLineOffset, (double)0.0025f);
            ExecutionModule.drawLine(matrices.method_23760(), vcColor, light, overlay, currentLineBgColor, fontRenderer.getCharHeight());
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void drawLine(class_4587.class_4665 matrices, class_4588 vcColor, int light, int overlay, int color, int height) {
        RenderUtil.drawColorQuad(matrices, vcColor, -0.5f, -0.5f, 72.0f, height + 1, color, light, overlay);
    }

    @Nullable
    private static SourceCodeProvider providerFor(class_1799 stack) {
        if (!stack.method_7960()) {
            return providers.stream().filter(p -> p.worksFor(stack)).findFirst().orElse(null);
        }
        return null;
    }

    public static enum State {
        IDLE,
        ERR,
        RUN,
        WAIT;

    }

    private static interface SourceCodeProvider {
        public boolean worksFor(class_1799 var1);

        @Nullable
        public Iterable<String> codeFor(class_1799 var1);
    }

    @Environment(value=EnvType.CLIENT)
    private static final class RenderData {
        static final class_2960[] STATE_LOCATIONS = new class_2960[]{Textures.LOCATION_OVERLAY_MODULE_EXECUTION_IDLE, Textures.LOCATION_OVERLAY_MODULE_EXECUTION_ERROR, Textures.LOCATION_OVERLAY_MODULE_EXECUTION_RUNNING, Textures.LOCATION_OVERLAY_MODULE_EXECUTION_WAITING};

        private RenderData() {
        }
    }

    private static final class SourceCodeProviderVanilla
    implements SourceCodeProvider {
        private SourceCodeProviderVanilla() {
        }

        @Override
        public boolean worksFor(class_1799 stack) {
            return Items.isItem(stack, class_1802.field_8360) || Items.isItem(stack, class_1802.field_8674);
        }

        @Override
        public Iterable<String> codeFor(class_1799 stack) {
            class_2487 nbt = stack.method_7969();
            if (nbt == null) {
                return null;
            }
            class_2499 pages = nbt.method_10554("pages", 8);
            if (pages.size() < 1) {
                return null;
            }
            ArrayList<String> code = new ArrayList<String>();
            for (int page = 0; page < pages.size(); ++page) {
                Collections.addAll(code, Constants.PATTERN_LINES.split(pages.method_10608(page)));
            }
            return code;
        }
    }

    private static final class SourceCodeProviderBookCode
    implements SourceCodeProvider {
        private SourceCodeProviderBookCode() {
        }

        @Override
        public boolean worksFor(class_1799 stack) {
            return Items.isBookCode(stack);
        }

        @Override
        public Iterable<String> codeFor(class_1799 stack) {
            CodeBookItem.Data data = CodeBookItem.Data.loadFromStack(stack);
            if (data.getPageCount() < 1) {
                return null;
            }
            return data.getProgram();
        }
    }
}

