/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.machine;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.ModuleProvider;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.common.API;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.network.Network;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public final class CasingImpl
implements Casing {
    private final Module[] modules = new Module[Face.VALUES.length];
    private UUID lock = null;
    private static final String TAG_MODULES = "modules";
    private static final String TAG_KEY_MS = "keyMostSignificant";
    private static final String TAG_KEY_LS = "keyLeastSignificant";
    private final CasingBlockEntity blockEntity;

    public CasingImpl(CasingBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public void onEnabled() {
        for (Module module : this.modules) {
            if (module == null) continue;
            module.onEnabled();
        }
        this.markDirty();
    }

    public void onDisabled() {
        for (Module module : this.modules) {
            if (module == null) continue;
            module.onDisabled();
        }
        for (Pipe pipe : this.blockEntity.getPipes()) {
            pipe.cancelRead();
            pipe.cancelWrite();
        }
        this.markDirty();
    }

    public void onDisposed() {
        for (Module module : this.modules) {
            if (module == null) continue;
            module.onDisposed();
        }
    }

    public void stepModules() {
        for (Module module : this.modules) {
            if (module == null) continue;
            module.step();
        }
    }

    public void setModule(Face face, @Nullable Module module) {
        if (this.getModule(face) == module) {
            return;
        }
        Module oldModule = this.getModule(face);
        if (this.blockEntity.isEnabled() && oldModule != null && !this.getCasingWorld().field_9236) {
            oldModule.onDisabled();
        }
        boolean hadRedstone = oldModule instanceof Redstone;
        this.modules[face.ordinal()] = module;
        if (hadRedstone && !this.getCasingWorld().field_9236) {
            this.blockEntity.method_5431();
            this.getCasingWorld().method_8452(this.getPosition(), this.blockEntity.method_11010().method_26204());
        }
        if (module == null) {
            for (Port port : Port.VALUES) {
                this.getReceivingPipe(face, port).cancelRead();
                this.getSendingPipe(face, port).cancelWrite();
            }
        }
        if (this.blockEntity.isEnabled() && module != null && !this.getCasingWorld().field_9236) {
            module.onEnabled();
        }
        this.blockEntity.method_5431();
    }

    @Environment(value=EnvType.CLIENT)
    public void setLocked(boolean locked) {
        this.lock = locked ? UUID.randomUUID() : null;
    }

    public void lock(class_1799 stack) {
        if (this.isLocked()) {
            throw new IllegalStateException("Casing is already locked.");
        }
        if (Items.isKeyCreative(stack)) {
            this.lock = UUID.randomUUID();
        } else {
            UUID key = CasingImpl.getKeyFromStack(stack).orElse(UUID.randomUUID());
            CasingImpl.setKeyForStack(stack, key);
            this.lock = key;
        }
    }

    public boolean unlock(class_1799 stack) {
        if (Items.isKeyCreative(stack)) {
            this.lock = null;
            return true;
        }
        return CasingImpl.getKeyFromStack(stack).map(this::unlock).orElse(false);
    }

    public boolean unlock(UUID key) {
        if (key.equals(this.lock)) {
            this.lock = null;
            return true;
        }
        return false;
    }

    public void readFromNBT(class_2487 nbt) {
        for (int index = 0; index < this.blockEntity.method_5439(); ++index) {
            Module module;
            class_1799 stack = this.blockEntity.method_5438(index);
            if (stack.method_7960()) {
                if (this.modules[index] != null) {
                    this.modules[index].onDisposed();
                }
                this.modules[index] = null;
                continue;
            }
            Face face = Face.VALUES[index];
            ModuleProvider provider = API.module.getProviderFor(stack, this.blockEntity, face);
            if (provider == null) {
                if (this.modules[index] != null) {
                    this.modules[index].onDisposed();
                }
                this.modules[index] = null;
                continue;
            }
            this.modules[index] = module = provider.createModule(stack, this.blockEntity, face);
        }
        class_2499 modulesNbt = nbt.method_10554(TAG_MODULES, 10);
        int moduleCount = Math.min(modulesNbt.size(), this.modules.length);
        for (int i = 0; i < moduleCount; ++i) {
            if (this.modules[i] == null) continue;
            this.modules[i].readFromNBT(modulesNbt.method_10602(i));
        }
        this.lock = nbt.method_10545(TAG_KEY_MS) && nbt.method_10545(TAG_KEY_LS) ? new UUID(nbt.method_10537(TAG_KEY_MS), nbt.method_10537(TAG_KEY_LS)) : null;
    }

    public void writeToNBT(class_2487 nbt) {
        class_2499 modulesNbt = new class_2499();
        for (Module module : this.modules) {
            class_2487 moduleNbt = new class_2487();
            if (module != null) {
                module.writeToNBT(moduleNbt);
            }
            modulesNbt.add((Object)moduleNbt);
        }
        nbt.method_10566(TAG_MODULES, (class_2520)modulesNbt);
        if (this.lock != null) {
            nbt.method_10544(TAG_KEY_MS, this.lock.getMostSignificantBits());
            nbt.method_10544(TAG_KEY_LS, this.lock.getLeastSignificantBits());
        }
    }

    @Override
    public class_1937 getCasingWorld() {
        return Objects.requireNonNull(this.blockEntity.method_10997());
    }

    @Override
    public class_2338 getPosition() {
        return this.blockEntity.method_11016();
    }

    @Override
    public void markDirty() {
        this.blockEntity.method_5431();
    }

    @Override
    public boolean isEnabled() {
        return this.blockEntity.isCasingEnabled();
    }

    @Override
    public boolean isLocked() {
        return this.lock != null;
    }

    @Override
    @Nullable
    public Module getModule(Face face) {
        return this.modules[face.ordinal()];
    }

    @Override
    public Pipe getReceivingPipe(Face face, Port port) {
        return this.blockEntity.getReceivingPipe(face, port);
    }

    @Override
    public Pipe getSendingPipe(Face face, Port port) {
        return this.blockEntity.getSendingPipe(face, port);
    }

    @Override
    public void sendData(Face face, class_2487 data, byte type) {
        Network.INSTANCE.sendModuleData((Casing)this, face, data, type);
    }

    @Override
    public void sendData(Face face, class_2487 data) {
        this.sendData(face, data, (byte)-1);
    }

    @Override
    public void sendData(Face face, ByteBuf data, byte type) {
        Network.INSTANCE.sendModuleData((Casing)this, face, data, type);
    }

    @Override
    public void sendData(Face face, ByteBuf data) {
        this.sendData(face, data, (byte)-1);
    }

    private static Optional<UUID> getKeyFromStack(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return Optional.empty();
        }
        if (!nbt.method_10545(TAG_KEY_MS) || !nbt.method_10545(TAG_KEY_LS)) {
            return Optional.empty();
        }
        return Optional.of(new UUID(nbt.method_10537(TAG_KEY_MS), nbt.method_10537(TAG_KEY_LS)));
    }

    private static void setKeyForStack(class_1799 stack, UUID key) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            nbt = new class_2487();
            stack.method_7980(nbt);
        }
        nbt.method_10544(TAG_KEY_MS, key.getMostSignificantBits());
        nbt.method_10544(TAG_KEY_LS, key.getLeastSignificantBits());
    }
}

